/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.lang.Language;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.collections.ArraysKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.idea.util.ReflectionUtil;

public class KotlinCommonCodeStyleSettings
extends CommonCodeStyleSettings {
    @ReflectionUtil.SkipInEquals
    public String CODE_STYLE_DEFAULTS = null;
    private final boolean isTempForDeserialize;
    private static final String INDENT_OPTIONS_TAG = "indentOptions";
    private static final String ARRANGEMENT_ELEMENT_NAME = "arrangement";

    public KotlinCommonCodeStyleSettings() {
        this(false);
    }

    private KotlinCommonCodeStyleSettings(boolean isTempForDeserialize) {
        super((Language)KotlinLanguage.INSTANCE);
        this.isTempForDeserialize = isTempForDeserialize;
    }

    private static KotlinCommonCodeStyleSettings createForTempDeserialize() {
        return new KotlinCommonCodeStyleSettings(true);
    }

    public void readExternal(Element element3) {
        if (this.isTempForDeserialize) {
            super.readExternal(element3);
            return;
        }
        KotlinCommonCodeStyleSettings tempDeserialize = KotlinCommonCodeStyleSettings.createForTempDeserialize();
        tempDeserialize.readExternal(element3);
        FormatterUtilKt.applyKotlinCodeStyle(tempDeserialize.CODE_STYLE_DEFAULTS, this, true);
        super.readExternal(element3);
    }

    public void writeExternal(@NotNull Element element3, @NotNull LanguageCodeStyleProvider provider2) {
        if (element3 == null) {
            KotlinCommonCodeStyleSettings.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            KotlinCommonCodeStyleSettings.$$$reportNull$$$0(1);
        }
        CommonCodeStyleSettings defaultSettings = provider2.getDefaultCommonSettings();
        FormatterUtilKt.applyKotlinCodeStyle(this.CODE_STYLE_DEFAULTS, defaultSettings, false);
        this.writeExternalBase(element3, defaultSettings, provider2);
    }

    private void writeExternalBase(@NotNull Element element3, @NotNull CommonCodeStyleSettings defaultSettings, @NotNull LanguageCodeStyleProvider provider2) {
        ArrangementSettings myArrangementSettings;
        Set supportedFields;
        if (element3 == null) {
            KotlinCommonCodeStyleSettings.$$$reportNull$$$0(2);
        }
        if (defaultSettings == null) {
            KotlinCommonCodeStyleSettings.$$$reportNull$$$0(3);
        }
        if (provider2 == null) {
            KotlinCommonCodeStyleSettings.$$$reportNull$$$0(4);
        }
        if ((supportedFields = provider2.getSupportedFields()) == null) {
            return;
        }
        supportedFields.add("FORCE_REARRANGE_MODE");
        supportedFields.add("CODE_STYLE_DEFAULTS");
        DefaultJDOMExternalizer.write((Object)((Object)this), (Element)element3, (Predicate)new CommonCodeStyleSettings.SupportedFieldsDiffFilter((CommonCodeStyleSettings)this, supportedFields, defaultSettings));
        List softMargins = this.getSoftMargins();
        this.serializeInto(softMargins, element3);
        CommonCodeStyleSettings.IndentOptions myIndentOptions = this.getIndentOptions();
        if (myIndentOptions != null) {
            CommonCodeStyleSettings.IndentOptions defaultIndentOptions = defaultSettings.getIndentOptions();
            Element indentOptionsElement = new Element(INDENT_OPTIONS_TAG);
            myIndentOptions.serialize(indentOptionsElement, defaultIndentOptions);
            if (!indentOptionsElement.getChildren().isEmpty()) {
                element3.addContent(indentOptionsElement);
            }
        }
        if ((myArrangementSettings = this.getArrangementSettings()) != null) {
            Element container2 = new Element(ARRANGEMENT_ELEMENT_NAME);
            ArrangementUtil.writeExternal((Element)container2, (ArrangementSettings)myArrangementSettings, (Language)provider2.getLanguage());
            if (!container2.getChildren().isEmpty()) {
                element3.addContent(container2);
            }
        }
    }

    public CommonCodeStyleSettings clone(@NotNull CodeStyleSettings rootSettings) {
        ArrangementSettings arrangementSettings;
        if (rootSettings == null) {
            KotlinCommonCodeStyleSettings.$$$reportNull$$$0(5);
        }
        KotlinCommonCodeStyleSettings commonSettings = new KotlinCommonCodeStyleSettings();
        KotlinCommonCodeStyleSettings.copyPublicFields((Object)((Object)this), (Object)((Object)commonSettings));
        try {
            Method setRootSettingsMethod = CommonCodeStyleSettings.class.getDeclaredMethod("setRootSettings", CodeStyleSettings.class);
            setRootSettingsMethod.setAccessible(true);
            setRootSettingsMethod.invoke((Object)commonSettings, rootSettings);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        commonSettings.setForceArrangeMenuAvailable(this.isForceArrangeMenuAvailable());
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions();
        if (indentOptions != null) {
            CommonCodeStyleSettings.IndentOptions targetIndentOptions = commonSettings.initIndentOptions();
            targetIndentOptions.copyFrom(indentOptions);
        }
        if ((arrangementSettings = this.getArrangementSettings()) != null) {
            commonSettings.setArrangementSettings(arrangementSettings.clone());
        }
        try {
            Method setRootSettingsMethod = (Method)ArraysKt.singleOrNull((Object[])CommonCodeStyleSettings.class.getDeclaredMethods(), method -> "setSoftMargins".equals(method.getName()));
            if (setRootSettingsMethod != null) {
                setRootSettingsMethod.setAccessible(true);
                setRootSettingsMethod.invoke((Object)commonSettings, this.getSoftMargins());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return commonSettings;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KotlinCommonCodeStyleSettings)) {
            return false;
        }
        if (!ReflectionUtil.comparePublicNonFinalFieldsWithSkip((Object)this, obj)) {
            return false;
        }
        CommonCodeStyleSettings other2 = (CommonCodeStyleSettings)obj;
        if (!this.getSoftMargins().equals(other2.getSoftMargins())) {
            return false;
        }
        CommonCodeStyleSettings.IndentOptions options2 = this.getIndentOptions();
        if (options2 == null && other2.getIndentOptions() != null || options2 != null && !options2.equals((Object)other2.getIndentOptions())) {
            return false;
        }
        return this.arrangementSettingsEqual(other2);
    }

    private void serializeInto(@NotNull List<Integer> softMargins, @NotNull Element element3) {
        if (softMargins == null) {
            KotlinCommonCodeStyleSettings.$$$reportNull$$$0(6);
        }
        if (element3 == null) {
            KotlinCommonCodeStyleSettings.$$$reportNull$$$0(7);
        }
        if (softMargins.size() > 0) {
            XmlSerializer.serializeInto((Object)((Object)this), (Element)element3);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "softMargins";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/formatter/KotlinCommonCodeStyleSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternalBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "clone";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "serializeInto";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

