/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinPropertySetterParametersFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "leftParenthesis", "Lcom/intellij/lang/ASTNode;", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getLeftParenthesis", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;)Lcom/intellij/lang/ASTNode;", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
public final class KotlinPropertySetterParametersFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor2, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement psiElement2) {
        KtParameter parameter2;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        if (!(psiElement2 instanceof KtPropertyAccessor)) {
            return;
        }
        if (!((KtPropertyAccessor)psiElement2).isSetter()) {
            return;
        }
        KtParameter ktParameter = parameter2 = ((KtPropertyAccessor)psiElement2).getParameter();
        CharSequence charSequence2 = ktParameter != null ? ktParameter.getText() : null;
        if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) && ((KtPropertyAccessor)psiElement2).getRightParenthesis() != null) {
            return;
        }
        PsiElement psiElement3 = ((KtPropertyAccessor)psiElement2).getNamePlaceholder();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"psiElement.namePlaceholder");
        if (PsiUtilsKt.getEndOffset((PsiElement)psiElement3) == PsiUtilsKt.getEndOffset((PsiElement)psiElement2)) {
            return;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document doc = document;
        PsiElement psiElement4 = ((KtPropertyAccessor)psiElement2).getLeftParenthesis();
        if (psiElement4 == null || (psiElement4 = psiElement4.getNode()) == null) {
            return;
        }
        int parameterOffset = psiElement4.getStartOffset() + 1;
        KtParameter ktParameter2 = parameter2;
        CharSequence charSequence3 = ktParameter2 != null ? ktParameter2.getText() : null;
        if (charSequence3 == null || StringsKt.isBlank((CharSequence)charSequence3)) {
            if (((KtPropertyAccessor)psiElement2).getRightParenthesis() == null) {
                doc.insertString(parameterOffset, (CharSequence)"value)");
            } else {
                doc.insertString(parameterOffset, (CharSequence)"value");
            }
        } else if (((KtPropertyAccessor)psiElement2).getRightParenthesis() == null) {
            KtParameter ktParameter3 = parameter2;
            Intrinsics.checkNotNull((Object)ktParameter3);
            doc.insertString(parameterOffset + ktParameter3.getText().length(), (CharSequence)")");
        }
    }

    private final ASTNode getLeftParenthesis(KtPropertyAccessor $this$leftParenthesis) {
        return $this$leftParenthesis.getNode().findChildByType((IElementType)KtTokens.LPAR);
    }
}

