/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.actions.AsyncStacksToggleAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.Location;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutinePreflightFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.SkipCoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor;", "Lorg/jetbrains/kotlin/idea/debugger/core/StackFrameInterceptor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "showCoroutinePanel", "", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineStackFrameInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineStackFrameInterceptor.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,51:1\n76#2:52\n110#3:53\n*S KotlinDebug\n*F\n+ 1 CoroutineStackFrameInterceptor.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor\n*L\n27#1:52\n44#1:53\n*E\n"})
public final class CoroutineStackFrameInterceptor
implements StackFrameInterceptor {
    @NotNull
    private final Project project;

    public CoroutineStackFrameInterceptor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        JavaDebugProcess javaDebugProcess = debugProcess.getXdebugProcess();
        if ((javaDebugProcess != null ? javaDebugProcess.getSession() : null) instanceof XDebugSessionImpl && !(frame instanceof SkipCoroutineStackFrameProxyImpl)) {
            JavaDebugProcess javaDebugProcess2 = debugProcess.getXdebugProcess();
            Object object = javaDebugProcess2 != null ? javaDebugProcess2.getSession() : null;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
            if (AsyncStacksToggleAction.Companion.isAsyncStacksEnabled((XDebugSessionImpl)object)) {
                CoroutinePreflightFrame stackFrame;
                SuspendContextImpl suspendContextImpl;
                boolean $i$f$isUnitTestMode = false;
                SuspendContextImpl suspendContextImpl2 = suspendContextImpl = ApplicationManager.getApplication().isUnitTestMode() ? debugProcess.getSuspendManager().getPausedContext() : debugProcess.getDebuggerContext().getSuspendContext();
                if (suspendContextImpl2 != null) {
                    SuspendContextImpl it = suspendContextImpl2;
                    boolean bl = false;
                    v4 = CoroutineFrameBuilder.Companion.coroutineExitFrame(frame, it);
                } else {
                    v4 = stackFrame = null;
                }
                if (stackFrame != null) {
                    this.showCoroutinePanel(debugProcess);
                }
                return (XStackFrame)stackFrame;
            }
        }
        return null;
    }

    private final void showCoroutinePanel(DebugProcessImpl debugProcess) {
        XDebugSession xDebugSession = debugProcess.getSession().getXDebugSession();
        RunnerLayoutUi $this$safeAs$iv = xDebugSession != null ? xDebugSession.getUI() : null;
        boolean $i$f$safeAs = false;
        RunnerLayoutUi runnerLayoutUi = $this$safeAs$iv;
        if (!(runnerLayoutUi instanceof RunnerLayoutUiImpl)) {
            runnerLayoutUi = null;
        }
        RunnerLayoutUiImpl runnerLayoutUiImpl = (RunnerLayoutUiImpl)runnerLayoutUi;
        if (runnerLayoutUiImpl == null) {
            return;
        }
        RunnerLayoutUiImpl ui = runnerLayoutUiImpl;
        RunnerContentUi runnerContentUi = (RunnerContentUi)RunnerContentUi.KEY.getData((DataProvider)ui);
        if (runnerContentUi == null) {
            return;
        }
        RunnerContentUi runnerContentUi2 = runnerContentUi;
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(runnerContentUi2){
            final /* synthetic */ RunnerContentUi $runnerContentUi;
            {
                this.$runnerContentUi = $runnerContentUi;
                super(0);
            }

            public final void invoke() {
                this.$runnerContentUi.findOrRestoreContentIfNeeded("XCoroutineThreadsContent");
            }
        }), (int)1, null);
    }
}

