/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DescriptorWithParentObject;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiExpression;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\f\u0010\u001f\u001a\u00020\r*\u00020\rH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/GetterDescriptor;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "Lcom/intellij/debugger/ui/tree/DescriptorWithParentObject;", "parentObject", "Lcom/sun/jdi/ObjectReference;", "getter", "Lcom/sun/jdi/Method;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/sun/jdi/ObjectReference;Lcom/sun/jdi/Method;Lcom/intellij/openapi/project/Project;)V", "getGetter", "()Lcom/sun/jdi/Method;", "name", "", "calcValue", "Lcom/sun/jdi/Value;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "getDescriptorEvaluation", "Lcom/intellij/psi/PsiExpression;", "context", "Lcom/intellij/debugger/DebuggerContext;", "getName", "getObject", "getRenderer", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/debugger/ui/tree/render/NodeRenderer;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getType", "Lcom/sun/jdi/Type;", "removeGetterPrefix", "Companion", "kotlin.jvm-debugger.core"})
public final class GetterDescriptor
extends ValueDescriptorImpl
implements DescriptorWithParentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectReference parentObject;
    @NotNull
    private final Method getter;
    @NotNull
    private final String name;
    @NotNull
    private static final String[] GETTER_PREFIXES;

    public GetterDescriptor(@NotNull ObjectReference parentObject, @NotNull Method getter2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)parentObject, (String)"parentObject");
        Intrinsics.checkNotNullParameter((Object)getter2, (String)"getter");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        this.parentObject = parentObject;
        this.getter = getter2;
        String string2 = this.getter.name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getter.name()");
        this.name = StringsKt.decapitalize((String)this.removeGetterPrefix(string2));
        OnDemandRenderer.ON_DEMAND_CALCULATED.set((UserDataHolder)this, (Object)false);
        Type type2 = this.getType();
        String returnTypeName = type2 != null ? type2.name() : null;
        this.setOnDemandPresentationProvider(arg_0 -> GetterDescriptor._init_$lambda$0(returnTypeName, arg_0));
    }

    @NotNull
    public final Method getGetter() {
        return this.getter;
    }

    private final String removeGetterPrefix(String $this$removeGetterPrefix) {
        if (StringsKt.startsWith$default((String)$this$removeGetterPrefix, (String)"get", (boolean)false, (int)2, null)) {
            return StringsKt.drop((String)$this$removeGetterPrefix, (int)3);
        }
        return $this$removeGetterPrefix;
    }

    @NotNull
    public ObjectReference getObject() {
        return this.parentObject;
    }

    @NotNull
    public PsiExpression getDescriptorEvaluation(@NotNull DebuggerContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        throw new EvaluateException("Getter evaluation is not supported");
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Type getType() {
        return SafeUtilKt.safeReturnType(this.getter);
    }

    @NotNull
    public CompletableFuture<NodeRenderer> getRenderer(@Nullable DebugProcessImpl debugProcess) {
        CompletableFuture completableFuture = this.getRenderer(this.getType(), debugProcess);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"getRenderer(type, debugProcess)");
        return completableFuture;
    }

    @Nullable
    public Value calcValue(@Nullable EvaluationContextImpl evaluationContext) {
        EvaluationContextImpl evaluationContextImpl = evaluationContext;
        return evaluationContextImpl != null && (evaluationContextImpl = evaluationContextImpl.getDebugProcess()) != null ? evaluationContextImpl.invokeMethod((EvaluationContext)evaluationContext, this.parentObject, this.getter, CollectionsKt.emptyList()) : null;
    }

    private static final void _init_$lambda$0(String $returnTypeName, XValueNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.setFullValueEvaluator(OnDemandRenderer.createFullValueEvaluator((String)KotlinDebuggerCoreBundle.message("message.variables.property.get", new Object[0])));
        node2.setPresentation(IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Property), (XValuePresentation)new XRegularValuePresentation("", $returnTypeName, " "), false);
    }

    static {
        String[] stringArray = new String[]{"get", "is"};
        GETTER_PREFIXES = stringArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/GetterDescriptor$Companion;", "", "()V", "GETTER_PREFIXES", "", "", "getGETTER_PREFIXES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "kotlin.jvm-debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getGETTER_PREFIXES() {
            return GETTER_PREFIXES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

