/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpointType;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinBreakpointFiltersPanel;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFieldBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFieldBreakpointPropertiesPanel;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinPropertyBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.dialog.AddFieldBreakpointDialog;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016J0\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u001c2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u001c2\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0002H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u0004\u0018\u00010\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J \u0010&\u001a\u0004\u0018\u00010'2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010(\u001a\u00020$H\u0016J\b\u0010)\u001a\u00020$H\u0016J\b\u0010*\u001a\u00020$H\u0016J\b\u0010+\u001a\u00020\u0012H\u0016J\u0016\u0010,\u001a\u00020\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\b\u0010-\u001a\u00020\rH\u0016J\b\u0010.\u001a\u00020\rH\u0016J\u001a\u0010/\u001a\u0002002\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u00101\u001a\u00020\u0018H\u0002\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinPropertyBreakpointProperties;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointType;", "()V", "addBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljavax/swing/JComponent;", "canBeHitInOtherPlaces", "", "canPutAt", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "createBreakpointIfPropertyExists", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "Lorg/jetbrains/kotlin/psi/KtFile;", "className", "", "fieldName", "createBreakpointProperties", "createCustomPropertiesPanel", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointCustomPropertiesPanel;", "createCustomRightPropertiesPanel", "createJavaBreakpoint", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "createProperties", "getDisabledIcon", "Ljavax/swing/Icon;", "getDisplayText", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "getEnabledIcon", "getMutedDisabledIcon", "getMutedEnabledIcon", "getPriority", "getShortText", "isAddBreakpointButtonVisible", "isSuspendThreadSupported", "reportError", "", "message", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinFieldBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFieldBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpointType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n288#2,2:186\n*S KotlinDebug\n*F\n+ 1 KotlinFieldBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpointType\n*L\n126#1:186,2\n*E\n"})
public final class KotlinFieldBreakpointType
extends XLineBreakpointType<KotlinPropertyBreakpointProperties>
implements JavaBreakpointType<KotlinPropertyBreakpointProperties>,
KotlinBreakpointType {
    public KotlinFieldBreakpointType() {
        super("kotlin-field", KotlinDebuggerCoreBundle.message("property.watchpoint.tab.title", new Object[0]));
    }

    @NotNull
    public Breakpoint<KotlinPropertyBreakpointProperties> createJavaBreakpoint(@NotNull Project project2, @NotNull XBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return (Breakpoint)new KotlinFieldBreakpoint(project2, breakpoint2);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file2, line, project2, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)canPutAt.1.INSTANCE));
    }

    public int getPriority() {
        return 120;
    }

    @NotNull
    public KotlinPropertyBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new KotlinPropertyBreakpointProperties(null, null, 3, null);
    }

    @Nullable
    public XLineBreakpoint<KotlinPropertyBreakpointProperties> addBreakpoint(@NotNull Project project2, @Nullable JComponent parentComponent) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        AddFieldBreakpointDialog dialog2 = new AddFieldBreakpointDialog(project2, this, (Ref.ObjectRef<XLineBreakpoint<KotlinPropertyBreakpointProperties>>)result2){
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinFieldBreakpointType this$0;
            final /* synthetic */ Ref.ObjectRef<XLineBreakpoint<KotlinPropertyBreakpointProperties>> $result;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$result = $result;
                super($project);
            }

            protected boolean validateData() {
                String className = this.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"className");
                if (((CharSequence)className).length() == 0) {
                    String string2 = JavaDebuggerBundle.message((String)"error.field.breakpoint.class.name.not.specified", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"error.field.bre\u2026lass.name.not.specified\")");
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string2);
                    return false;
                }
                PsiClass psiClass2 = JavaPsiFacade.getInstance((Project)this.$project).findClass(className, GlobalSearchScope.allScope((Project)this.$project));
                if (!(psiClass2 instanceof KtLightClass)) {
                    Object[] objectArray = new Object[]{className};
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, KotlinDebuggerCoreBundle.message("property.watchpoint.error.couldnt.find.0.class", objectArray));
                    return false;
                }
                String fieldName = this.getFieldName();
                Intrinsics.checkNotNullExpressionValue((Object)fieldName, (String)"fieldName");
                if (((CharSequence)fieldName).length() == 0) {
                    String string3 = JavaDebuggerBundle.message((String)"error.field.breakpoint.field.name.not.specified", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"error.field.bre\u2026ield.name.not.specified\")");
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string3);
                    return false;
                }
                KtLightClass ktLightClass = (KtLightClass)psiClass2;
                if (ktLightClass instanceof KtLightClassForFacade) {
                    v2 = (XLineBreakpoint)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((KtLightClassForFacade)psiClass2).getFiles()), (Function1)((Function1)new Function1<KtFile, XLineBreakpoint<KotlinPropertyBreakpointProperties>>(this.this$0, className, fieldName){
                        final /* synthetic */ KotlinFieldBreakpointType this$0;
                        final /* synthetic */ String $className;
                        final /* synthetic */ String $fieldName;
                        {
                            this.this$0 = $receiver;
                            this.$className = $className;
                            this.$fieldName = $fieldName;
                            super(1);
                        }

                        @Nullable
                        public final XLineBreakpoint<KotlinPropertyBreakpointProperties> invoke(@NotNull KtFile it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            KtDeclarationContainer ktDeclarationContainer = (KtDeclarationContainer)it;
                            String string2 = this.$className;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className");
                            String string3 = this.$fieldName;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fieldName");
                            return KotlinFieldBreakpointType.access$createBreakpointIfPropertyExists(this.this$0, ktDeclarationContainer, it, string2, string3);
                        }
                    })));
                } else if (ktLightClass instanceof KtLightClassForSourceDeclaration) {
                    KtClassOrObject ktClassOrObject = ((KtLightClassForSourceDeclaration)psiClass2).getKotlinOrigin();
                    KtDeclarationContainer ktDeclarationContainer = (KtDeclarationContainer)ktClassOrObject;
                    KtFile ktFile = ktClassOrObject.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"ktClassOrObject.containingKtFile");
                    v2 = KotlinFieldBreakpointType.access$createBreakpointIfPropertyExists(this.this$0, ktDeclarationContainer, ktFile, className, fieldName);
                } else {
                    v2 = this.$result.element = null;
                }
                if (this.$result.element == null) {
                    Object[] objectArray = new Object[]{className, fieldName, fieldName};
                    String string4 = JavaDebuggerBundle.message((String)"error.field.breakpoint.field.not.found", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"error.field.bre\u2026me, fieldName, fieldName)");
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string4);
                }
                return this.$result.element != null;
            }
        };
        dialog2.show();
        return (XLineBreakpoint)result2.element;
    }

    private final XLineBreakpoint<KotlinPropertyBreakpointProperties> createBreakpointIfPropertyExists(KtDeclarationContainer declaration2, KtFile file2, String className, String fieldName) {
        Object v2;
        Project project2;
        block3: {
            Project project3 = file2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"file.project");
            project2 = project3;
            List list2 = declaration2.getDeclarations();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"declaration.declarations");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)it).getName(), (Object)fieldName))) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        KtDeclaration ktDeclaration = v2;
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration property2 = ktDeclaration;
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        int line = document2.getLineNumber(property2.getTextOffset());
        return (XLineBreakpoint)ActionsKt.runWriteAction((Function0)((Function0)new Function0<XLineBreakpoint<KotlinPropertyBreakpointProperties>>(project2, this, file2, line, fieldName, className){
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinFieldBreakpointType this$0;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ int $line;
            final /* synthetic */ String $fieldName;
            final /* synthetic */ String $className;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$file = $file;
                this.$line = $line;
                this.$fieldName = $fieldName;
                this.$className = $className;
                super(0);
            }

            @NotNull
            public final XLineBreakpoint<KotlinPropertyBreakpointProperties> invoke() {
                return XDebuggerManager.getInstance((Project)this.$project).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)this.this$0, this.$file.getVirtualFile().getUrl(), this.$line, (XBreakpointProperties)new KotlinPropertyBreakpointProperties(this.$fieldName, this.$className));
            }
        }));
    }

    private final void reportError(Project project2, @NlsContexts.DialogMessage String message2) {
        Messages.showMessageDialog((Project)project2, (String)message2, (String)JavaDebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Db_muted_field_breakpoint");
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Db_disabled_field_breakpoint");
        return icon;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Db_field_breakpoint");
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Db_muted_disabled_field_breakpoint");
        return icon;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    @NotNull
    public String getShortText(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        KotlinPropertyBreakpointProperties properties2 = (KotlinPropertyBreakpointProperties)breakpoint2.getProperties();
        String className = properties2.getMyClassName();
        return ((CharSequence)className).length() > 0 ? className + "." + properties2.getMyFieldName() : properties2.getMyFieldName();
    }

    @NotNull
    public KotlinPropertyBreakpointProperties createProperties() {
        return new KotlinPropertyBreakpointProperties(null, null, 3, null);
    }

    @NotNull
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<KotlinPropertyBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new KotlinFieldBreakpointPropertiesPanel();
    }

    @Nullable
    public String getDisplayText(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        Breakpoint breakpoint3 = BreakpointManager.getJavaBreakpoint((XBreakpoint)((XBreakpoint)breakpoint2));
        BreakpointWithHighlighter kotlinBreakpoint = breakpoint3 instanceof BreakpointWithHighlighter ? (BreakpointWithHighlighter)breakpoint3 : null;
        Object object = kotlinBreakpoint;
        if (object == null || (object = object.getDescription()) == null) {
            object = super.getDisplayText(breakpoint2);
        }
        return object;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return null;
    }

    @NotNull
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<KotlinPropertyBreakpointProperties>> createCustomRightPropertiesPanel(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new KotlinBreakpointFiltersPanel(project2);
    }

    public boolean isSuspendThreadSupported() {
        return true;
    }

    public static final /* synthetic */ void access$reportError(KotlinFieldBreakpointType $this, Project project2, String message2) {
        $this.reportError(project2, message2);
    }

    public static final /* synthetic */ XLineBreakpoint access$createBreakpointIfPropertyExists(KotlinFieldBreakpointType $this, KtDeclarationContainer declaration2, KtFile file2, String className, String fieldName) {
        return $this.createBreakpointIfPropertyExists(declaration2, file2, className, fieldName);
    }
}

