/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.PositionManagerWithMultipleStackFrames;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.types.KtFunctionalType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.base.analysis.InlineUtilsKt;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposableUtils;
import org.jetbrains.kotlin.idea.debugger.IrLambdaDescriptor;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.KotlinReentrantSourcePosition;
import org.jetbrains.kotlin.idea.debugger.KotlinSourcePositionWithEntireLineHighlighted;
import org.jetbrains.kotlin.idea.debugger.base.util.DexDebugFacility;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmDebuggerBasePsiUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinAllFilesScopeProvider;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.CodeFragmentContextUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.ComposeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.LineBreakpointExpressionVisitor;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.SourcePositionRefiner;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackTraceCalculator;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrame;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.idea.util.FindElementUtils;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0017J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020!H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00072\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u001bH\u0002J\"\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u001bH\u0002J\"\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u0018\u001a\u00020/2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u001bH\u0002J\"\u0010:\u001a\u0004\u0018\u0001082\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u001bH\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010/2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020-0\u00072\u0006\u0010\u0013\u001a\u00020\u0010H\u0003J\u0014\u0010=\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u0002082\u0006\u00102\u001a\u00020\u001bH\u0002J\u0010\u0010A\u001a\u00020?2\u0006\u0010B\u001a\u00020!H\u0002J\u001e\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010D\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020!0\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010F\u001a\u00020?*\u0002062\u0006\u0010G\u001a\u00020!2\u0006\u0010H\u001a\u00020?H\u0002J0\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007*\u00020\u00172\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020!H\u0002J\u001c\u0010N\u001a\u0004\u0018\u000108*\b\u0012\u0004\u0012\u0002080\u00072\u0006\u0010G\u001a\u00020!H\u0002J$\u0010O\u001a\u0004\u0018\u000108*\b\u0012\u0004\u0012\u0002080\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u001bH\u0002J \u0010P\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170Q0\u0007*\u00020L2\u0006\u0010M\u001a\u00020!H\u0002J(\u0010R\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010Q*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170Q0\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010S\u001a\u0004\u0018\u000108*\b\u0012\u0004\u0012\u0002080\u00072\u0006\u0010T\u001a\u00020\u001bH\u0002J\u0014\u0010U\u001a\u00020?*\u0002082\u0006\u00102\u001a\u00020\u001bH\u0002J\u0014\u0010V\u001a\u00020?*\u00020\u00172\u0006\u0010W\u001a\u00020/H\u0002J\u000e\u0010X\u001a\u0004\u0018\u000104*\u000208H\u0002J\u001c\u0010Y\u001a\u00020?*\u00020\u00172\u0006\u0010W\u001a\u00020/2\u0006\u0010M\u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager;", "Lcom/intellij/debugger/MultiRequestPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerWithMultipleStackFrames;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "sourceSearchScopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "stackFrameInterceptor", "Lorg/jetbrains/kotlin/idea/debugger/core/StackFrameInterceptor;", "createKotlinClassPrepareRequests", "Lcom/sun/jdi/request/ClassPrepareRequest;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "position", "Lcom/intellij/debugger/SourcePosition;", "createPrepareRequest", "classPrepareRequestor", "sourcePosition", "createPrepareRequests", "createSourcePosition", "location", "Lcom/sun/jdi/Location;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "sourceLineNumber", "", "createStackFrames", "Lcom/intellij/xdebugger/frame/XStackFrame;", "descriptor", "Lcom/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl;", "defaultInternalName", "", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "expression", "getAcceptedFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "getAllClasses", "Lcom/sun/jdi/ReferenceType;", "getAlternativeSource", "Lcom/intellij/psi/PsiFile;", "getCallableReferenceIfInside", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "lineNumber", "getElementForDeclarationLine", "Lorg/jetbrains/kotlin/psi/KtElement;", "getFirstElementInsideLambdaOnLine", "Lcom/intellij/psi/PsiElement;", "lambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "line", "getLambdaOrFunOnLineIfInside", "getPsiFileByLocation", "getReferenceTypesForPositionInKotlinFile", "getSourcePosition", "hasImplicitReturnOnLine", "", "function", "isNestedClassName", "name", "locationsOfLine", "type", "originalClassNamesForPosition", "calculatedClassNameMatches", "currentLocationClassName", "isLambda", "findLocationsInSameInlinedFunction", "locations", "method", "Lcom/sun/jdi/Method;", "sourceFileName", "getAppropriateLiteralBasedOnDeclaringClassName", "getAppropriateLiteralBasedOnLambdaName", "getInlineFunctionBorders", "Lkotlin/ranges/ClosedRange;", "getLeastEnclosingBorders", "getSamLambdaWithIndex", "index", "hasExecutableCodeInsideOnLine", "hasFinallyBlockInParent", "psiFile", "lastStatementSkippingComments", "shouldBeTreatedAsReentrantSourcePosition", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinPositionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 JvmDebuggerBasePsiUtils.kt\norg/jetbrains/kotlin/idea/debugger/base/util/JvmDebuggerBasePsiUtils\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 8 breakpointTypeUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointTypeUtilsKt\n+ 9 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 10 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 11 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,742:1\n40#2:743\n110#3:744\n110#3:853\n32#4:745\n288#5,2:746\n766#5:749\n857#5,2:750\n766#5:754\n857#5,2:755\n800#5,11:768\n288#5,2:779\n2624#5,3:781\n288#5,2:803\n766#5:805\n857#5,2:806\n1747#5,3:808\n766#5:811\n857#5,2:812\n1045#5:814\n766#5:815\n857#5,2:816\n1360#5:838\n1446#5,5:839\n1360#5:844\n1446#5,5:845\n766#5:850\n857#5,2:851\n1360#5:855\n1446#5,5:856\n1#6:748\n57#7,2:752\n412#7:837\n129#8,11:757\n32#9,7:784\n32#9,7:818\n55#10:791\n54#10,3:792\n75#10,8:795\n55#10:825\n54#10,3:826\n75#10,8:829\n10#11:854\n*S KotlinDebug\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManager\n*L\n72#1:743\n185#1:744\n584#1:853\n222#1:745\n225#1:746,2\n234#1:749\n234#1:750,2\n259#1:754\n259#1:755,2\n308#1:768,11\n310#1:779,2\n325#1:781,3\n348#1:803,2\n359#1:805\n359#1:806,2\n360#1:808,3\n372#1:811\n372#1:812,2\n378#1:814\n382#1:815\n382#1:816,2\n505#1:838\n505#1:839,5\n508#1:844\n508#1:845,5\n549#1:850\n549#1:851,2\n605#1:855\n605#1:856,5\n251#1:752,2\n427#1:837\n308#1:757,11\n328#1:784,7\n414#1:818,7\n328#1:791\n328#1:792,3\n328#1:795,8\n414#1:825\n414#1:826,3\n414#1:829,8\n585#1:854\n*E\n"})
public final class KotlinPositionManager
implements MultiRequestPositionManager,
PositionManagerWithMultipleStackFrames {
    @NotNull
    private final DebugProcess debugProcess;
    @Nullable
    private final StackFrameInterceptor stackFrameInterceptor;
    @NotNull
    private final List<GlobalSearchScope> sourceSearchScopes;

    public KotlinPositionManager(@NotNull DebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        Project project2 = this.debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"debugProcess.project");
        ComponentManager $this$serviceOrNull$iv = (ComponentManager)project2;
        boolean $i$f$serviceOrNull = false;
        this.stackFrameInterceptor = (StackFrameInterceptor)$this$serviceOrNull$iv.getService(StackFrameInterceptor.class);
        Object[] objectArray = new GlobalSearchScope[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.debugProcess.getSearchScope(), (String)"debugProcess.searchScope");
        Project project3 = this.debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"debugProcess.project");
        objectArray[1] = KotlinAllFilesScopeProvider.Companion.getInstance(project3).getAllKotlinFilesScope();
        this.sourceSearchScopes = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Set<FileType> getAcceptedFileTypes() {
        return ProjectStructureUtils.getKOTLIN_FILE_TYPES();
    }

    @NotNull
    public ThreeState evaluateCondition(@NotNull EvaluationContext context2, @NotNull StackFrameProxyImpl frame, @NotNull Location location2, @NotNull String expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return ThreeState.UNSURE;
    }

    @NotNull
    public List<XStackFrame> createStackFrames(@NotNull StackFrameDescriptorImpl descriptor2) {
        List<XStackFrame> inlineStackTrace;
        XStackFrame coroutineFrame;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Location location2 = descriptor2.getLocation();
        if (location2 == null || !DebuggerUtil.isInKotlinSources(location2)) {
            return CollectionsKt.emptyList();
        }
        StackFrameProxyImpl stackFrameProxyImpl = descriptor2.getFrameProxy();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"descriptor.frameProxy");
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        StackFrameInterceptor stackFrameInterceptor = this.stackFrameInterceptor;
        if (stackFrameInterceptor != null) {
            DebugProcess debugProcess = descriptor2.getDebugProcess();
            Intrinsics.checkNotNull((Object)debugProcess, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
            v3 = stackFrameInterceptor.createStackFrame(frameProxy, (DebugProcessImpl)debugProcess, location2);
        } else {
            v3 = coroutineFrame = null;
        }
        if (coroutineFrame != null) {
            return CollectionsKt.listOf(coroutineFrame);
        }
        if (Registry.get((String)"debugger.kotlin.inline.stack.trace.enabled").asBoolean() && !((Collection)(inlineStackTrace = InlineStackTraceCalculator.INSTANCE.calculateInlineStackTrace(descriptor2))).isEmpty()) {
            return inlineStackTrace;
        }
        List<LocalVariableProxyImpl> visibleVariables = InlineStackTraceCalculator.INSTANCE.calculateVisibleVariables(frameProxy);
        return CollectionsKt.listOf((Object)((Object)new KotlinStackFrame(descriptor2, visibleVariables)));
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location2) {
        KtFunctionLiteral ktFunctionLiteral;
        SourcePosition sourcePosition2;
        PsiFile psiFile2;
        if (location2 == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        String string2 = SafeUtilKt.safeSourceName(location2);
        if (string2 == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        String fileName = string2;
        int lineNumber = SafeUtilKt.safeLineNumber(location2);
        if (lineNumber < 0) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(fileName)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        PsiFile psiFile3 = this.getAlternativeSource(location2);
        if (psiFile3 == null) {
            psiFile3 = this.getPsiFileByLocation(location2);
        }
        if ((psiFile2 = psiFile3) == null) {
            ReferenceType referenceType = location2.declaringType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"location.declaringType()");
            boolean isKotlinStrataAvailable = DebuggerUtil.containsKotlinStrata(referenceType);
            if (isKotlinStrataAvailable) {
                try {
                    String javaSourceFileName = location2.sourceName("Java");
                    JvmClassName jvmClassName = JvmClassName.byInternalName((String)this.defaultInternalName(location2));
                    Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(defaultInternalName(location))");
                    JvmClassName javaClassName = jvmClassName;
                    Project project2 = this.debugProcess.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                    Intrinsics.checkNotNullExpressionValue((Object)javaSourceFileName, (String)"javaSourceFileName");
                    KtFile defaultPsiFile = DebuggerUtils.INSTANCE.findSourceFileForClass(project2, this.sourceSearchScopes, javaClassName, javaSourceFileName, location2);
                    if (defaultPsiFile != null) {
                        return SourcePosition.createFromLine((PsiFile)((PsiFile)defaultPsiFile), (int)0);
                    }
                }
                catch (AbsentInformationException javaSourceFileName) {
                    // empty catch block
                }
            }
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        if (!(psiFile2 instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        int sourceLineNumber = SafeUtilKt.safeLineNumber(location2) - 1;
        if (sourceLineNumber < 0) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        SourcePosition javaSourceFileName = PositionManagerImpl.adjustPositionForConditionalReturn((DebugProcess)this.debugProcess, (Location)location2, (PsiFile)psiFile2, (int)sourceLineNumber);
        if (javaSourceFileName != null) {
            SourcePosition it = javaSourceFileName;
            boolean bl = false;
            return it;
        }
        SourcePosition sourcePosition3 = this.createSourcePosition(location2, (KtFile)psiFile2, sourceLineNumber);
        if (sourcePosition3 == null) {
            sourcePosition3 = SourcePosition.createFromLine((PsiFile)psiFile2, (int)sourceLineNumber);
        }
        if (!((sourcePosition2 = sourcePosition3) instanceof KotlinReentrantSourcePosition) && this.shouldBeTreatedAsReentrantSourcePosition(location2, psiFile2, fileName)) {
            Intrinsics.checkNotNullExpressionValue((Object)sourcePosition2, (String)"sourcePosition");
            return new KotlinReentrantSourcePosition(sourcePosition2);
        }
        PsiElement psiElement2 = sourcePosition2.getElementAt();
        PsiElement $this$safeAs$iv = psiElement2 != null ? psiElement2.getParent() : null;
        boolean $i$f$safeAs = false;
        PsiElement psiElement3 = $this$safeAs$iv;
        if (!(psiElement3 instanceof KtFunctionLiteral)) {
            psiElement3 = null;
        }
        if ((ktFunctionLiteral = (KtFunctionLiteral)psiElement3) == null || (ktFunctionLiteral = KotlinSteppingCommandProviderKt.getLineRange((PsiElement)ktFunctionLiteral)) == null) {
            return sourcePosition2;
        }
        KtFunctionLiteral lines = ktFunctionLiteral;
        if (!KotlinPositionManagerKt.access$hasVisibleInlineLambdasOnLines(location2, (IntRange)lines)) {
            Intrinsics.checkNotNullExpressionValue((Object)sourcePosition2, (String)"sourcePosition");
            return new KotlinSourcePositionWithEntireLineHighlighted(sourcePosition2);
        }
        return sourcePosition2;
    }

    private final SourcePosition createSourcePosition(Location location2, KtFile file2, int sourceLineNumber) {
        SourcePosition sourcePosition2;
        KtFunction lambdaOrFunIfInside = this.getLambdaOrFunOnLineIfInside(location2, file2, sourceLineNumber);
        if (lambdaOrFunIfInside != null) {
            PsiElement elementAt = this.getFirstElementInsideLambdaOnLine((PsiFile)file2, lambdaOrFunIfInside, sourceLineNumber);
            if (elementAt != null) {
                return SourcePosition.createFromElement((PsiElement)elementAt);
            }
            return SourcePosition.createFromLine((PsiFile)((PsiFile)file2), (int)sourceLineNumber);
        }
        KtCallableReferenceExpression callableReferenceIfInside = this.getCallableReferenceIfInside(location2, file2, sourceLineNumber);
        if (callableReferenceIfInside != null && (sourcePosition2 = SourcePosition.createFromElement((PsiElement)((PsiElement)callableReferenceIfInside))) != null) {
            return new KotlinReentrantSourcePosition(sourcePosition2);
        }
        KtElement elementInDeclaration = this.getElementForDeclarationLine(location2, file2, sourceLineNumber);
        if (elementInDeclaration != null) {
            return SourcePosition.createFromElement((PsiElement)((PsiElement)elementInDeclaration));
        }
        return null;
    }

    private final PsiElement getFirstElementInsideLambdaOnLine(PsiFile file2, KtFunction lambda2, int line) {
        Object v3;
        List elementsAtLine;
        block3: {
            KtExpression ktExpression = lambda2.getBodyExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            TextRange bodyRange = ktExpression.getTextRange();
            TextRange textRange = JvmDebuggerBasePsiUtils.getRangeOfLine(file2, line);
            Object object = textRange != null ? textRange.intersection(bodyRange) : null;
            if (object == null) {
                return null;
            }
            TextRange searchRange = object;
            PsiFile $this$findElementsOfTypeInRange$iv = file2;
            boolean $i$f$findElementsOfTypeInRange = false;
            Class[] classArray = new Class[]{PsiElement.class};
            elementsAtLine = JvmDebuggerBasePsiUtils.findElementsOfTypeInRange($this$findElementsOfTypeInRange$iv, searchRange, classArray);
            Iterable $this$firstOrNull$iv = elementsAtLine;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!searchRange.contains(it.getTextRange().getStartOffset())) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        PsiElement psiElement2 = v3;
        if (psiElement2 != null) {
            PsiElement it = psiElement2;
            boolean bl = false;
            return it;
        }
        return (PsiElement)CollectionsKt.firstOrNull(elementsAtLine);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldBeTreatedAsReentrantSourcePosition(Location $this$shouldBeTreatedAsReentrantSourcePosition, PsiFile psiFile2, String sourceFileName) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Method method = SafeUtilKt.safeMethod($this$shouldBeTreatedAsReentrantSourcePosition);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        Iterable iterable = SafeUtilKt.safeAllLineLocations(method2);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName(it), (Object)sourceFileName) && it.lineNumber() == $this$shouldBeTreatedAsReentrantSourcePosition.lineNumber();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sameLineLocations = (List)destination$iv$iv;
        if (sameLineLocations.size() < 2 || this.hasFinallyBlockInParent($this$shouldBeTreatedAsReentrantSourcePosition, psiFile2)) {
            return false;
        }
        List<Location> locationsInSameInlinedFunction = this.findLocationsInSameInlinedFunction($this$shouldBeTreatedAsReentrantSourcePosition, sameLineLocations, method2, sourceFileName);
        Collection collection2 = locationsInSameInlinedFunction;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = sameLineLocations;
        } else {
            collection = collection2;
        }
        return ((List)collection).indexOf($this$shouldBeTreatedAsReentrantSourcePosition) > 0;
    }

    private final boolean hasFinallyBlockInParent(Location $this$hasFinallyBlockInParent, PsiFile psiFile2) {
        KtFinallySection ktFinallySection;
        PsiElement elementAt;
        PsiElement psiElement2;
        Integer n = PsiLinesUtilsKt.getLineStartOffset(psiFile2, $this$hasFinallyBlockInParent.lineNumber());
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            psiElement2 = psiFile2.findElementAt(it);
        } else {
            psiElement2 = null;
        }
        PsiElement psiElement3 = elementAt = psiElement2;
        if (psiElement3 != null) {
            PsiElement $this$parentOfType_u24default$iv = psiElement3;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            ktFinallySection = (KtFinallySection)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFinallySection.class, (boolean)true);
        } else {
            ktFinallySection = null;
        }
        return ktFinallySection != null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Location> findLocationsInSameInlinedFunction(Location $this$findLocationsInSameInlinedFunction, List<? extends Location> locations, Method method, String sourceFileName) {
        void $this$filterTo$iv$iv;
        ClosedRange<Location> closedRange = this.getLeastEnclosingBorders(this.getInlineFunctionBorders(method, sourceFileName), $this$findLocationsInSameInlinedFunction);
        if (closedRange == null) {
            return CollectionsKt.emptyList();
        }
        ClosedRange<Location> leastEnclosingBorders = closedRange;
        Iterable $this$filter$iv = locations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            if (!leastEnclosingBorders.contains((Comparable)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ClosedRange<Location> getLeastEnclosingBorders(List<? extends ClosedRange<Location>> $this$getLeastEnclosingBorders, Location location2) {
        ClosedRange<Location> result2 = null;
        for (ClosedRange<Location> closedRange : $this$getLeastEnclosingBorders) {
            if (!closedRange.contains((Comparable)location2) || result2 != null && ((Location)closedRange.getStart()).compareTo(result2.getStart()) <= 0) continue;
            result2 = closedRange;
        }
        return result2;
    }

    private final List<ClosedRange<Location>> getInlineFunctionBorders(Method $this$getInlineFunctionBorders, String sourceFileName) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull(DebuggerUtil.getInlineFunctionOrArgumentVariables($this$getInlineFunctionBorders), (Function1)getInlineFunctionBorders.1.INSTANCE), (Function1)((Function1)new Function1<ClosedRange<Location>, Boolean>(sourceFileName){
            final /* synthetic */ String $sourceFileName;
            {
                this.$sourceFileName = $sourceFileName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ClosedRange<Location> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName((Location)it.getStart()), (Object)this.$sourceFileName);
            }
        })));
    }

    private final PsiFile getAlternativeSource(Location location2) {
        PsiManager psiManager2 = PsiManager.getInstance((Project)this.debugProcess.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(debugProcess.project)");
        PsiManager manager = psiManager2;
        String qName = location2.declaringType().name();
        String string2 = DebuggerUtilsEx.getAlternativeSourceUrl((String)qName, (Project)this.debugProcess.getProject());
        if (string2 == null) {
            return null;
        }
        String alternativeFileUrl = string2;
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(alternativeFileUrl);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile alternativePsiFile = virtualFile2;
        return manager.findFile(alternativePsiFile);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final KtElement getElementForDeclarationLine(Location location, KtFile file, int lineNumber) {
        block8: {
            block7: {
                block6: {
                    v0 = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file, lineNumber);
                    if (v0 == null) {
                        return null;
                    }
                    lineStartOffset = v0;
                    elementAt = file.findElementAt(lineStartOffset);
                    contextElement = CodeFragmentContextUtilsKt.getContextElement(elementAt);
                    if (!(contextElement instanceof KtClass)) {
                        return null;
                    }
                    methodName = location.method().name();
                    Intrinsics.checkNotNullExpressionValue((Object)methodName, (String)"methodName");
                    if (!JvmAbi.isGetterName((String)methodName)) break block7;
                    v1 /* !! */  = ((KtClass)contextElement).getPrimaryConstructor();
                    if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getValueParameters()) == null) {
                        v1 /* !! */  = CollectionsKt.emptyList();
                    }
                    valueParameters /* !! */  = v1 /* !! */ ;
                    var9_9 = (Iterable)valueParameters /* !! */ ;
                    for (T var11_11 : var9_9) {
                        it = (KtParameter)var11_11;
                        $i$a$-find-KotlinPositionManager$getElementForDeclarationLine$1 = false;
                        if (!it.hasValOrVar() || it.getName() == null) ** GOTO lbl-1000
                        v2 = it.getName();
                        Intrinsics.checkNotNull((Object)v2);
                        if (Intrinsics.areEqual((Object)JvmAbi.getterName((String)v2), (Object)methodName)) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        v4 = var11_11;
                        break block6;
                    }
                    v4 = null;
                }
                v5 = v4;
                break block8;
            }
            v5 = Intrinsics.areEqual((Object)methodName, (Object)"<init>") != false ? (KtElement)((KtClass)contextElement).getPrimaryConstructor() : null;
        }
        return v5;
    }

    /*
     * WARNING - void declaration
     */
    private final KtCallableReferenceExpression getCallableReferenceIfInside(Location location2, KtFile file2, int lineNumber) {
        Object v3;
        block6: {
            List list2;
            String string2 = KotlinPositionManagerKt.getClassName(location2);
            if (string2 == null) {
                return null;
            }
            String currentLocationClassName = string2;
            boolean $i$f$getElementsAtLineIfAny = false;
            PsiElement psiElement2 = DebuggerUtil.findElementAtLine(file2, lineNumber);
            KtElement ktElement = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
            if (ktElement == null) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$filterIsInstanceTo$iv$iv$iv;
                KtElement lineElement$iv = ktElement;
                int start$iv = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement$iv));
                int end$iv = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement$iv));
                for (PsiElement nextSibling$iv = lineElement$iv.getNextSibling(); nextSibling$iv != null && lineNumber == PsiLinesUtilsKt.getLineNumber$default(nextSibling$iv, false, 1, null); nextSibling$iv = nextSibling$iv.getNextSibling()) {
                    end$iv = PsiUtilsKt.getEndOffset((PsiElement)nextSibling$iv);
                }
                Class[] classArray = new Class[]{KtCallableReferenceExpression.class};
                Iterable $this$filterIsInstance$iv$iv = FindElementUtils.findElementsOfClassInRange((PsiFile)file2, start$iv, end$iv, classArray);
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof KtCallableReferenceExpression)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                list2 = (List)destination$iv$iv$iv;
            }
            List allReferenceExpressions = list2;
            Iterable $this$firstOrNull$iv = allReferenceExpressions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtCallableReferenceExpression it = (KtCallableReferenceExpression)element$iv;
                boolean bl = false;
                if (!this.calculatedClassNameMatches((PsiElement)it, currentLocationClassName, false)) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final KtFunction getLambdaOrFunOnLineIfInside(Location location2, KtFile file2, int lineNumber) {
        void this_$iv$iv$iv;
        void this_$iv$iv;
        Object element$iv2;
        boolean bl;
        List<KtFunction> literalsOrFunctions;
        String currentLocationClassName;
        block14: {
            String string2 = KotlinPositionManagerKt.getClassName(location2);
            if (string2 == null) {
                return null;
            }
            currentLocationClassName = string2;
            Integer start2 = KotlinPsiUtils.getStartLineOffset((PsiFile)file2, lineNumber);
            Integer end = KotlinPsiUtils.getEndLineOffset((PsiFile)file2, lineNumber);
            if (start2 == null || end == null) {
                return null;
            }
            literalsOrFunctions = BreakpointTypeUtilsKt.getLambdasAtLine(file2, lineNumber);
            Iterable $this$none$iv = literalsOrFunctions;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$none$iv) {
                    KtFunction it = (KtFunction)element$iv2;
                    boolean bl2 = false;
                    if (!BreakpointTypeUtilsKt.isStartingOrEndingOnLine(it, lineNumber)) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        KtElement useSiteKtElement$iv = (KtElement)CollectionsKt.first(literalsOrFunctions);
        Object nonDefaultLifetimeTokenFactory$iv = null;
        boolean $i$f$analyze = false;
        Project project2 = useSiteKtElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        element$iv2 = KtAnalysisSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyse = false;
        KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
        void var14_18 = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession(useSiteKtElement$iv, factory$iv$iv);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtAnalysisSession $this$getLambdaOrFunOnLineIfInside_u24lambda_u2410 = analysisSession$iv$iv$iv;
            boolean bl3 = false;
            List notInlinedLambdas = new ArrayList();
            KtFunction innermostContainingLiteral = null;
            for (KtFunction literal : literalsOrFunctions) {
                if (InlineUtilsKt.isInlinedArgument($this$getLambdaOrFunOnLineIfInside_u24lambda_u2410, literal, true)) {
                    DebugProcess debugProcess = this.debugProcess;
                    Intrinsics.checkNotNull((Object)debugProcess, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                    if (!DebuggerUtil.isInsideInlineArgument(literal, location2, (DebugProcessImpl)debugProcess)) continue;
                    innermostContainingLiteral = literal;
                    continue;
                }
                notInlinedLambdas.add(literal);
            }
            KtFunction ktFunction = innermostContainingLiteral;
            if (ktFunction != null) {
                KtFunction ktFunction2 = ktFunction;
                return ktFunction2;
            }
            KtFunction ktFunction3 = this.getAppropriateLiteralBasedOnDeclaringClassName(notInlinedLambdas, currentLocationClassName);
            if (ktFunction3 == null) {
                ktFunction3 = this.getAppropriateLiteralBasedOnLambdaName(notInlinedLambdas, location2, lineNumber);
            }
            KtFunction ktFunction4 = ktFunction3;
            return ktFunction4;
        }
        finally {
            factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    private final KtFunction getAppropriateLiteralBasedOnDeclaringClassName(List<? extends KtFunction> $this$getAppropriateLiteralBasedOnDeclaringClassName, String currentLocationClassName) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = $this$getAppropriateLiteralBasedOnDeclaringClassName;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtFunction it = (KtFunction)element$iv;
                boolean bl = false;
                PsiElement psiElement2 = it.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it.firstChild");
                if (!this.calculatedClassNameMatches(psiElement2, currentLocationClassName, true)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean calculatedClassNameMatches(PsiElement $this$calculatedClassNameMatches, String currentLocationClassName, boolean isLambda) {
        boolean bl;
        block6: {
            void $this$any$iv;
            List list2;
            Project project2 = this.debugProcess.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"debugProcess.project");
            GlobalSearchScope globalSearchScope = this.debugProcess.getSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"debugProcess.searchScope");
            ClassNameProvider classNameProvider = new ClassNameProvider(project2, globalSearchScope, ClassNameProvider.Configuration.copy$default(ClassNameProvider.Configuration.Companion.getDEFAULT(), false, false, 1, null));
            List $this$calculatedClassNameMatches_u24lambda_u2412 = classNameProvider.getCandidatesForElement($this$calculatedClassNameMatches);
            boolean bl2 = false;
            if (isLambda) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = $this$calculatedClassNameMatches_u24lambda_u2412;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String p0 = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (!this.isNestedClassName(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = $this$calculatedClassNameMatches_u24lambda_u2412;
            }
            Iterable iterable = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)currentLocationClassName)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isNestedClassName(String name2) {
        return StringsKt.contains$default((CharSequence)name2, (CharSequence)"$", (boolean)false, (int)2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final KtFunction getAppropriateLiteralBasedOnLambdaName(List<? extends KtFunction> $this$getAppropriateLiteralBasedOnLambdaName, Location location, int lineNumber) {
        v0 = SafeUtilKt.safeMethod(location);
        if (v0 == null) {
            return null;
        }
        method = v0;
        v1 = method.name();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"method.name()");
        if (!DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(v1) || KotlinPositionManagerKt.isGeneratedErasedLambdaMethod(method)) {
            return null;
        }
        v2 = location.declaringType().methods();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"location.declaringType().methods()");
        var6_5 = v2;
        $i$f$filter = false;
        var8_8 = $this$filter$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Method)element$iv$iv;
            $i$a$-filter-KotlinPositionManager$getAppropriateLiteralBasedOnLambdaName$lambdas$1 = false;
            v3 = it.name();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.name()");
            if (!DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(v3)) ** GOTO lbl-1000
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (KotlinPositionManagerKt.isGeneratedErasedLambdaMethod(it)) ** GOTO lbl-1000
            v4 = DebuggerUtilsEx.locationsOfLine((Method)it, (int)(lineNumber + 1));
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"locationsOfLine(it, lineNumber + 1)");
            if (((Collection)v4).isEmpty() == false) {
                v5 = true;
            } else lbl-1000:
            // 3 sources

            {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv /* !! */ .add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv /* !! */ ;
        $i$f$sortedBy = false;
        lambdas = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Method it = (Method)a;
                boolean bl = false;
                String string2 = it.name();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name()");
                it = (Method)b;
                Comparable comparable = new IrLambdaDescriptor(string2);
                bl = false;
                String string3 = it.name();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name()");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)new IrLambdaDescriptor(string3));
            }
        });
        $this$filter$iv = $this$getAppropriateLiteralBasedOnLambdaName;
        $i$f$filter = false;
        destination$iv$iv /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtFunction)element$iv$iv;
            $i$a$-filter-KotlinPositionManager$getAppropriateLiteralBasedOnLambdaName$suitableFunLiterals$1 = false;
            if (!this.hasExecutableCodeInsideOnLine(it, lineNumber)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        suitableFunLiterals = (List)destination$iv$iv;
        if (lambdas.size() == suitableFunLiterals.size()) {
            return (KtFunction)suitableFunLiterals.get(lambdas.indexOf(method));
        }
        return this.getSamLambdaWithIndex(suitableFunLiterals, lambdas.indexOf(method));
    }

    private final boolean hasExecutableCodeInsideOnLine(KtFunction $this$hasExecutableCodeInsideOnLine, int lineNumber) {
        VirtualFile file2 = $this$hasExecutableCodeInsideOnLine.getContainingFile().getVirtualFile();
        KtElement ktElement = (KtElement)$this$hasExecutableCodeInsideOnLine;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
        Project project2 = $this$hasExecutableCodeInsideOnLine.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        return BreakpointTypeUtilsKt.hasExecutableCodeInsideOnLine(ktElement, file2, lineNumber, project2, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)new Function1<PsiElement, ApplicabilityResult>(file2, lineNumber){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ int $lineNumber;
            {
                this.$file = $file;
                this.$lineNumber = $lineNumber;
                super(1);
            }

            @NotNull
            public final ApplicabilityResult invoke(@NotNull PsiElement element3) {
                ApplicabilityResult applicabilityResult;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                PsiElement psiElement2 = element3;
                if (psiElement2 instanceof KtNamedFunction) {
                    applicabilityResult = ApplicabilityResult.UNKNOWN;
                } else if (psiElement2 instanceof KtElement) {
                    VirtualFile virtualFile2 = this.$file;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file");
                    LineBreakpointExpressionVisitor visitor2 = LineBreakpointExpressionVisitor.Companion.of(virtualFile2, this.$lineNumber);
                    applicabilityResult = visitor2 != null ? (ApplicabilityResult)((KtElement)element3).accept((KtVisitor)visitor2, null) : ApplicabilityResult.UNKNOWN;
                } else {
                    applicabilityResult = ApplicabilityResult.UNKNOWN;
                }
                return applicabilityResult;
            }
        })) || this.hasImplicitReturnOnLine($this$hasExecutableCodeInsideOnLine, lineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean hasImplicitReturnOnLine(KtFunction function2, int lineNumber) {
        boolean bl;
        void this_$iv$iv$iv;
        void this_$iv$iv;
        if (!(function2 instanceof KtFunctionLiteral) || PsiLinesUtilsKt.getLineNumber((PsiElement)function2, false) != lineNumber) {
            return false;
        }
        Object nonDefaultLifetimeTokenFactory$iv = null;
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)function2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyse = false;
        KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
        void var9_8 = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)function2, factory$iv$iv);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtAnalysisSession $this$hasImplicitReturnOnLine_u24lambda_u2417 = analysisSession$iv$iv$iv;
            boolean bl2 = false;
            KtType functionalType = $this$hasImplicitReturnOnLine_u24lambda_u2417.getFunctionalType(function2);
            KtType ktType = functionalType instanceof KtFunctionalType ? (KtFunctionalType)functionalType : null;
            bl = ktType != null && (ktType = ktType.getReturnType()) != null ? $this$hasImplicitReturnOnLine_u24lambda_u2417.isUnit(ktType) : false;
        }
        finally {
            factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
        boolean isUnitReturnType = bl;
        if (!isUnitReturnType) {
            return false;
        }
        return !(this.lastStatementSkippingComments(function2) instanceof KtReturnExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KtElement lastStatementSkippingComments(KtFunction $this$lastStatementSkippingComments) {
        KtBlockExpression ktBlockExpression = $this$lastStatementSkippingComments.getBodyBlockExpression();
        Object object = ktBlockExpression;
        if (ktBlockExpression == null) return null;
        PsiElement $this$childrenOfType$iv = (PsiElement)object;
        boolean $i$f$childrenOfType = false;
        List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, KtElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(this, T::class.java)");
        object = list2;
        if (list2 == null) return null;
        KtElement ktElement = (KtElement)CollectionsKt.lastOrNull((List)object);
        return ktElement;
    }

    private final KtFunction getSamLambdaWithIndex(List<? extends KtFunction> $this$getSamLambdaWithIndex, int index) {
        int samLambdaCounter = 0;
        for (KtFunction ktFunction : $this$getSamLambdaWithIndex) {
            if (!KotlinPositionManagerKt.access$isSamLambda(ktFunction)) continue;
            if (samLambdaCounter == index) {
                return ktFunction;
            }
            ++samLambdaCounter;
        }
        return null;
    }

    private final PsiFile getPsiFileByLocation(Location location2) {
        String string2;
        String string3 = SafeUtilKt.safeSourceName(location2);
        if (string3 == null) {
            return null;
        }
        String sourceName2 = string3;
        try {
            String string4;
            ReferenceType referenceType = location2.declaringType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"location.declaringType()");
            if (DebuggerUtil.containsKotlinStrata(referenceType)) {
                String string5 = location2.sourcePath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"location.sourcePath()");
                string4 = StringsKt.replace$default((String)string5, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            } else {
                string4 = this.defaultInternalName(location2);
            }
            string2 = string4;
        }
        catch (AbsentInformationException e) {
            string2 = this.defaultInternalName(location2);
        }
        String referenceInternalName = string2;
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)referenceInternalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(referenceInternalName)");
        JvmClassName className = jvmClassName;
        Project project2 = this.debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        return (PsiFile)DebuggerUtils.INSTANCE.findSourceFileForClass(project2, this.sourceSearchScopes, className, sourceName2, location2);
    }

    private final String defaultInternalName(Location location2) {
        String referenceFqName = location2.declaringType().name();
        Intrinsics.checkNotNullExpressionValue((Object)referenceFqName, (String)"referenceFqName");
        return StringsKt.replace$default((String)referenceFqName, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        PsiFile psiFile2 = sourcePosition2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"sourcePosition.file");
        PsiFile psiFile3 = psiFile2;
        if (psiFile3 instanceof KtFile) {
            Project project2 = ((KtFile)psiFile3).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiFile.project");
            List list2 = (List)KotlinPluginDisposableUtils.syncNonBlockingReadAction(project2, (Function0)new Function0<List<? extends ReferenceType>>(psiFile3, this, sourcePosition2){
                final /* synthetic */ PsiFile $psiFile;
                final /* synthetic */ KotlinPositionManager this$0;
                final /* synthetic */ SourcePosition $sourcePosition;
                {
                    this.$psiFile = $psiFile;
                    this.this$0 = $receiver;
                    this.$sourcePosition = $sourcePosition;
                    super(0);
                }

                @Nullable
                public final List<ReferenceType> invoke() {
                    if (!SourceKindFilterUtils.matches(RootKindFilter.projectAndLibrarySources, (PsiElement)this.$psiFile)) {
                        return null;
                    }
                    return KotlinPositionManager.access$getReferenceTypesForPositionInKotlinFile(this.this$0, this.$sourcePosition);
                }
            });
            if (list2 == null) {
                return CollectionsKt.emptyList();
            }
            List referenceTypesInKtFile2 = list2;
            if (ComposeUtilsKt.isInsideProjectWithCompose(sourcePosition2)) {
                return CollectionsKt.plus((Collection)referenceTypesInKtFile2, (Iterable)ComposeUtilsKt.getComposableSingletonsClasses(this.debugProcess, (KtFile)psiFile3));
            }
            return referenceTypesInKtFile2;
        }
        if (psiFile3 instanceof ClsFileImpl) {
            Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>(psiFile3){
                final /* synthetic */ PsiFile $psiFile;
                {
                    this.$psiFile = $psiFile;
                    super(0);
                }

                @NotNull
                public final PsiFile invoke() {
                    return ((ClsFileImpl)this.$psiFile).getDecompiledPsiFile();
                }
            }));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"psiFile = sourcePosition\u2026iFile.decompiledPsiFile }");
            PsiFile decompiledPsiFile2 = (PsiFile)object;
            if (decompiledPsiFile2 instanceof KtClsFile && ((Number)ActionsKt.runReadAction((Function0)((Function0)new Function0<Integer>(sourcePosition2){
                final /* synthetic */ SourcePosition $sourcePosition;
                {
                    this.$sourcePosition = $sourcePosition;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    return this.$sourcePosition.getLine();
                }
            }))).intValue() == -1) {
                String className = JvmFileClassUtil.getFileClassInternalName((KtFile)((KtFile)decompiledPsiFile2));
                List list3 = this.debugProcess.getVirtualMachineProxy().classesByName(className);
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"debugProcess.virtualMach\u2026.classesByName(className)");
                return list3;
            }
        }
        NoDataException noDataException = NoDataException.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
        throw (Throwable)noDataException;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private final List<ReferenceType> getReferenceTypesForPositionInKotlinFile(SourcePosition sourcePosition2) {
        Project project2 = this.debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"debugProcess.project");
        GlobalSearchScope globalSearchScope = this.debugProcess.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"debugProcess.searchScope");
        ClassNameProvider classNameProvider = new ClassNameProvider(project2, globalSearchScope, ClassNameProvider.Configuration.Companion.getDEFAULT());
        int lineNumber = sourcePosition2.getLine();
        try {
            Collection collection;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            Iterable iterable = classNameProvider.getCandidates(sourcePosition2);
            boolean $i$f$flatMap22 = false;
            void var7_7 = $this$flatMap$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                String className = (String)element$iv$iv;
                boolean bl = false;
                List list2 = this.debugProcess.getVirtualMachineProxy().classesByName(className);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"debugProcess.virtualMach\u2026.classesByName(className)");
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List allCandidates = (List)destination$iv$iv;
            Iterable $i$f$flatMap22 = allCandidates;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ReferenceType referenceType = (ReferenceType)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"referenceType");
                Iterable list$iv$iv = KotlinPositionManagerKt.access$findTargetClasses(this.debugProcess, referenceType, lineNumber);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List matchingCandidates = (List)destination$iv$iv2;
            Collection collection2 = matchingCandidates;
            if (collection2.isEmpty()) {
                boolean bl = false;
                collection = allCandidates;
            } else {
                collection = collection2;
            }
            return (List)collection;
        }
        catch (IncompatibleThreadStateException e) {
            return CollectionsKt.emptyList();
        }
        catch (VMDisconnectedException e) {
            return CollectionsKt.emptyList();
        }
    }

    @Deprecated(message="Use 'ClassNameProvider' directly")
    @NotNull
    public final List<String> originalClassNamesForPosition(@NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends String>>(this, position){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ SourcePosition $position;
            {
                this.this$0 = $receiver;
                this.$position = $position;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                Project project2 = KotlinPositionManager.access$getDebugProcess$p(this.this$0).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"debugProcess.project");
                GlobalSearchScope globalSearchScope = KotlinPositionManager.access$getDebugProcess$p(this.this$0).getSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"debugProcess.searchScope");
                ClassNameProvider classNameProvider = new ClassNameProvider(project2, globalSearchScope, ClassNameProvider.Configuration.copy$default(ClassNameProvider.Configuration.Companion.getDEFAULT(), false, false, 2, null));
                return classNameProvider.getCandidates(this.$position);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (!(position.getFile() instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        try {
            void $this$filterTo$iv$iv;
            List inlineLocations2;
            if (DexDebugFacility.INSTANCE.isDex(this.debugProcess) && !((Collection)(inlineLocations2 = (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends Location>>(type2, position, this){
                final /* synthetic */ ReferenceType $type;
                final /* synthetic */ SourcePosition $position;
                final /* synthetic */ KotlinPositionManager this$0;
                {
                    this.$type = $type;
                    this.$position = $position;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final List<Location> invoke() {
                    GlobalSearchScope globalSearchScope = KotlinPositionManager.access$getDebugProcess$p(this.this$0).getSearchScope();
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"debugProcess.searchScope");
                    return DebuggerUtils.INSTANCE.getLocationsOfInlinedLine(this.$type, this.$position, globalSearchScope);
                }
            })))).isEmpty()) {
                return inlineLocations2;
            }
            int line = position.getLine() + 1;
            List locations = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type2, (String)"Kotlin", null, (int)line);
            Collection collection = locations;
            if (collection == null || collection.isEmpty()) {
                NoDataException noDataException = NoDataException.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
                throw (Throwable)noDataException;
            }
            Intrinsics.checkNotNullExpressionValue((Object)locations, (String)"locations");
            Iterable $this$filter$iv = locations;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Location it = (Location)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.sourceName("Kotlin"), (Object)position.getFile().getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        catch (AbsentInformationException e) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
    }

    @Deprecated(message="Since Idea 14.0.3 use createPrepareRequests fun", replaceWith=@ReplaceWith(expression="createPrepareRequests(classPrepareRequestor, sourcePosition).firstOrNull()", imports={}))
    @Nullable
    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor classPrepareRequestor, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)classPrepareRequestor, (String)"classPrepareRequestor");
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        return (ClassPrepareRequest)CollectionsKt.firstOrNull(this.createPrepareRequests(classPrepareRequestor, sourcePosition2));
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        DebugProcessImpl debugProcessImpl;
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        PsiFile psiFile2 = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"position.file");
        PsiFile file2 = psiFile2;
        if (!(file2 instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)noDataException), (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        boolean isInsideProjectWithCompose = ComposeUtilsKt.isInsideProjectWithCompose(position);
        NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking(() -> KotlinPositionManager.createPrepareRequests$lambda$22(this, requestor, position, isInsideProjectWithCompose, file2)).inSmartMode(this.debugProcess.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction, (String)"nonBlocking<List<ClassPr\u2026ode(debugProcess.project)");
        NonBlockingReadAction nonBlocking2 = nonBlockingReadAction;
        ClassPrepareRequestor $this$safeAs$iv = requestor;
        boolean $i$f$safeAs = false;
        ClassPrepareRequestor classPrepareRequestor = $this$safeAs$iv;
        if (!(classPrepareRequestor instanceof Breakpoint)) {
            classPrepareRequestor = null;
        }
        Breakpoint breakpoint2 = (Breakpoint)classPrepareRequestor;
        XBreakpoint xBreakpoint = breakpoint2 != null ? breakpoint2.getXBreakpoint() : null;
        DebugProcess $this$asSafely$iv = this.debugProcess;
        boolean $i$f$asSafely = false;
        DebugProcess debugProcess = $this$asSafely$iv;
        if (!(debugProcess instanceof DebugProcessImpl)) {
            debugProcess = null;
        }
        XDebugSession $this$asSafely$iv2 = (debugProcessImpl = (DebugProcessImpl)debugProcess) != null && (debugProcessImpl = debugProcessImpl.getXdebugProcess()) != null ? debugProcessImpl.getSession() : null;
        boolean $i$f$asSafely2 = false;
        XDebugSession xDebugSession = $this$asSafely$iv2;
        if (!(xDebugSession instanceof XDebugSessionImpl)) {
            xDebugSession = null;
        }
        XDebugSessionImpl xSession = (XDebugSessionImpl)xDebugSession;
        if (xBreakpoint != null && xSession != null) {
            NonBlockingReadAction nonBlockingReadAction2 = nonBlocking2.expireWhen(() -> KotlinPositionManager.createPrepareRequests$lambda$23(xSession, xBreakpoint));
            Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction2, (String)"nonBlocking.expireWhen {\u2026ointActive(xBreakpoint) }");
            nonBlocking2 = nonBlockingReadAction2;
        }
        try {
            Object object = nonBlocking2.executeSynchronously();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nonBlocking.executeSynchronously()");
            return (List)object;
        }
        catch (ProcessCanceledException processCanceledException) {
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private final List<ClassPrepareRequest> createKotlinClassPrepareRequests(ClassPrepareRequestor requestor, SourcePosition position) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        SourcePosition refinedPosition = requestor instanceof SourcePositionRefiner ? ((SourcePositionRefiner)requestor).refineSourcePosition(position) : position;
        Project project2 = this.debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"debugProcess.project");
        GlobalSearchScope globalSearchScope = this.debugProcess.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"debugProcess.searchScope");
        Iterable iterable = new ClassNameProvider(project2, globalSearchScope, ClassNameProvider.Configuration.Companion.getDEFAULT()).getCandidates(refinedPosition);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String name2 = (String)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new ClassPrepareRequest[]{this.debugProcess.getRequestsManager().createClassPrepareRequest(requestor, name2), this.debugProcess.getRequestsManager().createClassPrepareRequest(requestor, name2 + "$*")};
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List createPrepareRequests$lambda$22(KotlinPositionManager this$0, ClassPrepareRequestor $requestor, SourcePosition $position, boolean $isInsideProjectWithCompose, PsiFile $file) {
        ClassPrepareRequest singletonRequest;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$requestor, (String)"$requestor");
        Intrinsics.checkNotNullParameter((Object)$position, (String)"$position");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        List kotlinRequests = this$0.createKotlinClassPrepareRequests($requestor, $position);
        return $isInsideProjectWithCompose ? ((singletonRequest = ComposeUtilsKt.getClassPrepareRequestForComposableSingletons(this$0.debugProcess, $requestor, (KtFile)$file)) == null ? kotlinRequests : CollectionsKt.plus((Collection)kotlinRequests, (Object)singletonRequest)) : kotlinRequests;
    }

    private static final boolean createPrepareRequests$lambda$23(XDebugSessionImpl $xSession, XBreakpoint $xBreakpoint) {
        return !$xSession.isBreakpointActive($xBreakpoint);
    }

    public static final /* synthetic */ List access$getReferenceTypesForPositionInKotlinFile(KotlinPositionManager $this, SourcePosition sourcePosition2) {
        return $this.getReferenceTypesForPositionInKotlinFile(sourcePosition2);
    }

    public static final /* synthetic */ DebugProcess access$getDebugProcess$p(KotlinPositionManager $this) {
        return $this.debugProcess;
    }
}

