/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.dependencies;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsFieldImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.util.MethodSignatureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependencySourceNavigationPolicyForJavaClasses;", "Lcom/intellij/psi/impl/compiled/ClsCustomNavigationPolicy;", "()V", "getNavigationElement", "Lcom/intellij/psi/PsiClass;", "clsClass", "Lcom/intellij/psi/impl/compiled/ClsClassImpl;", "Lcom/intellij/psi/PsiElement;", "clsField", "Lcom/intellij/psi/impl/compiled/ClsFieldImpl;", "file", "Lcom/intellij/psi/impl/compiled/ClsFileImpl;", "clsMethod", "Lcom/intellij/psi/impl/compiled/ClsMethodImpl;", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptDependencySourceNavigationPolicyForJavaClasses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDependencySourceNavigationPolicyForJavaClasses.kt\norg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependencySourceNavigationPolicyForJavaClasses\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1282#2,2:57\n110#3:59\n766#4:60\n857#4,2:61\n*S KotlinDebug\n*F\n+ 1 ScriptDependencySourceNavigationPolicyForJavaClasses.kt\norg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependencySourceNavigationPolicyForJavaClasses\n*L\n27#1:57,2\n38#1:59\n45#1:60\n45#1:61,2\n*E\n"})
public final class ScriptDependencySourceNavigationPolicyForJavaClasses
implements ClsCustomNavigationPolicy {
    @Nullable
    public PsiClass getNavigationElement(@NotNull ClsClassImpl clsClass) {
        ClsClassImpl containingClass;
        Intrinsics.checkNotNullParameter((Object)clsClass, (String)"clsClass");
        PsiClass psiClass2 = clsClass.getContainingClass();
        ClsClassImpl clsClassImpl = containingClass = psiClass2 instanceof ClsClassImpl ? (ClsClassImpl)psiClass2 : null;
        if (containingClass != null) {
            PsiClass psiClass3 = this.getNavigationElement(containingClass);
            return psiClass3 != null ? psiClass3.findInnerClassByName(clsClass.getName(), false) : null;
        }
        PsiFile psiFile2 = clsClass.getContainingFile();
        ClsFileImpl clsFileImpl = psiFile2 instanceof ClsFileImpl ? (ClsFileImpl)psiFile2 : null;
        if (clsFileImpl == null) {
            return null;
        }
        ClsFileImpl clsFileImpl2 = clsFileImpl;
        psiFile2 = this.getNavigationElement(clsFileImpl2);
        Object[] objectArray = psiFile2 instanceof PsiClassOwner ? (Object[])psiFile2 : null;
        return objectArray != null && (objectArray = objectArray.getClasses()) != null ? (PsiClass)ArraysKt.singleOrNull((Object[])objectArray) : null;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsMethodImpl clsMethod) {
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter((Object)clsMethod, (String)"clsMethod");
            PsiClass psiClass2 = clsMethod.getContainingClass();
            Intrinsics.checkNotNull((Object)psiClass2, (String)"null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
            PsiClass psiClass3 = this.getNavigationElement((ClsClassImpl)psiClass2);
            if (psiClass3 == null) {
                return null;
            }
            PsiClass clsClass = psiClass3;
            PsiMethod[] psiMethodArray = clsClass.findMethodsByName(clsMethod.getName(), false);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"clsClass.findMethodsByName(clsMethod.name, false)");
            Object[] $this$firstOrNull$iv = psiMethodArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                boolean bl = false;
                if (!MethodSignatureUtil.areParametersErasureEqual((PsiMethod)it, (PsiMethod)((PsiMethod)clsMethod))) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        return (PsiElement)object;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsFieldImpl clsField) {
        Intrinsics.checkNotNullParameter((Object)clsField, (String)"clsField");
        PsiClass psiClass2 = clsField.getContainingClass();
        Intrinsics.checkNotNull((Object)psiClass2, (String)"null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        PsiClass psiClass3 = this.getNavigationElement((ClsClassImpl)psiClass2);
        if (psiClass3 == null) {
            return null;
        }
        PsiClass srcClass = psiClass3;
        return (PsiElement)srcClass.findFieldByName(clsField.getName(), false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsFileImpl file2) {
        PsiFile sourcePsi;
        VirtualFile root;
        VirtualFile sourceFile2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        VirtualFile virtualFile2 = file2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.virtualFile");
        VirtualFile virtualFile3 = virtualFile2;
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        Project project3 = project2;
        PsiClass[] psiClassArray = file2.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"file.classes");
        PsiClass psiClass2 = (PsiClass)ArraysKt.firstOrNull((Object[])psiClassArray);
        PsiClass psiClass3 = psiClass2;
        if (psiClass2 == null) return null;
        PsiClass $this$safeAs$iv = psiClass3;
        boolean $i$f$safeAs = false;
        PsiClass psiClass4 = $this$safeAs$iv;
        if (!(psiClass4 instanceof ClsClassImpl)) {
            psiClass4 = null;
        }
        ClsClassImpl clsClassImpl = (ClsClassImpl)psiClass4;
        psiClass3 = clsClassImpl;
        if (clsClassImpl == null) return null;
        String string2 = psiClass3.getSourceFileName();
        if (string2 == null) {
            return null;
        }
        String sourceFileName = string2;
        if (!ScriptConfigurationManager.Companion.getInstance(project3).getAllScriptsDependenciesClassFilesScope().contains(virtualFile3)) {
            return null;
        }
        String string3 = file2.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.packageName");
        String packageName2 = string3;
        String relativePath = ((CharSequence)packageName2).length() == 0 ? sourceFileName : StringsKt.replace$default((String)packageName2, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + sourceFileName;
        Iterable $this$filter$iv = ScriptConfigurationManager.Companion.getInstance(project3).getAllScriptDependenciesSources();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!it.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator2 = ((List)destination$iv$iv).iterator();
        do {
            if (!iterator2.hasNext()) return null;
        } while ((sourceFile2 = (root = (VirtualFile)iterator2.next()).findFileByRelativePath(relativePath)) == null || !sourceFile2.isValid() || !((sourcePsi = file2.getManager().findFile(sourceFile2)) instanceof PsiClassOwner));
        return (PsiElement)sourcePsi;
    }
}

