/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.core.TypesWithOperatorDetector;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.idea.util.FuzzyTypeUtils;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/core/TypesWithContainsDetector;", "Lorg/jetbrains/kotlin/idea/core/TypesWithOperatorDetector;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "indicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "argumentType", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;Lorg/jetbrains/kotlin/types/KotlinType;)V", "checkIsSuitableByType", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "operator", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "freeTypeParams", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.base.fe10.analysis"})
public final class TypesWithContainsDetector
extends TypesWithOperatorDetector {
    @NotNull
    private final KotlinType argumentType;

    public TypesWithContainsDetector(@NotNull LexicalScope scope2, @Nullable KotlinIndicesHelper indicesHelper2, @NotNull KotlinType argumentType) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        super(OperatorNameConventions.CONTAINS, scope2, indicesHelper2);
        this.argumentType = argumentType;
    }

    @Override
    @Nullable
    protected TypeSubstitutor checkIsSuitableByType(@NotNull FunctionDescriptor operator, @NotNull Collection<? extends TypeParameterDescriptor> freeTypeParams) {
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter(freeTypeParams, (String)"freeTypeParams");
        List list2 = operator.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"operator.valueParameters");
        ValueParameterDescriptor parameter2 = (ValueParameterDescriptor)CollectionsKt.single((List)list2);
        KotlinType kotlinType = parameter2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameter.type");
        List list3 = operator.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"operator.typeParameters");
        FuzzyType fuzzyParameterType = FuzzyTypeUtils.toFuzzyType(kotlinType, CollectionsKt.plus((Collection)list3, (Iterable)freeTypeParams));
        return fuzzyParameterType.checkIsSuperTypeOf(this.argumentType);
    }
}

