/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a8\u0006\u0007"}, d2={"isDeprecatedAtCallSite", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "languageVersionSettings", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "kotlin.completion.impl-k1"})
public final class DeclarationLookupObjectImplKt {
    public static final boolean isDeprecatedAtCallSite(@NotNull DeclarationDescriptor descriptor2, @NotNull Function0<? extends LanguageVersionSettings> languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(languageVersionSettings2, (String)"languageVersionSettings");
        if (!KotlinBuiltIns.isDeprecated((DeclarationDescriptor)descriptor2)) {
            return false;
        }
        AnnotationDescriptor annotationDescriptor = descriptor2.getOriginal().getAnnotations().findAnnotation(StandardNames.FqNames.deprecatedSinceKotlin);
        if (annotationDescriptor == null) {
            return true;
        }
        AnnotationDescriptor annotation = annotationDescriptor;
        ApiVersion hiddenSince = DeprecationUtilKt.getSinceVersion((AnnotationDescriptor)annotation, (String)"hiddenSince");
        ApiVersion errorSince = DeprecationUtilKt.getSinceVersion((AnnotationDescriptor)annotation, (String)"errorSince");
        ApiVersion warningSince = DeprecationUtilKt.getSinceVersion((AnnotationDescriptor)annotation, (String)"warningSince");
        if (hiddenSince == null && errorSince == null && warningSince == null) {
            return false;
        }
        LanguageVersionSettings languageVersionSettings3 = (LanguageVersionSettings)languageVersionSettings2.invoke();
        if (languageVersionSettings3 == null || (languageVersionSettings3 = languageVersionSettings3.getApiVersion()) == null) {
            return true;
        }
        LanguageVersionSettings apiVersion2 = languageVersionSettings3;
        if (hiddenSince != null && apiVersion2.compareTo(hiddenSince) >= 0) {
            return true;
        }
        if (errorSince != null && apiVersion2.compareTo(errorSince) >= 0) {
            return true;
        }
        return warningSince != null && apiVersion2.compareTo(warningSince) >= 0;
    }
}

