/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.KotlinApplicator;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.KotlinApplicatorInput;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0000*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005B)\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0094\u0002R\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\u0007\u001a\u00028\u00018\bX\u0089\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinApplicatorBasedQuickFix;", "PSI", "Lcom/intellij/psi/PsiElement;", "INPUT", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicatorInput;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "target", "input", "applicator", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicator;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicatorInput;Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicator;)V", "getApplicator", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicator;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicatorInput;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.code-insight.api"})
public final class KotlinApplicatorBasedQuickFix<PSI extends PsiElement, INPUT extends KotlinApplicatorInput>
extends KotlinQuickFixAction<PSI> {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final INPUT input;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final KotlinApplicator<PSI, INPUT> applicator;

    public KotlinApplicatorBasedQuickFix(@NotNull PSI target2, @NotNull INPUT input, @NotNull KotlinApplicator<? super PSI, ? super INPUT> applicator2) {
        Intrinsics.checkNotNullParameter(target2, (String)"target");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(applicator2, (String)"applicator");
        super(target2);
        this.input = input;
        this.applicator = applicator2;
    }

    @NotNull
    public final KotlinApplicator<PSI, INPUT> getApplicator() {
        return this.applicator;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object t = this.getElement();
        if (t == null) {
            return;
        }
        Object element3 = t;
        if (this.applicator.isApplicableByPsi(element3, project2) && this.input.isValidFor((PsiElement)element3)) {
            this.applicator.applyTo(element3, this.input, project2, editor2);
        }
    }

    @NotNull
    public String getText() {
        Object t = this.getElement();
        if (t == null) {
            return this.getFamilyName();
        }
        Object element3 = t;
        return this.input.isValidFor((PsiElement)element3) ? this.applicator.getActionName(element3, this.input) : this.applicator.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return this.applicator.getFamilyName();
    }
}

