/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinTrySurrounderBase;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtTryExpression;

public class KotlinTryFinallySurrounder
extends KotlinTrySurrounderBase {
    @Override
    protected String getCodeTemplate() {
        return "try { \n} finally {\nb\n}";
    }

    @Override
    @Nullable
    protected TextRange surroundStatements(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiElement container2, @NotNull PsiElement[] statements2) {
        TextRange textRange;
        if (project2 == null) {
            KotlinTryFinallySurrounder.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            KotlinTryFinallySurrounder.$$$reportNull$$$0(1);
        }
        if (container2 == null) {
            KotlinTryFinallySurrounder.$$$reportNull$$$0(2);
        }
        if (statements2 == null) {
            KotlinTryFinallySurrounder.$$$reportNull$$$0(3);
        }
        if ((textRange = super.surroundStatements(project2, editor2, container2, statements2)) == null) {
            return null;
        }
        editor2.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
        return new TextRange(textRange.getStartOffset(), textRange.getStartOffset());
    }

    @Override
    @NotNull
    protected TextRange getTextRangeForCaret(@NotNull KtTryExpression expression2) {
        if (expression2 == null) {
            KotlinTryFinallySurrounder.$$$reportNull$$$0(4);
        }
        KtFinallySection block2 = expression2.getFinallyBlock();
        assert (block2 != null) : "Finally block should exists for " + expression2.getText();
        KtExpression blockExpression2 = (KtExpression)block2.getFinalExpression().getStatements().get(0);
        TextRange textRange = blockExpression2.getTextRange();
        if (textRange == null) {
            KotlinTryFinallySurrounder.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.try.finally.template", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTryFinallySurrounder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTryFinallySurrounder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRangeForCaret";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "surroundStatements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTextRangeForCaret";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5 -> new IllegalStateException(string2);
        };
    }
}

