/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\b*\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/WrapUnaryOperatorInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isUnaryMinusOrPlus", "Lcom/intellij/psi/tree/IElementType;", "Holder", "WrapUnaryOperatorQuickfix", "kotlin.code-insight.inspections-shared"})
public final class WrapUnaryOperatorInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.prefixExpressionVisitor((Function1)((Function1)new Function1<KtPrefixExpression, Unit>(this, holder){
            final /* synthetic */ WrapUnaryOperatorInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtPrefixExpression expression2) {
                KtExpression receiverExpression;
                KtExpression baseExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IElementType iElementType = expression2.getOperationToken();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expression.operationToken");
                if (WrapUnaryOperatorInspection.access$isUnaryMinusOrPlus(this.this$0, iElementType) && (baseExpression = expression2.getBaseExpression()) instanceof KtDotQualifiedExpression && (receiverExpression = ((KtDotQualifiedExpression)baseExpression).getReceiverExpression()) instanceof KtConstantExpression && Holder.INSTANCE.getNumberTypes().contains(((KtConstantExpression)receiverExpression).getNode().getElementType())) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new WrapUnaryOperatorQuickfix()};
                    this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("wrap.unary.operator.quickfix.text", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
                }
            }
        }));
    }

    private final boolean isUnaryMinusOrPlus(IElementType $this$isUnaryMinusOrPlus) {
        return Intrinsics.areEqual((Object)$this$isUnaryMinusOrPlus, (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)$this$isUnaryMinusOrPlus, (Object)KtTokens.PLUS);
    }

    public static final /* synthetic */ boolean access$isUnaryMinusOrPlus(WrapUnaryOperatorInspection $this, IElementType $receiver) {
        return $this.isUnaryMinusOrPlus($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/WrapUnaryOperatorInspection$Holder;", "", "()V", "numberTypes", "", "Lcom/intellij/psi/tree/IElementType;", "getNumberTypes", "()Ljava/util/List;", "kotlin.code-insight.inspections-shared"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final List<IElementType> numberTypes;

        private Holder() {
        }

        @NotNull
        public final List<IElementType> getNumberTypes() {
            return numberTypes;
        }

        static {
            Object[] objectArray = new IElementType[]{KtNodeTypes.INTEGER_CONSTANT, KtNodeTypes.FLOAT_CONSTANT};
            numberTypes = CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/WrapUnaryOperatorInspection$WrapUnaryOperatorQuickfix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.code-insight.inspections-shared"})
    private static final class WrapUnaryOperatorQuickfix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("wrap.unary.operator.quickfix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtPrefixExpression ktPrefixExpression = psiElement2 instanceof KtPrefixExpression ? (KtPrefixExpression)psiElement2 : null;
            if (ktPrefixExpression == null) {
                return;
            }
            KtPrefixExpression expression2 = ktPrefixExpression;
            KtExpression ktExpression = expression2.getBaseExpression();
            KtDotQualifiedExpression ktDotQualifiedExpression = ktExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null;
            if (ktDotQualifiedExpression == null) {
                return;
            }
            KtDotQualifiedExpression dotQualifiedExpression = ktDotQualifiedExpression;
            KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)expression2.getOperationReference().getText(), (String)"expression.operationReference.text");
            objectArray[1] = KotlinPsiUtilsKt.getLeftMostReceiverExpression(dotQualifiedExpression);
            KtExpression newReceiver = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"($0$1)", (Object[])objectArray, (boolean)false, (int)4, null);
            KtExpression newExpression2 = KotlinPsiUtilsKt.replaceFirstReceiver$default(dotQualifiedExpression, factory2, newReceiver, false, 4, null);
            expression2.replace((PsiElement)newExpression2);
        }
    }
}

