/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.NegatedBinaryExpressionSimplificationUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/SimplifyNegatedBinaryExpressionInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "inspectionText", "isApplicable", "", "kotlin.code-insight.inspections-shared"})
public final class SimplifyNegatedBinaryExpressionInspection
extends AbstractApplicabilityBasedInspection<KtPrefixExpression> {
    public SimplifyNegatedBinaryExpressionInspection() {
        super(KtPrefixExpression.class);
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtPrefixExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return NegatedBinaryExpressionSimplificationUtils.INSTANCE.canBeSimplifiedWithoutChangingSemantics(element3) ? super.inspectionHighlightType((KtElement)element3) : ProblemHighlightType.INFORMATION;
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtPrefixExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("negated.operation.can.be.simplified", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("simplify.negated.operation", new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtPrefixExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)element3.getBaseExpression());
        KtOperationExpression ktOperationExpression = ktExpression instanceof KtOperationExpression ? (KtOperationExpression)ktExpression : null;
        if (ktOperationExpression == null) {
            return this.getDefaultFixText();
        }
        KtOperationExpression expression2 = ktOperationExpression;
        IElementType iElementType = expression2.getOperationReference().getReferencedNameElementType();
        KtSingleValueToken ktSingleValueToken = iElementType instanceof KtSingleValueToken ? (KtSingleValueToken)iElementType : null;
        if (ktSingleValueToken == null) {
            return this.getDefaultFixText();
        }
        KtSingleValueToken operation2 = ktSingleValueToken;
        KtSingleValueToken ktSingleValueToken2 = NegatedBinaryExpressionSimplificationUtils.INSTANCE.negate((IElementType)operation2);
        if (ktSingleValueToken2 == null) {
            return this.getDefaultFixText();
        }
        KtSingleValueToken negatedOperation = ktSingleValueToken2;
        String message2 = NegatedBinaryExpressionSimplificationUtils.INSTANCE.canBeSimplifiedWithoutChangingSemantics(element3) ? "replace.negated.0.operation.with.1" : "replace.negated.0.operation.with.1.may.change.semantics.with.floating.point.types";
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)operation2.getValue(), (String)"operation.value");
        Intrinsics.checkNotNullExpressionValue((Object)negatedOperation.getValue(), (String)"negatedOperation.value");
        return KotlinBundle.message(message2, objectArray);
    }

    @Override
    public boolean isApplicable(@NotNull KtPrefixExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return NegatedBinaryExpressionSimplificationUtils.INSTANCE.canBeSimplified(element3);
    }

    @Override
    public void applyTo(@NotNull KtPrefixExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        NegatedBinaryExpressionSimplificationUtils.INSTANCE.simplify(element3);
    }
}

