/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.InvalidModuleException;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.idea.caches.resolve.CodeFragmentAnalyzer;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinResolveDataProvider;
import org.jetbrains.kotlin.idea.caches.resolve.PerFileAnalysisCache;
import org.jetbrains.kotlin.idea.caches.resolve.PerFileAnalysisCacheKt;
import org.jetbrains.kotlin.idea.caches.resolve.StackedCompositeBindingContextTrace;
import org.jetbrains.kotlin.idea.caches.trackers.PureKotlinCodeBlockModificationListenerKt;
import org.jetbrains.kotlin.idea.stubindex.resolve.PluginDeclarationProviderFactory;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolveCache;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.storage.CancellableSimpleLock;
import org.jetbrains.kotlin.storage.SimpleLock;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020%H\u0002J\b\u0010-\u001a\u00020+H\u0002J\u0017\u0010.\u001a\u0004\u0018\u00010\f2\u0006\u0010,\u001a\u00020%H\u0000\u00a2\u0006\u0002\b/J!\u00100\u001a\u00020\f2\u0006\u0010,\u001a\u00020%2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0000\u00a2\u0006\u0002\b1J\u0014\u00102\u001a\u0004\u0018\u00010\f2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\f2\u0006\u0010$\u001a\u00020%H\u0002J\b\u00104\u001a\u00020+H\u0002J \u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\f2\u0006\u00108\u001a\u000209H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/PerFileAnalysisCache;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "componentProvider", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/container/ComponentProvider;)V", "bodyResolveCache", "Lorg/jetbrains/kotlin/resolve/BodyResolveCache;", "cache", "Ljava/util/HashMap;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "Lkotlin/collections/HashMap;", "codeFragmentAnalyzer", "Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "fileResult", "globalContext", "Lorg/jetbrains/kotlin/context/GlobalContext;", "guardLock", "Lorg/jetbrains/kotlin/storage/CancellableSimpleLock;", "isValid", "", "isValid$kotlin_base_fe10_analysis", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "pluginDeclarationProviderFactory", "Lorg/jetbrains/kotlin/idea/stubindex/resolve/PluginDeclarationProviderFactory;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "analyze", "analyzableElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "callback", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink$DiagnosticsCallback;", "check", "", "element", "clearFileResultCache", "fetchAnalysisResults", "fetchAnalysisResults$kotlin_base_fe10_analysis", "getAnalysisResults", "getAnalysisResults$kotlin_base_fe10_analysis", "getIncrementalAnalysisResult", "lookUp", "updateFileResultFromCache", "wrapResult", "oldResult", "newResult", "elementBindingTrace", "Lorg/jetbrains/kotlin/idea/caches/resolve/StackedCompositeBindingContextTrace;", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nPerFileAnalysisCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerFileAnalysisCache.kt\norg/jetbrains/kotlin/idea/caches/resolve/PerFileAnalysisCache\n+ 2 Dsl.kt\norg/jetbrains/kotlin/container/DslKt\n+ 3 KotlinExceptionWithAttachments.kt\norg/jetbrains/kotlin/utils/KotlinExceptionWithAttachmentsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 locks.kt\norg/jetbrains/kotlin/storage/LocksKt\n+ 6 PerFileAnalysisCache.kt\norg/jetbrains/kotlin/idea/caches/resolve/PerFileAnalysisCacheKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 PerFileAnalysisCache.kt\norg/jetbrains/kotlin/idea/caches/resolve/PerFileAnalysisCacheKt$throwAsInvalidModuleException$1\n*L\n1#1,610:1\n37#2:611\n37#2:612\n37#2:613\n37#2:614\n37#2:615\n37#2:616\n54#3,8:617\n1#4:625\n30#5,3:626\n34#5,2:638\n337#6,4:629\n337#6,4:642\n336#6,3:646\n340#6:650\n336#6,3:651\n340#6:655\n336#6,3:656\n340#6:660\n819#7:633\n847#7,2:634\n1855#7,2:636\n1855#7,2:640\n1855#7,2:661\n336#8:649\n336#8:654\n336#8:659\n*S KotlinDebug\n*F\n+ 1 PerFileAnalysisCache.kt\norg/jetbrains/kotlin/idea/caches/resolve/PerFileAnalysisCache\n*L\n62#1:611\n63#1:612\n64#1:613\n65#1:614\n66#1:615\n67#1:616\n79#1:617,8\n115#1:626,3\n115#1:638,2\n139#1:629,4\n202#1:642,4\n261#1:646,3\n261#1:650\n265#1:651,3\n265#1:655\n309#1:656,3\n309#1:660\n147#1:633\n147#1:634,2\n147#1:636,2\n192#1:640,2\n111#1:661,2\n261#1:649\n265#1:654\n309#1:659\n*E\n"})
public final class PerFileAnalysisCache {
    @NotNull
    private final KtFile file;
    @NotNull
    private final GlobalContext globalContext;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final ResolveSession resolveSession;
    @NotNull
    private final CodeFragmentAnalyzer codeFragmentAnalyzer;
    @NotNull
    private final BodyResolveCache bodyResolveCache;
    @NotNull
    private final PluginDeclarationProviderFactory pluginDeclarationProviderFactory;
    @NotNull
    private final HashMap<PsiElement, AnalysisResult> cache;
    @Nullable
    private AnalysisResult fileResult;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final CancellableSimpleLock guardLock;

    public PerFileAnalysisCache(@NotNull KtFile file2, @NotNull ComponentProvider componentProvider) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)componentProvider, (String)"componentProvider");
        this.file = file2;
        ComponentProvider $this$get$iv = componentProvider;
        boolean $i$f$get = false;
        this.globalContext = (GlobalContext)DslKt.getService((ComponentProvider)$this$get$iv, GlobalContext.class);
        $this$get$iv = componentProvider;
        $i$f$get = false;
        this.moduleDescriptor = (ModuleDescriptor)DslKt.getService((ComponentProvider)$this$get$iv, ModuleDescriptor.class);
        $this$get$iv = componentProvider;
        $i$f$get = false;
        this.resolveSession = (ResolveSession)DslKt.getService((ComponentProvider)$this$get$iv, ResolveSession.class);
        $this$get$iv = componentProvider;
        $i$f$get = false;
        this.codeFragmentAnalyzer = (CodeFragmentAnalyzer)DslKt.getService((ComponentProvider)$this$get$iv, CodeFragmentAnalyzer.class);
        $this$get$iv = componentProvider;
        $i$f$get = false;
        this.bodyResolveCache = (BodyResolveCache)DslKt.getService((ComponentProvider)$this$get$iv, BodyResolveCache.class);
        $this$get$iv = componentProvider;
        $i$f$get = false;
        this.pluginDeclarationProviderFactory = (PluginDeclarationProviderFactory)((Object)DslKt.getService((ComponentProvider)$this$get$iv, PluginDeclarationProviderFactory.class));
        this.cache = new HashMap();
        this.lock = new ReentrantLock();
        this.guardLock = new CancellableSimpleLock((Lock)this.lock, PerFileAnalysisCache::guardLock$lambda$0, (Function1)guardLock.2.INSTANCE);
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    private final void check(KtElement element3) {
        boolean value$iv = Intrinsics.areEqual((Object)element3.getContainingFile(), (Object)this.file);
        boolean $i$f$checkWithAttachment = false;
        if (!value$iv) {
            KotlinExceptionWithAttachments e$iv;
            boolean bl = false;
            String string2 = "Expected " + this.file + ", but was " + element3.getContainingFile() + " for " + (element3.isValid() ? "valid" : "invalid") + " " + element3 + " ";
            KotlinExceptionWithAttachments it = e$iv = new KotlinExceptionWithAttachments(string2);
            boolean bl2 = false;
            it.withPsiAttachment("element.kt", (PsiElement)element3);
            it.withPsiAttachment("file.kt", (PsiElement)element3.getContainingFile());
            it.withPsiAttachment("original.kt", (PsiElement)this.file);
            throw e$iv;
        }
    }

    public final boolean isValid$kotlin_base_fe10_analysis() {
        return this.moduleDescriptor.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final AnalysisResult fetchAnalysisResults$kotlin_base_fe10_analysis(@NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        this.check(element3);
        if (this.lock.tryLock()) {
            try {
                Object object;
                this.updateFileResultFromCache();
                AnalysisResult analysisResult2 = this.fileResult;
                if (analysisResult2 != null) {
                    AnalysisResult analysisResult3;
                    AnalysisResult it = analysisResult3 = analysisResult2;
                    boolean bl = false;
                    object = PureKotlinCodeBlockModificationListenerKt.getInBlockModifications(this.file).isEmpty() ? analysisResult3 : null;
                } else {
                    object = null;
                }
                AnalysisResult analysisResult4 = object;
                return analysisResult4;
            }
            finally {
                this.lock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final AnalysisResult getAnalysisResults$kotlin_base_fe10_analysis(@NotNull KtElement element3, @Nullable DiagnosticSink.DiagnosticsCallback callback2) {
        AnalysisResult analysisResult2;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        this.check(element3);
        KtElement ktElement = KotlinResolveDataProvider.INSTANCE.findAnalyzableParent(element3);
        if (ktElement == null) {
            return AnalysisResult.Companion.getEMPTY();
        }
        KtElement analyzableParent = ktElement;
        SimpleLock $this$guarded$iv = (SimpleLock)this.guardLock;
        boolean $i$f$guarded = false;
        $this$guarded$iv.lock();
        try {
            AnalysisResult analysisResult3;
            boolean bl = false;
            AnalysisResult analysisResult4 = this.getIncrementalAnalysisResult(callback2);
            if (analysisResult4 != null) {
                it = analysisResult4;
                boolean bl2 = false;
                analysisResult3 = PerFileAnalysisCache.getAnalysisResults$handleResult(it, callback2);
            } else {
                AnalysisResult analysisResult5 = this.lookUp(analyzableParent);
                if (analysisResult5 != null) {
                    it = analysisResult5;
                    boolean bl3 = false;
                    analysisResult3 = PerFileAnalysisCache.getAnalysisResults$handleResult(it, callback2);
                } else {
                    AnalysisResult analysisResult6;
                    Set localDiagnostics = new LinkedHashSet();
                    Function1 localCallback2 = callback2 != null ? (Function1)new Function1<Diagnostic, Unit>((Set<Diagnostic>)localDiagnostics, callback2){
                        final /* synthetic */ Set<Diagnostic> $localDiagnostics;
                        final /* synthetic */ DiagnosticSink.DiagnosticsCallback $callback;
                        {
                            this.$localDiagnostics = $localDiagnostics;
                            this.$callback = $callback;
                            super(1);
                        }

                        public final void invoke(@NotNull Diagnostic d) {
                            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                            this.$localDiagnostics.add(d);
                            this.$callback.callback(d);
                        }
                    } : null;
                    try {
                        analysisResult6 = this.analyze(analyzableParent, null, localCallback2 != null ? (DiagnosticSink.DiagnosticsCallback)new DiagnosticSink.DiagnosticsCallback(localCallback2){
                            private final /* synthetic */ Function1 function;
                            {
                                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                                this.function = function2;
                            }

                            public final /* synthetic */ void callback(Diagnostic p0) {
                                this.function.invoke((Object)p0);
                            }
                        } : null);
                    }
                    catch (Throwable e) {
                        Throwable $this$throwAsInvalidModuleException$iv = e;
                        boolean $i$f$throwAsInvalidModuleException = false;
                        InvalidModuleException invalidModuleException = PerFileAnalysisCacheKt.access$asInvalidModuleException($this$throwAsInvalidModuleException$iv);
                        if (invalidModuleException != null) {
                            InvalidModuleException it$iv = invalidModuleException;
                            boolean bl4 = false;
                            InvalidModuleException it = it$iv;
                            boolean bl5 = false;
                            throw (Throwable)new ProcessCanceledException((Throwable)it);
                        }
                        throw e;
                    }
                    AnalysisResult result2 = analysisResult6;
                    DiagnosticSink.DiagnosticsCallback diagnosticsCallback = callback2;
                    if (diagnosticsCallback != null) {
                        void $this$forEach$iv;
                        void $this$filterNotTo$iv$iv;
                        DiagnosticSink.DiagnosticsCallback c = diagnosticsCallback;
                        boolean bl6 = false;
                        Diagnostics diagnostics2 = result2.getBindingContext().getDiagnostics();
                        Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"result.bindingContext.diagnostics");
                        Iterable $this$filterNot$iv = (Iterable)diagnostics2;
                        boolean $i$f$filterNot = false;
                        Iterable bl4 = $this$filterNot$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterNotTo = false;
                        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                            Diagnostic it = (Diagnostic)element$iv$iv;
                            boolean bl7 = false;
                            if (localDiagnostics.contains(it)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterNot$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Diagnostic p0 = (Diagnostic)element$iv;
                            boolean bl8 = false;
                            c.callback(p0);
                        }
                    }
                    ((Map)this.cache).put(analyzableParent, result2);
                    analysisResult3 = result2;
                }
            }
            analysisResult2 = analysisResult3;
        }
        finally {
            $this$guarded$iv.unlock();
        }
        return analysisResult2;
    }

    public static /* synthetic */ AnalysisResult getAnalysisResults$kotlin_base_fe10_analysis$default(PerFileAnalysisCache perFileAnalysisCache, KtElement ktElement, DiagnosticSink.DiagnosticsCallback diagnosticsCallback, int n, Object object) {
        if ((n & 2) != 0) {
            diagnosticsCallback = null;
        }
        return perFileAnalysisCache.getAnalysisResults$kotlin_base_fe10_analysis(ktElement, diagnosticsCallback);
    }

    /*
     * WARNING - void declaration
     */
    private final AnalysisResult getIncrementalAnalysisResult(DiagnosticSink.DiagnosticsCallback callback2) {
        this.updateFileResultFromCache();
        Collection<KtElement> inBlockModifications = PureKotlinCodeBlockModificationListenerKt.getInBlockModifications(this.file);
        if (!inBlockModifications.isEmpty()) {
            try {
                Object v8;
                PerFileAnalysisCache perFileAnalysisCache = this;
                AnalysisResult analysisResult2 = this.fileResult;
                if (analysisResult2 != null) {
                    Object v2;
                    PerFileAnalysisCache perFileAnalysisCache2;
                    block16: {
                        void result2;
                        AnalysisResult analysisResult3 = analysisResult2;
                        perFileAnalysisCache2 = perFileAnalysisCache;
                        boolean bl = false;
                        AnalysisResult analysisResult4 = result2;
                        if (analysisResult4.isError()) {
                            v2 = null;
                        } else {
                            for (KtElement inBlockModification : inBlockModifications) {
                                StackedCompositeBindingContextTrace trace;
                                StackedCompositeBindingContextTrace.StackedCompositeBindingContext stackedCtx;
                                BindingContext resultCtx = analysisResult4.getBindingContext();
                                StackedCompositeBindingContextTrace.StackedCompositeBindingContext stackedCompositeBindingContext = stackedCtx = resultCtx instanceof StackedCompositeBindingContextTrace.StackedCompositeBindingContext ? (StackedCompositeBindingContextTrace.StackedCompositeBindingContext)resultCtx : null;
                                boolean bl2 = stackedCompositeBindingContext != null ? !stackedCompositeBindingContext.isIncrementalAnalysisApplicable() : false;
                                if (bl2) {
                                    v2 = null;
                                    break block16;
                                }
                                if (stackedCtx != null && Intrinsics.areEqual((Object)stackedCtx.element(), (Object)inBlockModification)) {
                                    StackedCompositeBindingContextTrace trace2 = stackedCtx.bindingTrace();
                                    trace2.clear();
                                    v5 = trace2;
                                } else {
                                    StackedCompositeBindingContextTrace.StackedCompositeBindingContext stackedCompositeBindingContext2 = stackedCtx;
                                    int depth2 = (stackedCompositeBindingContext2 != null ? stackedCompositeBindingContext2.depth() : 0) + 1;
                                    BindingContext bindingContext2 = this.resolveSession.getBindingContext();
                                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"resolveSession.bindingContext");
                                    v5 = trace = new StackedCompositeBindingContextTrace(depth2, inBlockModification, bindingContext2, resultCtx);
                                }
                                if (callback2 != null) {
                                    boolean bl3 = false;
                                    Iterable $this$forEach$iv = trace.getParentDiagnosticsApartElement();
                                    boolean $i$f$forEach = false;
                                    for (Object element$iv : $this$forEach$iv) {
                                        DiagnosticSink.DiagnosticsCallback it;
                                        Diagnostic p0 = (Diagnostic)element$iv;
                                        boolean bl4 = false;
                                        it.callback(p0);
                                    }
                                }
                                AnalysisResult newResult = this.analyze(inBlockModification, (BindingTrace)trace, callback2);
                                analysisResult4 = this.wrapResult((AnalysisResult)result2, newResult, trace);
                            }
                            PureKotlinCodeBlockModificationListenerKt.removeInBlockModifications(this.file, inBlockModifications);
                            v2 = analysisResult4;
                        }
                    }
                    v8 = v2;
                    perFileAnalysisCache = perFileAnalysisCache2;
                } else {
                    v8 = null;
                }
                perFileAnalysisCache.fileResult = v8;
            }
            catch (Throwable e) {
                Throwable $this$throwAsInvalidModuleException$iv = e;
                boolean $i$f$throwAsInvalidModuleException = false;
                InvalidModuleException invalidModuleException = PerFileAnalysisCacheKt.access$asInvalidModuleException($this$throwAsInvalidModuleException$iv);
                if (invalidModuleException != null) {
                    InvalidModuleException it$iv = invalidModuleException;
                    boolean bl = false;
                    InvalidModuleException it = it$iv;
                    boolean bl5 = false;
                    this.clearFileResultCache();
                    throw (Throwable)new ProcessCanceledException((Throwable)it);
                }
                if (!(e instanceof ControlFlowException)) {
                    this.clearFileResultCache();
                }
                throw e;
            }
        }
        if (this.fileResult == null) {
            PureKotlinCodeBlockModificationListenerKt.clearInBlockModifications(this.file);
        }
        return this.fileResult;
    }

    private final void updateFileResultFromCache() {
        if (this.fileResult == null && this.cache.containsKey(this.file)) {
            this.fileResult = this.cache.get(this.file);
            this.cache.clear();
        }
    }

    private final AnalysisResult lookUp(KtElement analyzableElement) {
        ArrayList<PsiElement> descendantsOfCurrent = new ArrayList<PsiElement>();
        HashSet toRemove = new HashSet();
        AnalysisResult result2 = null;
        for (PsiElement current : PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)analyzableElement))) {
            AnalysisResult cached2 = this.cache.get(current);
            if (cached2 != null) {
                result2 = cached2;
                toRemove.addAll(descendantsOfCurrent);
                descendantsOfCurrent.clear();
            }
            descendantsOfCurrent.add(current);
        }
        this.cache.keySet().removeAll(toRemove);
        return result2;
    }

    private final AnalysisResult wrapResult(AnalysisResult oldResult, AnalysisResult newResult, StackedCompositeBindingContextTrace elementBindingTrace) {
        AnalysisResult analysisResult2;
        StackedCompositeBindingContextTrace.StackedCompositeBindingContext newBindingCtx = elementBindingTrace.getStackedContext();
        if (oldResult.isError()) {
            Throwable $this$throwAsInvalidModuleException_u24default$iv = oldResult.getError();
            boolean $i$f$throwAsInvalidModuleException = false;
            InvalidModuleException invalidModuleException = PerFileAnalysisCacheKt.access$asInvalidModuleException($this$throwAsInvalidModuleException_u24default$iv);
            if (invalidModuleException != null) {
                InvalidModuleException it$iv = invalidModuleException;
                boolean bl = false;
                InvalidModuleException invalidModuleException2 = it$iv;
                boolean bl2 = false;
                InvalidModuleException it = invalidModuleException2;
                throw (Throwable)it;
            }
            analysisResult2 = AnalysisResult.Companion.internalError((BindingContext)newBindingCtx, oldResult.getError());
        } else if (newResult.isError()) {
            Throwable $this$throwAsInvalidModuleException_u24default$iv = newResult.getError();
            boolean $i$f$throwAsInvalidModuleException = false;
            InvalidModuleException invalidModuleException = PerFileAnalysisCacheKt.access$asInvalidModuleException($this$throwAsInvalidModuleException_u24default$iv);
            if (invalidModuleException != null) {
                InvalidModuleException it$iv = invalidModuleException;
                boolean bl = false;
                InvalidModuleException it = it$iv;
                boolean bl3 = false;
                throw (Throwable)it;
            }
            analysisResult2 = AnalysisResult.Companion.internalError((BindingContext)newBindingCtx, newResult.getError());
        } else {
            analysisResult2 = AnalysisResult.Companion.success((BindingContext)newBindingCtx, oldResult.getModuleDescriptor(), oldResult.getShouldGenerateCode());
        }
        return analysisResult2;
    }

    private final AnalysisResult analyze(KtElement analyzableElement, BindingTrace bindingTrace, DiagnosticSink.DiagnosticsCallback callback2) {
        ProgressIndicatorProvider.checkCanceled();
        Project project2 = analyzableElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"analyzableElement.project");
        Project project3 = project2;
        if (DumbService.Companion.isDumb(project3)) {
            return AnalysisResult.Companion.getEMPTY();
        }
        this.moduleDescriptor.assertValid();
        try {
            return KotlinResolveDataProvider.INSTANCE.analyze(project3, this.globalContext, this.moduleDescriptor, this.resolveSession, this.codeFragmentAnalyzer, this.pluginDeclarationProviderFactory, this.bodyResolveCache, analyzableElement, bindingTrace, callback2);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            Throwable $this$throwAsInvalidModuleException_u24default$iv = e;
            boolean $i$f$throwAsInvalidModuleException = false;
            InvalidModuleException invalidModuleException = PerFileAnalysisCacheKt.access$asInvalidModuleException($this$throwAsInvalidModuleException_u24default$iv);
            if (invalidModuleException != null) {
                InvalidModuleException it$iv = invalidModuleException;
                boolean bl = false;
                InvalidModuleException invalidModuleException2 = it$iv;
                boolean bl2 = false;
                InvalidModuleException it = invalidModuleException2;
                throw (Throwable)it;
            }
            DiagnosticUtils.throwIfRunningOnServer((Throwable)e);
            KotlinCacheServiceImplKt.getLOG().warn(e);
            BindingContext bindingContext2 = BindingContext.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"EMPTY");
            return AnalysisResult.Companion.internalError(bindingContext2, e);
        }
    }

    private final void clearFileResultCache() {
        PureKotlinCodeBlockModificationListenerKt.clearInBlockModifications(this.file);
        this.fileResult = null;
    }

    private static final void guardLock$lambda$0() {
        ProgressIndicatorProvider.checkCanceled();
    }

    private static final AnalysisResult getAnalysisResults$handleResult(AnalysisResult result2, DiagnosticSink.DiagnosticsCallback callback2) {
        block1: {
            DiagnosticSink.DiagnosticsCallback diagnosticsCallback = callback2;
            if (diagnosticsCallback == null) break block1;
            DiagnosticSink.DiagnosticsCallback it = diagnosticsCallback;
            boolean bl = false;
            Diagnostics diagnostics2 = result2.getBindingContext().getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"result.bindingContext.diagnostics");
            Iterable $this$forEach$iv = (Iterable)diagnostics2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Diagnostic p0 = (Diagnostic)element$iv;
                boolean bl2 = false;
                it.callback(p0);
            }
        }
        return result2;
    }
}

