/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.searching.usages.dialogs;

import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.searching.usages.KotlinPropertyFindUsagesOptions;
import org.jetbrains.kotlin.idea.base.searching.usages.dialogs.Utils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class KotlinFindPropertyUsagesDialog
extends JavaFindUsagesDialog<KotlinPropertyFindUsagesOptions> {
    private StateRestoringCheckBox readAccesses;
    private StateRestoringCheckBox writeAccesses;
    private StateRestoringCheckBox searchForBase;
    private StateRestoringCheckBox overrideUsages;
    private StateRestoringCheckBox expectedUsages;
    private StateRestoringCheckBox searchInOverridingMethods;
    private static final boolean disableComponentAndDestructionSearchDefault = false;
    private static final String optionName = "kotlin.disable.search.component.and.destruction";

    public KotlinFindPropertyUsagesDialog(PsiElement element3, Project project2, KotlinPropertyFindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super(element3, project2, (FindUsagesOptions)findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    @NotNull
    protected KotlinPropertyFindUsagesOptions getFindUsagesOptions() {
        KotlinPropertyFindUsagesOptions kotlinPropertyFindUsagesOptions = (KotlinPropertyFindUsagesOptions)this.myFindUsagesOptions;
        if (kotlinPropertyFindUsagesOptions == null) {
            KotlinFindPropertyUsagesDialog.$$$reportNull$$$0(0);
        }
        return kotlinPropertyFindUsagesOptions;
    }

    public JComponent getPreferredFocusedControl() {
        return this.myCbToSkipResultsWhenOneUsage;
    }

    public void calcFindUsagesOptions(KotlinPropertyFindUsagesOptions options2) {
        super.calcFindUsagesOptions((JavaFindUsagesOptions)options2);
        options2.isReadAccess = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.readAccesses);
        options2.isWriteAccess = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.writeAccesses);
        options2.isSearchForBaseAccessors = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.searchForBase);
        options2.isSearchInOverridingMethods = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.searchInOverridingMethods);
        options2.setSearchOverrides(KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.overrideUsages));
        if (this.expectedUsages != null) {
            options2.setSearchExpected(this.expectedUsages.isSelected());
        }
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        KotlinPropertyFindUsagesOptions options2 = this.getFindUsagesOptions();
        this.readAccesses = this.addCheckboxToPanel(KotlinBundle.message("find.declaration.property.readers.checkbox", new Object[0]), options2.isReadAccess, findWhatPanel, true);
        this.writeAccesses = this.addCheckboxToPanel(KotlinBundle.message("find.declaration.property.writers.checkbox", new Object[0]), options2.isWriteAccess, findWhatPanel, true);
        return findWhatPanel;
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        if (coloredComponent == null) {
            KotlinFindPropertyUsagesDialog.$$$reportNull$$$0(1);
        }
        Utils.configureLabelComponent(coloredComponent, (KtNamedDeclaration)this.getPsiElement());
    }

    protected void addUsagesOptions(JPanel optionsPanel) {
        KtClass ktClass2;
        KtClassOrObject ktClassOrObject;
        boolean isOpen;
        KtProperty ktProperty;
        KtClass ktClass3;
        KtClassOrObject ktClassOrObject2;
        super.addUsagesOptions(optionsPanel);
        KtNamedDeclaration property2 = (KtNamedDeclaration)this.getPsiElement();
        if (property2.hasModifier(KtTokens.OVERRIDE_KEYWORD) || property2.hasModifier(KtTokens.OPEN_KEYWORD) || property2 instanceof KtParameter && !((KtParameter)property2).hasValOrVar()) {
            this.searchForBase = this.createCheckbox(JavaBundle.message((String)"find.options.include.accessors.base.checkbox", (Object[])new Object[0]), this.getFindUsagesOptions().isSearchForBaseAccessors, true);
            JPanel decoratedCheckbox = new ComponentPanelBuilder((JComponent)this.searchForBase).withComment(JavaBundle.message((String)"find.options.include.accessors.base.checkbox.comment", (Object[])new Object[0])).createPanel();
            decoratedCheckbox.setAlignmentX(0.0f);
            optionsPanel.add(decoratedCheckbox);
        }
        if (property2 instanceof KtParameter) {
            this.searchInOverridingMethods = this.addCheckboxToPanel(JavaBundle.message((String)"find.options.search.overriding.methods.checkbox", (Object[])new Object[0]), this.getFindUsagesOptions().isSearchInOverridingMethods, optionsPanel, true);
        }
        boolean isContainingClassInterface = (ktClassOrObject2 = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)property2)) instanceof KtClass && (ktClass3 = (KtClass)ktClassOrObject2).isInterface();
        boolean isAbstract = property2.hasModifier(KtTokens.ABSTRACT_KEYWORD) || isContainingClassInterface && property2 instanceof KtProperty && !(ktProperty = (KtProperty)property2).hasInitializer() && !ktProperty.hasDelegate() && ktProperty.getAccessors().isEmpty();
        boolean bl = isOpen = property2.hasModifier(KtTokens.OPEN_KEYWORD) || property2.hasModifier(KtTokens.OVERRIDE_KEYWORD) && !property2.hasModifier(KtTokens.FINAL_KEYWORD) && (isContainingClassInterface || (ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)property2)) instanceof KtClass && (ktClass2 = (KtClass)ktClassOrObject).hasModifier(KtTokens.OPEN_KEYWORD));
        if (isOpen || isAbstract) {
            this.overrideUsages = this.addCheckboxToPanel(isAbstract ? KotlinBundle.message("find.declaration.implementing.properties.checkbox", new Object[0]) : KotlinBundle.message("find.declaration.overriding.properties.checkbox", new Object[0]), FindSettings.getInstance().isSearchOverloadedMethods(), optionsPanel, false);
        }
        boolean isActual = PsiUtilsKt.hasActualModifier((KtModifierListOwner)property2);
        KotlinPropertyFindUsagesOptions options2 = this.getFindUsagesOptions();
        if (isActual) {
            this.expectedUsages = this.addCheckboxToPanel(KotlinBundle.message("find.usages.checkbox.name.expected.properties", new Object[0]), options2.getSearchExpected(), optionsPanel, false);
        }
        if (KotlinFindPropertyUsagesDialog.isDataClassConstructorProperty(property2)) {
            JCheckBox dataClassComponentCheckBox = new JCheckBox(KotlinBundle.message("find.usages.checkbox.text.fast.data.class.component.search", new Object[0]));
            dataClassComponentCheckBox.setToolTipText(KotlinBundle.message("find.usages.tool.tip.text.disable.search.for.data.class.components.and.destruction.declarations.project.wide.setting", new Object[0]));
            Project project2 = property2.getProject();
            dataClassComponentCheckBox.setSelected(KotlinFindPropertyUsagesDialog.getDisableComponentAndDestructionSearch(project2));
            optionsPanel.add(dataClassComponentCheckBox);
            dataClassComponentCheckBox.addActionListener(___ -> KotlinFindPropertyUsagesDialog.setDisableComponentAndDestructionSearch(project2, dataClassComponentCheckBox.isSelected()));
        }
    }

    protected void update() {
        this.setOKActionEnabled(KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.readAccesses) || KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.writeAccesses));
    }

    public static boolean getDisableComponentAndDestructionSearch(Project project2) {
        return PropertiesComponent.getInstance((Project)project2).getBoolean(optionName, false);
    }

    public static void setDisableComponentAndDestructionSearch(Project project2, boolean value2) {
        PropertiesComponent.getInstance((Project)project2).setValue(optionName, value2, false);
    }

    private static boolean isDataClassConstructorProperty(KtNamedDeclaration declaration2) {
        PsiElement parent2;
        if (declaration2 instanceof KtParameter && (parent2 = declaration2.getParent()) instanceof KtParameterList && (parent2 = parent2.getParent()) instanceof KtPrimaryConstructor && (parent2 = parent2.getParent()) instanceof KtClass) {
            return ((KtClass)parent2).isData();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/base/searching/usages/dialogs/KotlinFindPropertyUsagesDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/base/searching/usages/dialogs/KotlinFindPropertyUsagesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureLabelComponent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1 -> new IllegalArgumentException(string2);
        };
    }
}

