/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirIntersectionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRefWithNullability;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a-\u0010+\u001a\u0004\u0018\u0001H,\"\n\b\u0000\u0010,\u0018\u0001*\u00020\u0002*\u00020\u0005H\u0086\b\u0082\u0002\n\n\b\b\u0002\u001a\u0004\u0010\u0000(\u0000\u00a2\u0006\u0002\u0010\t\u001a\u001e\u0010.\u001a\u0002H,\"\n\b\u0000\u0010,\u0018\u0001*\u00020\u0002*\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010\t\u001a\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001100*\b\u0012\u0004\u0012\u00020\u001100\u001a\f\u00101\u001a\u00020\u0001*\u000202H\u0002\u001a\u001c\u00103\u001a\u00020\u0001*\u00020\u00052\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0001H\u0002\u001a\u0014\u00107\u001a\u00020\u0001*\u00020\u00112\u0006\u00104\u001a\u000205H\u0002\u001a\u001b\u00108\u001a\u00020\u0001*\u00020\u001b\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0001\u001a\n\u0010:\u001a\u00020;*\u00020<\u001a\u0010\u0010=\u001a\b\u0012\u0002\b\u0003\u0018\u00010>*\u00020?\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0002*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u0002*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\"\u0015\u0010\r\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006\"\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\"\u0015\u0010\u000f\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006\"\u0015\u0010\u0010\u001a\u00020\u0001*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006\"\u0015\u0010\u0014\u001a\u00020\u0001*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\"\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0015\u0010\u0019\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006\"\u0015\u0010\u001a\u001a\u00020\u0001*\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\"\u0015\u0010\u001d\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0006\"\u0015\u0010\u001e\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0006\"\u0015\u0010\u001f\u001a\u00020\u0001*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0016\"\u0015\u0010 \u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006\"\u0015\u0010!\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0006\"\u001a\u0010\"\u001a\u0004\u0018\u00010#*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"\u0015\u0010&\u001a\u00020'*\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00f2\u0001\b\n\u00020-\n\u000209\u00a8\u0006@"}, d2={"canBeNull", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getCanBeNull", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Z", "coneType", "getConeType", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "coneTypeOrNull", "getConeTypeOrNull", "isAny", "isArrayType", "isBoolean", "isEnum", "isExtensionFunctionAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)Z", "isInt", "isLeftValidForDefinitelyNotNullable", "Lorg/jetbrains/kotlin/fir/types/FirIntersectionTypeRef;", "(Lorg/jetbrains/kotlin/fir/types/FirIntersectionTypeRef;)Z", "isMarkedNullable", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Ljava/lang/Boolean;", "isNothing", "isNullLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "isNullableAny", "isNullableNothing", "isRightValidForDefinitelyNotNullable", "isString", "isUnit", "lookupTagBasedOrNull", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "getLookupTagBasedOrNull", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "parametersCount", "", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "getParametersCount", "(Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;)I", "coneTypeSafe", "T", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "coneTypeUnsafe", "dropExtensionFunctionAnnotation", "", "hasNotNullUpperBound", "Lorg/jetbrains/kotlin/fir/types/ConeTypeParameterType;", "isBuiltinType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "isNullable", "isOfType", "isStableSmartcast", "Lorg/jetbrains/kotlin/fir/expressions/FirSmartCastExpression;", "toConeTypeProjection", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "toConstKind", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "tree"})
@SourceDebugExtension(value={"SMAP\nFirTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n24#1,4:158\n24#1,4:162\n1747#2,3:166\n1747#2,3:169\n819#2:172\n847#2,2:173\n1747#2,3:175\n1726#2,3:178\n1726#2,3:181\n1#3:184\n*S KotlinDebug\n*F\n+ 1 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n31#1:158,4\n35#1:162,4\n49#1:166,3\n50#1:169,3\n99#1:172\n99#1:173,2\n126#1:175,3\n147#1:178,3\n148#1:181,3\n*E\n"})
public final class FirTypeUtilsKt {
    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeUnsafe(FirTypeRef $this$coneTypeUnsafe) {
        Intrinsics.checkNotNullParameter((Object)$this$coneTypeUnsafe, (String)"<this>");
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe).getType();
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)coneKotlinType;
    }

    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeSafe(FirTypeRef $this$coneTypeSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$coneTypeSafe, (String)"<this>");
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType getConeType(@NotNull FirTypeRef $this$coneType) {
        Intrinsics.checkNotNullParameter((Object)$this$coneType, (String)"<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$coneType;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        if (coneKotlinType == null) {
            throw new IllegalStateException(("Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType.getClass()).getSimpleName() + ' ' + UtilsKt.render($this$coneType)).toString());
        }
        return coneKotlinType;
    }

    @Nullable
    public static final ConeKotlinType getConeTypeOrNull(@NotNull FirTypeRef $this$coneTypeOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$coneTypeOrNull, (String)"<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$coneTypeOrNull;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    public static final boolean isAny(@NotNull FirTypeRef $this$isAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isAny, (String)"<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isAny, StandardClassIds.INSTANCE.getAny(), false);
    }

    public static final boolean isNullableAny(@NotNull FirTypeRef $this$isNullableAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableAny, (String)"<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isNullableAny, StandardClassIds.INSTANCE.getAny(), true);
    }

    public static final boolean isNothing(@NotNull FirTypeRef $this$isNothing) {
        Intrinsics.checkNotNullParameter((Object)$this$isNothing, (String)"<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isNothing, StandardClassIds.INSTANCE.getNothing(), false);
    }

    public static final boolean isNullableNothing(@NotNull FirTypeRef $this$isNullableNothing) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableNothing, (String)"<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isNullableNothing, StandardClassIds.INSTANCE.getNothing(), true);
    }

    public static final boolean isUnit(@NotNull FirTypeRef $this$isUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnit, (String)"<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isUnit, StandardClassIds.INSTANCE.getUnit(), false);
    }

    public static final boolean isBoolean(@NotNull FirTypeRef $this$isBoolean) {
        Intrinsics.checkNotNullParameter((Object)$this$isBoolean, (String)"<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isBoolean, StandardClassIds.INSTANCE.getBoolean(), false);
    }

    public static final boolean isInt(@NotNull FirTypeRef $this$isInt) {
        Intrinsics.checkNotNullParameter((Object)$this$isInt, (String)"<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isInt, StandardClassIds.INSTANCE.getInt(), false);
    }

    public static final boolean isString(@NotNull FirTypeRef $this$isString) {
        Intrinsics.checkNotNullParameter((Object)$this$isString, (String)"<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isString, StandardClassIds.INSTANCE.getString(), false);
    }

    public static final boolean isEnum(@NotNull FirTypeRef $this$isEnum) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnum, (String)"<this>");
        return FirTypeUtilsKt.isBuiltinType($this$isEnum, StandardClassIds.INSTANCE.getEnum(), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isArrayType(@NotNull FirTypeRef $this$isArrayType) {
        ClassId it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isArrayType, (String)"<this>");
        if (FirTypeUtilsKt.isBuiltinType($this$isArrayType, StandardClassIds.INSTANCE.getArray(), false)) return true;
        Iterable $this$any$iv = StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (ClassId)element$iv;
                boolean bl2 = false;
                if (!FirTypeUtilsKt.isBuiltinType($this$isArrayType, it, false)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = StandardClassIds.INSTANCE.getUnsignedArrayTypeByElementType().values();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (ClassId)element$iv;
            boolean bl3 = false;
        } while (!FirTypeUtilsKt.isBuiltinType($this$isArrayType, it, false));
        return true;
    }

    public static final boolean isNullLiteral(@NotNull FirExpression $this$isNullLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullLiteral, (String)"<this>");
        return $this$isNullLiteral instanceof FirConstExpression && Intrinsics.areEqual(((FirConstExpression)$this$isNullLiteral).getKind(), (Object)ConstantValueKind.Null.INSTANCE) && ((FirConstExpression)$this$isNullLiteral).getValue() == null && $this$isNullLiteral.getSource() != null;
    }

    public static final boolean isStableSmartcast(@NotNull FirExpression $this$isStableSmartcast) {
        Intrinsics.checkNotNullParameter((Object)$this$isStableSmartcast, (String)"<this>");
        return $this$isStableSmartcast instanceof FirSmartCastExpression && ((FirSmartCastExpression)$this$isStableSmartcast).isStable();
    }

    private static final ConeLookupTagBasedType getLookupTagBasedOrNull(FirTypeRef $this$lookupTagBasedOrNull) {
        ConeKotlinType coneKotlinType;
        FirTypeRef firTypeRef = $this$lookupTagBasedOrNull;
        ConeLookupTagBasedType coneLookupTagBasedType = firTypeRef instanceof FirImplicitBuiltinTypeRef ? (ConeLookupTagBasedType)((FirImplicitBuiltinTypeRef)$this$lookupTagBasedOrNull).getType() : (firTypeRef instanceof FirResolvedTypeRef ? ((coneKotlinType = ((FirResolvedTypeRef)$this$lookupTagBasedOrNull).getType()) instanceof ConeLookupTagBasedType ? (ConeLookupTagBasedType)coneKotlinType : null) : null);
        return coneLookupTagBasedType;
    }

    private static final boolean isBuiltinType(FirTypeRef $this$isBuiltinType, ClassId classId, boolean isNullable) {
        ConeLookupTagBasedType coneLookupTagBasedType = FirTypeUtilsKt.getLookupTagBasedOrNull($this$isBuiltinType);
        if (coneLookupTagBasedType == null) {
            return false;
        }
        ConeLookupTagBasedType type2 = coneLookupTagBasedType;
        Object object = type2 instanceof ConeClassLikeType ? (ConeClassLikeType)type2 : null;
        return Intrinsics.areEqual((Object)(object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null), (Object)classId) && ConeTypeUtilsKt.isNullable(type2) == isNullable;
    }

    @Nullable
    public static final Boolean isMarkedNullable(@NotNull FirTypeRef $this$isMarkedNullable) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedNullable, (String)"<this>");
        if ($this$isMarkedNullable instanceof FirTypeRefWithNullability) {
            bl = ((FirTypeRefWithNullability)$this$isMarkedNullable).isMarkedNullable();
        } else {
            ConeLookupTagBasedType coneLookupTagBasedType = FirTypeUtilsKt.getLookupTagBasedOrNull($this$isMarkedNullable);
            bl = coneLookupTagBasedType != null ? Boolean.valueOf(ConeTypeUtilsKt.isMarkedNullable(coneLookupTagBasedType)) : null;
        }
        return bl;
    }

    public static final int getParametersCount(@NotNull FirFunctionTypeRef $this$parametersCount) {
        Intrinsics.checkNotNullParameter((Object)$this$parametersCount, (String)"<this>");
        return $this$parametersCount.getReceiverTypeRef() != null ? $this$parametersCount.getParameters().size() + $this$parametersCount.getContextReceiverTypeRefs().size() + 1 : $this$parametersCount.getParameters().size() + $this$parametersCount.getContextReceiverTypeRefs().size();
    }

    private static final boolean isOfType(FirAnnotation $this$isOfType, ClassId classId) {
        boolean bl;
        FirTypeRef firTypeRef = $this$isOfType.getAnnotationTypeRef();
        FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        if (firResolvedTypeRef != null) {
            Boolean bl2;
            FirResolvedTypeRef typeRef = firResolvedTypeRef;
            boolean bl3 = false;
            ConeKotlinType coneKotlinType = typeRef.getType();
            ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
            if (coneClassLikeType != null) {
                ConeClassLikeType it = coneClassLikeType;
                boolean bl4 = false;
                bl2 = Intrinsics.areEqual((Object)it.getLookupTag().getClassId(), (Object)classId);
            } else {
                bl2 = null;
            }
            bl = Intrinsics.areEqual(bl2, (Object)true);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isExtensionFunctionAnnotationCall(@NotNull FirAnnotation $this$isExtensionFunctionAnnotationCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isExtensionFunctionAnnotationCall, (String)"<this>");
        return FirTypeUtilsKt.isOfType($this$isExtensionFunctionAnnotationCall, StandardClassIds.Annotations.INSTANCE.getExtensionFunctionType());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnnotation> dropExtensionFunctionAnnotation(@NotNull List<? extends FirAnnotation> $this$dropExtensionFunctionAnnotation) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$dropExtensionFunctionAnnotation, (String)"<this>");
        Iterable $this$filterNot$iv = $this$dropExtensionFunctionAnnotation;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirAnnotation it = (FirAnnotation)element$iv$iv;
            boolean bl = false;
            if (FirTypeUtilsKt.isExtensionFunctionAnnotationCall(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ConstantValueKind<?> toConstKind(@NotNull ConeClassLikeType $this$toConstKind) {
        Intrinsics.checkNotNullParameter((Object)$this$toConstKind, (String)"<this>");
        ClassId classId = $this$toConstKind.getLookupTag().getClassId();
        return Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getByte()) ? (ConstantValueKind)ConstantValueKind.Byte.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getShort()) ? (ConstantValueKind)ConstantValueKind.Short.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getInt()) ? (ConstantValueKind)ConstantValueKind.Int.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getLong()) ? (ConstantValueKind)ConstantValueKind.Long.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getUInt()) ? (ConstantValueKind)ConstantValueKind.UnsignedInt.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getULong()) ? (ConstantValueKind)ConstantValueKind.UnsignedLong.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getUShort()) ? (ConstantValueKind)ConstantValueKind.UnsignedShort.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getUByte()) ? (ConstantValueKind)ConstantValueKind.UnsignedByte.INSTANCE : null)))))));
    }

    @NotNull
    public static final ConeTypeProjection toConeTypeProjection(@NotNull FirTypeProjection $this$toConeTypeProjection) {
        ConeTypeProjection coneTypeProjection;
        Intrinsics.checkNotNullParameter((Object)$this$toConeTypeProjection, (String)"<this>");
        FirTypeProjection firTypeProjection = $this$toConeTypeProjection;
        if (firTypeProjection instanceof FirStarProjection) {
            coneTypeProjection = ConeStarProjection.INSTANCE;
        } else if (firTypeProjection instanceof FirTypeProjectionWithVariance) {
            ConeKotlinType type2 = FirTypeUtilsKt.getConeType(((FirTypeProjectionWithVariance)$this$toConeTypeProjection).getTypeRef());
            coneTypeProjection = ConeTypeUtilsKt.toTypeProjection(type2, ((FirTypeProjectionWithVariance)$this$toConeTypeProjection).getVariance());
        } else {
            throw new IllegalStateException("!".toString());
        }
        return coneTypeProjection;
    }

    private static final boolean hasNotNullUpperBound(ConeTypeParameterType $this$hasNotNullUpperBound) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasNotNullUpperBound.getLookupTag().getTypeParameterSymbol().getResolvedBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                    boolean bl2 = false;
                    ConeKotlinType boundType = FirTypeUtilsKt.getConeType(it);
                    boolean bl3 = boundType instanceof ConeTypeParameterType ? FirTypeUtilsKt.hasNotNullUpperBound((ConeTypeParameterType)boundType) : boundType.getNullability() == ConeNullability.NOT_NULL;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean getCanBeNull(@NotNull FirTypeRef $this$canBeNull) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeNull, (String)"<this>");
        return FirTypeUtilsKt.getCanBeNull(FirTypeUtilsKt.getConeType($this$canBeNull));
    }

    public static final boolean getCanBeNull(@NotNull ConeKotlinType $this$canBeNull) {
        boolean bl;
        block15: {
            Intrinsics.checkNotNullParameter((Object)$this$canBeNull, (String)"<this>");
            if (ConeTypeUtilsKt.isMarkedNullable($this$canBeNull)) {
                return true;
            }
            ConeKotlinType coneKotlinType = $this$canBeNull;
            if (coneKotlinType instanceof ConeFlexibleType) {
                bl = FirTypeUtilsKt.getCanBeNull(((ConeFlexibleType)$this$canBeNull).getUpperBound());
            } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                bl = false;
            } else if (coneKotlinType instanceof ConeTypeParameterType) {
                Iterable $this$all$iv = ((ConeTypeParameterType)$this$canBeNull).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                        boolean bl2 = false;
                        if (FirTypeUtilsKt.getCanBeNull(FirTypeUtilsKt.getConeType(it))) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            } else if (coneKotlinType instanceof ConeIntersectionType) {
                Iterable $this$all$iv = ((ConeIntersectionType)$this$canBeNull).getIntersectedTypes();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl3 = false;
                        if (FirTypeUtilsKt.getCanBeNull(it)) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            } else {
                bl = ConeTypeUtilsKt.isNullable($this$canBeNull);
            }
        }
        return bl;
    }

    public static final boolean isLeftValidForDefinitelyNotNullable(@NotNull FirIntersectionTypeRef $this$isLeftValidForDefinitelyNotNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isLeftValidForDefinitelyNotNullable, (String)"<this>");
        ConeKotlinType it = FirTypeUtilsKt.getConeType($this$isLeftValidForDefinitelyNotNullable.getLeftType());
        boolean bl = false;
        return it instanceof ConeTypeParameterType && FirTypeUtilsKt.getCanBeNull(it) && !ConeTypeUtilsKt.isMarkedNullable(it);
    }

    public static final boolean isRightValidForDefinitelyNotNullable(@NotNull FirIntersectionTypeRef $this$isRightValidForDefinitelyNotNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isRightValidForDefinitelyNotNullable, (String)"<this>");
        return ConeBuiltinTypeUtilsKt.isAny(FirTypeUtilsKt.getConeType($this$isRightValidForDefinitelyNotNullable.getRightType()));
    }
}

