/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeIdentifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "invalidChars", "", "", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkNameAndReport", "name", "Lorg/jetbrains/kotlin/name/Name;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeIdentifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeIdentifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeIdentifierChecker\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,55:1\n1083#2,2:56\n*S KotlinDebug\n*F\n+ 1 FirNativeIdentifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeIdentifierChecker\n*L\n45#1:56,2\n*E\n"})
public final class FirNativeIdentifierChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirNativeIdentifierChecker INSTANCE = new FirNativeIdentifierChecker();
    @NotNull
    private static final Set<Character> invalidChars;

    private FirNativeIdentifierChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement source = declaration2.getSource();
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirRegularClass) {
            this.checkNameAndReport(((FirRegularClass)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirSimpleFunction) {
            this.checkNameAndReport(((FirSimpleFunction)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirTypeParameter) {
            this.checkNameAndReport(((FirTypeParameter)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkNameAndReport(((FirProperty)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirTypeAlias) {
            this.checkNameAndReport(((FirTypeAlias)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirValueParameter) {
            this.checkNameAndReport(((FirValueParameter)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirEnumEntry) {
            this.checkNameAndReport(((FirEnumEntry)declaration2).getName(), source, context2, reporter);
        } else {
            return;
        }
    }

    private final void checkNameAndReport(Name name2, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        if (source != null && !(source.getKind() instanceof KtFakeSourceElementKind) && !name2.isSpecial()) {
            String message2;
            String string2;
            String string3 = name2.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            String text2 = string3;
            if (((CharSequence)text2).length() == 0) {
                string2 = "should not be empty";
            } else {
                boolean bl;
                block5: {
                    CharSequence $this$any$iv = text2;
                    boolean $i$f$any = false;
                    for (int j = 0; j < $this$any$iv.length(); ++j) {
                        char element$iv;
                        char it = element$iv = $this$any$iv.charAt(j);
                        boolean bl2 = false;
                        if (!invalidChars.contains(Character.valueOf(it))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                string2 = message2 = bl ? "contains illegal characters: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)invalidChars, (Iterable)StringsKt.toSet((CharSequence)text2)), (CharSequence)"", (CharSequence)"\"", (CharSequence)"\"", (int)0, null, null, (int)56, null) : null;
            }
            if (message2 != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirNativeErrors.INSTANCE.getINVALID_CHARACTERS_NATIVE(), (Object)message2, (DiagnosticContext)context2, null, (int)16, null);
            }
        }
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf(','), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('|'), Character.valueOf('\u00a7'), Character.valueOf('%'), Character.valueOf('@')};
        invalidChars = SetsKt.setOf((Object[])objectArray);
    }
}

