/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantNullableChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class RedundantNullableChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final RedundantNullableChecker INSTANCE = new RedundantNullableChecker();

    private RedundantNullableChecker() {
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(typeRef instanceof FirResolvedTypeRef) || !Intrinsics.areEqual((Object)FirTypeUtilsKt.isMarkedNullable(typeRef), (Object)true)) {
            return;
        }
        FirClassLikeSymbol<?> symbol2 = FirHelpersKt.toClassLikeSymbol(typeRef, context2.getSession());
        if (symbol2 instanceof FirTypeAliasSymbol) {
            while (symbol2 instanceof FirTypeAliasSymbol) {
                FirResolvedTypeRef resolvedExpandedTypeRef = ((FirTypeAliasSymbol)symbol2).getResolvedExpandedTypeRef();
                if (ConeTypeUtilsKt.isMarkedNullable(resolvedExpandedTypeRef.getType())) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)typeRef.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getREDUNDANT_NULLABLE(), (DiagnosticContext)context2, null, (int)8, null);
                    break;
                }
                symbol2 = FirHelpersKt.toClassLikeSymbol(resolvedExpandedTypeRef, context2.getSession());
            }
        } else {
            SourceNavigator $this$check_u24lambda_u240 = SourceNavigator.Companion.forElement(typeRef);
            boolean bl = false;
            if ($this$check_u24lambda_u240.isRedundantNullable(typeRef)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)typeRef.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getREDUNDANT_NULLABLE(), (DiagnosticContext)context2, null, (int)8, null);
            }
        }
    }
}

