/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponent;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationInspector;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationPresenter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDefaultDeclarationPresenter;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirNameConflictsTracker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005JH\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00172\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010!\u001a\u0004\u0018\u00010\r2\b\u0010\"\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020$H\u0002J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u001e\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050)H\u0002J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J&\u0010+\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020-J\u0018\u0010.\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J/\u0010/\u001a\u00020\u001b*\u0002002!\u00101\u001a\u001d\u0012\u0013\u0012\u001103\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(6\u0012\u0004\u0012\u00020\u001b02H\u0002J\u0016\u00107\u001a\u0004\u0018\u00010\r*\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0005H\u0002RA\u0010\u0003\u001a2\u0012\u0004\u0012\u00020\u0005\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u0004j\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationInspector;", "", "()V", "declarationConflictingSymbols", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/utils/SmartSet;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lkotlin/collections/HashMap;", "getDeclarationConflictingSymbols", "()Ljava/util/HashMap;", "functionDeclarations", "", "", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "otherDeclarations", "presenter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter;", "areCompatibleMainFunctions", "", "declaration1", "file1", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "declaration2", "file2", "collect", "", "declaration", "collectExternalConflict", "declarationPresentation", "containingFile", "conflictingSymbol", "conflictingPresentation", "conflictingFile", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "collectFunction", "key", "collectLocalConflicts", "conflicting", "", "collectNonFunctionDeclaration", "collectWithExternalConflicts", "packageMemberScope", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope;", "isExpectAndActual", "onConstructors", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "action", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lkotlin/ParameterName;", "name", "ctor", "represent", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationInspector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,323:1\n1#2:324\n1855#3,2:325\n1855#3,2:327\n372#4,7:329\n372#4,7:336\n372#4,7:343\n372#4,7:350\n*S KotlinDebug\n*F\n+ 1 FirConflictsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationInspector\n*L\n129#1:325,2\n151#1:327,2\n175#1:329,7\n183#1:336,7\n199#1:343,7\n254#1:350,7\n*E\n"})
public final class FirDeclarationInspector {
    @NotNull
    private final HashMap<FirDeclaration, SmartSet<FirBasedSymbol<?>>> declarationConflictingSymbols = new HashMap();
    @NotNull
    private final FirDeclarationPresenter presenter = new FirDefaultDeclarationPresenter();
    @NotNull
    private final Map<String, List<FirDeclaration>> otherDeclarations = new LinkedHashMap();
    @NotNull
    private final Map<String, List<FirSimpleFunction>> functionDeclarations = new LinkedHashMap();

    @NotNull
    public final HashMap<FirDeclaration, SmartSet<FirBasedSymbol<?>>> getDeclarationConflictingSymbols() {
        return this.declarationConflictingSymbols;
    }

    public final void collect(@NotNull FirDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (FirConflictsHelpersKt.access$isCollectable(declaration2)) {
            if (declaration2 instanceof FirSimpleFunction) {
                this.collectFunction(this.presenter.represent((FirSimpleFunction)declaration2), (FirSimpleFunction)declaration2);
            } else if (declaration2 instanceof FirRegularClass) {
                this.collectNonFunctionDeclaration(this.presenter.represent((FirRegularClass)declaration2), declaration2);
            } else if (declaration2 instanceof FirTypeAlias) {
                this.collectNonFunctionDeclaration(this.presenter.represent((FirTypeAlias)declaration2), declaration2);
            } else if (declaration2 instanceof FirVariable) {
                this.collectNonFunctionDeclaration(this.presenter.represent((FirVariable)declaration2), declaration2);
            }
        }
    }

    public final void collectWithExternalConflicts(@NotNull FirDeclaration declaration2, @NotNull FirFile containingFile, @NotNull FirSession session, @NotNull FirPackageMemberScope packageMemberScope) {
        block19: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
            Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
            Intrinsics.checkNotNullParameter((Object)packageMemberScope, (String)"packageMemberScope");
            this.collect(declaration2);
            Ref.ObjectRef declarationName2 = new Ref.ObjectRef();
            String string2 = this.represent(this.presenter, declaration2);
            if (string2 == null) {
                return;
            }
            String declarationPresentation = string2;
            FirDeclaration firDeclaration = declaration2;
            if (firDeclaration instanceof FirSimpleFunction) {
                declarationName2.element = ((FirSimpleFunction)declaration2).getName();
                if (!((Name)declarationName2.element).isSpecial()) {
                    packageMemberScope.processFunctionsByName((Name)declarationName2.element, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(this, declaration2, declarationPresentation, containingFile, session){
                        final /* synthetic */ FirDeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ String $declarationPresentation;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$declarationPresentation = $declarationPresentation;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(1);
                        }

                        public final void invoke(@NotNull FirNamedFunctionSymbol it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            FirDeclarationInspector.access$collectExternalConflict(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, it, null, null, this.$session);
                        }
                    }));
                    packageMemberScope.processClassifiersByNameWithSubstitution((Name)declarationName2.element, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(this, declaration2, declarationPresentation, containingFile, session){
                        final /* synthetic */ FirDeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ String $declarationPresentation;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$declarationPresentation = $declarationPresentation;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(2);
                        }

                        public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor coneSubstitutor) {
                            FirRegularClass classWithSameName;
                            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                            Intrinsics.checkNotNullParameter((Object)coneSubstitutor, (String)"<anonymous parameter 1>");
                            FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)symbol2, FirResolvePhase.STATUS);
                            E e = symbol2.getFir();
                            FirRegularClass firRegularClass = classWithSameName = e instanceof FirRegularClass ? (FirRegularClass)e : null;
                            if (classWithSameName != null) {
                                FirDeclarationInspector.access$onConstructors(this.this$0, classWithSameName, (Function1)new Function1<FirConstructor, Unit>(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, classWithSameName, this.$session){
                                    final /* synthetic */ FirDeclarationInspector this$0;
                                    final /* synthetic */ FirDeclaration $declaration;
                                    final /* synthetic */ String $declarationPresentation;
                                    final /* synthetic */ FirFile $containingFile;
                                    final /* synthetic */ FirRegularClass $classWithSameName;
                                    final /* synthetic */ FirSession $session;
                                    {
                                        this.this$0 = $receiver;
                                        this.$declaration = $declaration;
                                        this.$declarationPresentation = $declarationPresentation;
                                        this.$containingFile = $containingFile;
                                        this.$classWithSameName = $classWithSameName;
                                        this.$session = $session;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull FirConstructor constructor2) {
                                        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
                                        FirDeclarationInspector.access$collectExternalConflict(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, constructor2.getSymbol(), FirDeclarationInspector.access$getPresenter$p(this.this$0).represent(constructor2, this.$classWithSameName), null, this.$session);
                                    }
                                });
                            }
                        }
                    });
                }
            } else if (firDeclaration instanceof FirVariable) {
                declarationName2.element = ((FirVariable)declaration2).getName();
                if (!((Name)declarationName2.element).isSpecial()) {
                    packageMemberScope.processPropertiesByName((Name)declarationName2.element, (Function1)new Function1<FirVariableSymbol<?>, Unit>(this, declaration2, declarationPresentation, containingFile, session){
                        final /* synthetic */ FirDeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ String $declarationPresentation;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$declarationPresentation = $declarationPresentation;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(1);
                        }

                        public final void invoke(@NotNull FirVariableSymbol<?> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            FirDeclarationInspector.access$collectExternalConflict(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, it, null, null, this.$session);
                        }
                    });
                }
            } else if (firDeclaration instanceof FirRegularClass) {
                declarationName2.element = ((FirRegularClass)declaration2).getName();
                if (!((Name)declarationName2.element).isSpecial()) {
                    packageMemberScope.processClassifiersByNameWithSubstitution((Name)declarationName2.element, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(this, declaration2, declarationPresentation, containingFile, session){
                        final /* synthetic */ FirDeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ String $declarationPresentation;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$declarationPresentation = $declarationPresentation;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(2);
                        }

                        public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor coneSubstitutor) {
                            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                            Intrinsics.checkNotNullParameter((Object)coneSubstitutor, (String)"<anonymous parameter 1>");
                            FirDeclarationInspector.access$collectExternalConflict(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, symbol2, null, null, this.$session);
                        }
                    });
                    this.onConstructors((FirRegularClass)declaration2, (Function1<? super FirConstructor, Unit>)((Function1)new Function1<FirConstructor, Unit>(packageMemberScope, (Ref.ObjectRef<Name>)declarationName2, this, declaration2, containingFile, session){
                        final /* synthetic */ FirPackageMemberScope $packageMemberScope;
                        final /* synthetic */ Ref.ObjectRef<Name> $declarationName;
                        final /* synthetic */ FirDeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.$packageMemberScope = $packageMemberScope;
                            this.$declarationName = $declarationName;
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(1);
                        }

                        public final void invoke(@NotNull FirConstructor constructor2) {
                            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
                            Object object = this.$declarationName.element;
                            Intrinsics.checkNotNull((Object)object);
                            this.$packageMemberScope.processFunctionsByName((Name)object, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(this.this$0, constructor2, this.$declaration, this.$containingFile, this.$session){
                                final /* synthetic */ FirDeclarationInspector this$0;
                                final /* synthetic */ FirConstructor $constructor;
                                final /* synthetic */ FirDeclaration $declaration;
                                final /* synthetic */ FirFile $containingFile;
                                final /* synthetic */ FirSession $session;
                                {
                                    this.this$0 = $receiver;
                                    this.$constructor = $constructor;
                                    this.$declaration = $declaration;
                                    this.$containingFile = $containingFile;
                                    this.$session = $session;
                                    super(1);
                                }

                                public final void invoke(@NotNull FirNamedFunctionSymbol it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    FirDeclarationInspector.access$collectExternalConflict(this.this$0, this.$constructor, FirDeclarationInspector.access$getPresenter$p(this.this$0).represent(this.$constructor, (FirRegularClass)this.$declaration), this.$containingFile, it, null, null, this.$session);
                                }
                            }));
                        }
                    }));
                    FirNameConflictsTrackerComponent firNameConflictsTrackerComponent = FirNameConflictsTrackerComponentKt.getNameConflictsTracker(session);
                    if (firNameConflictsTrackerComponent != null) {
                        HashMap<ClassId, Set<FirNameConflictsTracker.ClassifierWithFile>> hashMap;
                        Object it = firNameConflictsTrackerComponent;
                        boolean bl = false;
                        FirNameConflictsTracker firNameConflictsTracker = it instanceof FirNameConflictsTracker ? (FirNameConflictsTracker)it : null;
                        if (firNameConflictsTracker != null && (hashMap = firNameConflictsTracker.getRedeclaredClassifiers()) != null && (it = hashMap.get(((FirRegularClass)declaration2).getSymbol().getClassId())) != null) {
                            Iterable $this$forEach$iv = (Iterable)it;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                FirNameConflictsTracker.ClassifierWithFile it2 = (FirNameConflictsTracker.ClassifierWithFile)element$iv;
                                boolean bl2 = false;
                                this.collectExternalConflict(declaration2, declarationPresentation, containingFile, (FirBasedSymbol)it2.getClassifier(), null, it2.getFile(), session);
                            }
                        }
                    }
                }
            } else if (firDeclaration instanceof FirTypeAlias) {
                declarationName2.element = ((FirTypeAlias)declaration2).getName();
                if (!((Name)declarationName2.element).isSpecial()) {
                    packageMemberScope.processClassifiersByNameWithSubstitution((Name)declarationName2.element, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(this, declaration2, declarationPresentation, containingFile, session){
                        final /* synthetic */ FirDeclarationInspector this$0;
                        final /* synthetic */ FirDeclaration $declaration;
                        final /* synthetic */ String $declarationPresentation;
                        final /* synthetic */ FirFile $containingFile;
                        final /* synthetic */ FirSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$declaration = $declaration;
                            this.$declarationPresentation = $declarationPresentation;
                            this.$containingFile = $containingFile;
                            this.$session = $session;
                            super(2);
                        }

                        public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor coneSubstitutor) {
                            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                            Intrinsics.checkNotNullParameter((Object)coneSubstitutor, (String)"<anonymous parameter 1>");
                            FirDeclarationInspector.access$collectExternalConflict(this.this$0, this.$declaration, this.$declarationPresentation, this.$containingFile, symbol2, null, null, this.$session);
                        }
                    });
                    FirNameConflictsTrackerComponent firNameConflictsTrackerComponent = FirNameConflictsTrackerComponentKt.getNameConflictsTracker(session);
                    if (firNameConflictsTrackerComponent != null) {
                        Set<FirNameConflictsTracker.ClassifierWithFile> set2;
                        HashMap<ClassId, Set<FirNameConflictsTracker.ClassifierWithFile>> hashMap;
                        FirNameConflictsTrackerComponent it = firNameConflictsTrackerComponent;
                        boolean bl = false;
                        FirNameConflictsTracker firNameConflictsTracker = it instanceof FirNameConflictsTracker ? (FirNameConflictsTracker)it : null;
                        if (firNameConflictsTracker != null && (hashMap = firNameConflictsTracker.getRedeclaredClassifiers()) != null && (set2 = hashMap.get(((FirTypeAlias)declaration2).getSymbol().getClassId())) != null) {
                            Iterable $this$forEach$iv = set2;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                FirNameConflictsTracker.ClassifierWithFile it3 = (FirNameConflictsTracker.ClassifierWithFile)element$iv;
                                boolean bl3 = false;
                                this.collectExternalConflict(declaration2, declarationPresentation, containingFile, (FirBasedSymbol)it3.getClassifier(), null, it3.getFile(), session);
                            }
                        }
                    }
                }
            }
            if (declarationName2.element == null) break block19;
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(session);
            if (firLookupTrackerComponent != null) {
                Name name2 = (Name)declarationName2.element;
                String string3 = UtilsKt.getPackageFqName(containingFile).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                firLookupTrackerComponent.recordLookup(name2, string3, declaration2.getSource(), containingFile.getSource());
            }
        }
    }

    private final List<FirDeclaration> collectNonFunctionDeclaration(String key, FirDeclaration declaration2) {
        List list2;
        List list3;
        Map<String, List<FirDeclaration>> $this$getOrPut$iv = this.otherDeclarations;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key, answer$iv);
            list3 = answer$iv;
        } else {
            list3 = value$iv;
        }
        List it = list2 = list3;
        boolean bl = false;
        it.add((FirDeclaration)declaration2);
        this.collectLocalConflicts(declaration2, it);
        return list2;
    }

    private final List<FirSimpleFunction> collectFunction(String key, FirSimpleFunction declaration2) {
        List list2;
        List list3;
        Map<String, List<FirSimpleFunction>> $this$getOrPut$iv = this.functionDeclarations;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key, answer$iv);
            list3 = answer$iv;
        } else {
            list3 = value$iv;
        }
        List it = list2 = list3;
        boolean bl = false;
        it.add((FirSimpleFunction)declaration2);
        this.collectLocalConflicts(declaration2, it);
        return list2;
    }

    private final void collectLocalConflicts(FirDeclaration declaration2, List<? extends FirDeclaration> conflicting) {
        SmartSet localConflicts = SmartSet.Companion.create();
        for (FirDeclaration firDeclaration : conflicting) {
            Object object;
            if (firDeclaration instanceof FirField) {
                KtSourceElement ktSourceElement = firDeclaration.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ClassDelegationField.INSTANCE)) continue;
            }
            if (Intrinsics.areEqual((Object)firDeclaration, (Object)declaration2) || this.isExpectAndActual(declaration2, firDeclaration)) continue;
            localConflicts.add(firDeclaration.getSymbol());
            Map $this$getOrPut$iv = this.declarationConflictingSymbols;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(firDeclaration);
            if (value$iv == null) {
                boolean bl = false;
                SmartSet answer$iv = SmartSet.Companion.create();
                $this$getOrPut$iv.put(firDeclaration, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((SmartSet)object).add(declaration2.getSymbol());
        }
        ((Map)this.declarationConflictingSymbols).put(declaration2, localConflicts);
    }

    private final boolean isExpectAndActual(FirDeclaration declaration1, FirDeclaration declaration2) {
        if (!(declaration1 instanceof FirMemberDeclaration)) {
            return false;
        }
        if (!(declaration2 instanceof FirMemberDeclaration)) {
            return false;
        }
        return ((FirMemberDeclaration)declaration1).getStatus().isExpect() && ((FirMemberDeclaration)declaration2).getStatus().isActual() || ((FirMemberDeclaration)declaration1).getStatus().isActual() && ((FirMemberDeclaration)declaration2).getStatus().isExpect();
    }

    private final boolean areCompatibleMainFunctions(FirDeclaration declaration1, FirFile file1, FirDeclaration declaration2, FirFile file2) {
        if (!(declaration1 instanceof FirSimpleFunction) || !(declaration2 instanceof FirSimpleFunction)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((FirSimpleFunction)declaration1).getName().asString(), (Object)"main") || !Intrinsics.areEqual((Object)((FirSimpleFunction)declaration2).getName().asString(), (Object)"main")) {
            return false;
        }
        return !Intrinsics.areEqual((Object)file1, (Object)file2);
    }

    private final void collectExternalConflict(FirDeclaration declaration2, String declarationPresentation, FirFile containingFile, FirBasedSymbol<?> conflictingSymbol, String conflictingPresentation, FirFile conflictingFile, FirSession session) {
        Object object;
        boolean conflictingIsLowPriority;
        FirFile actualConflictingFile;
        String actualConflictingPresentation;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(conflictingSymbol, FirResolvePhase.STATUS);
        Object conflicting = conflictingSymbol.getFir();
        if (Intrinsics.areEqual(conflicting, (Object)declaration2) || !Intrinsics.areEqual((Object)declaration2.getModuleData(), (Object)((FirDeclaration)conflicting).getModuleData())) {
            return;
        }
        String string2 = conflictingPresentation;
        if (string2 == null) {
            string2 = this.represent(this.presenter, (FirDeclaration)conflicting);
        }
        if (!Intrinsics.areEqual((Object)(actualConflictingPresentation = string2), (Object)declarationPresentation)) {
            return;
        }
        FirFile firFile = conflictingFile;
        if (firFile == null) {
            FirBasedSymbol<?> firBasedSymbol = conflictingSymbol;
            firFile = firBasedSymbol instanceof FirClassLikeSymbol ? FirProviderKt.getFirProvider(session).getFirClassifierContainerFileIfAny((FirClassLikeSymbol)conflictingSymbol) : (firBasedSymbol instanceof FirCallableSymbol ? FirProviderKt.getFirProvider(session).getFirCallableContainerFile((FirCallableSymbol)conflictingSymbol) : null);
        }
        if (Intrinsics.areEqual((Object)containingFile, (Object)(actualConflictingFile = firFile)) && Intrinsics.areEqual((Object)((FirDeclaration)conflicting).getOrigin(), (Object)FirDeclarationOrigin.Precompiled.INSTANCE)) {
            return;
        }
        if (this.areCompatibleMainFunctions(declaration2, containingFile, (FirDeclaration)conflicting, actualConflictingFile)) {
            return;
        }
        if (this.isExpectAndActual(declaration2, (FirDeclaration)conflicting)) {
            return;
        }
        if (conflicting instanceof FirMemberDeclaration && !FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(session), (FirMemberDeclaration)conflicting, session, containingFile, CollectionsKt.emptyList(), null, false, null, false, null, 480, null)) {
            return;
        }
        boolean declarationIsLowPriority = FirAnnotationUtilsKt.hasLowPriorityAnnotation(declaration2.getAnnotations());
        if (declarationIsLowPriority != (conflictingIsLowPriority = FirAnnotationUtilsKt.hasLowPriorityAnnotation(((FirDeclaration)conflicting).getAnnotations()))) {
            return;
        }
        Map $this$getOrPut$iv = this.declarationConflictingSymbols;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration2);
        if (value$iv == null) {
            boolean bl = false;
            SmartSet answer$iv = SmartSet.Companion.create();
            $this$getOrPut$iv.put(declaration2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((SmartSet)object).add(conflictingSymbol);
    }

    private final String represent(FirDeclarationPresenter $this$represent, FirDeclaration declaration2) {
        FirDeclaration firDeclaration = declaration2;
        return firDeclaration instanceof FirSimpleFunction ? $this$represent.represent((FirSimpleFunction)declaration2) : (firDeclaration instanceof FirRegularClass ? $this$represent.represent((FirRegularClass)declaration2) : (firDeclaration instanceof FirTypeAlias ? $this$represent.represent((FirTypeAlias)declaration2) : (firDeclaration instanceof FirProperty ? $this$represent.represent((FirVariable)declaration2) : null)));
    }

    private final void onConstructors(FirRegularClass $this$onConstructors, Function1<? super FirConstructor, Unit> action2) {
        if ($this$onConstructors.getClassKind() != ClassKind.OBJECT && $this$onConstructors.getClassKind() != ClassKind.ENUM_ENTRY) {
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000A\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"org/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationInspector$onConstructors$ClassConstructorVisitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "(Lkotlin/jvm/functions/Function1;)V", "visitConstructor", "", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitDeclarationStatus", "declarationStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkers"})
            public final class ClassConstructorVisitor
            extends FirVisitorVoid {
                final /* synthetic */ Function1<FirConstructor, Unit> $action;

                public ClassConstructorVisitor(@NotNull Function1<? super FirConstructor, Unit> $action) {
                    Intrinsics.checkNotNullParameter($action, (String)"$action");
                    this.$action = $action;
                }

                public void visitElement(@NotNull FirElement element3) {
                    Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                }

                public void visitConstructor(@NotNull FirConstructor constructor2) {
                    Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
                    this.$action.invoke((Object)constructor2);
                }

                public void visitDeclarationStatus(@NotNull FirDeclarationStatus declarationStatus) {
                    Intrinsics.checkNotNullParameter((Object)declarationStatus, (String)"declarationStatus");
                }

                public void visitRegularClass(@NotNull FirRegularClass regularClass) {
                    Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
                }

                public void visitProperty(@NotNull FirProperty property2) {
                    Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                }

                public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
                    Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
                }
            }
            $this$onConstructors.acceptChildren(new ClassConstructorVisitor(action2));
        }
    }

    public static final /* synthetic */ void access$collectExternalConflict(FirDeclarationInspector $this, FirDeclaration declaration2, String declarationPresentation, FirFile containingFile, FirBasedSymbol conflictingSymbol, String conflictingPresentation, FirFile conflictingFile, FirSession session) {
        $this.collectExternalConflict(declaration2, declarationPresentation, containingFile, conflictingSymbol, conflictingPresentation, conflictingFile, session);
    }

    public static final /* synthetic */ void access$onConstructors(FirDeclarationInspector $this, FirRegularClass $receiver, Function1 action2) {
        $this.onConstructors($receiver, (Function1<? super FirConstructor, Unit>)action2);
    }

    public static final /* synthetic */ FirDeclarationPresenter access$getPresenter$p(FirDeclarationInspector $this) {
        return $this.presenter;
    }
}

