/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/DiagnosticsCollector;", "", "fileStructureCache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureCache;", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureCache;)V", "collectDiagnosticsForFile", "", "Lorg/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "filter", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "getDiagnosticsFor", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "low-level-api-fir"})
public final class DiagnosticsCollector {
    @NotNull
    private final FileStructureCache fileStructureCache;

    public DiagnosticsCollector(@NotNull FileStructureCache fileStructureCache) {
        Intrinsics.checkNotNullParameter((Object)fileStructureCache, (String)"fileStructureCache");
        this.fileStructureCache = fileStructureCache;
    }

    @NotNull
    public final List<KtPsiDiagnostic> getDiagnosticsFor(@NotNull KtElement element3, @NotNull DiagnosticCheckerFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)filter2), (String)"filter");
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        FileStructure fileStructure = this.fileStructureCache.getFileStructure(ktFile);
        FileStructureElement structureElement2 = fileStructure.getStructureElementFor(element3);
        FileStructureElementDiagnostics diagnostics2 = structureElement2.getDiagnostics();
        return diagnostics2.diagnosticsFor(filter2, (PsiElement)element3);
    }

    @NotNull
    public final Collection<KtPsiDiagnostic> collectDiagnosticsForFile(@NotNull KtFile ktFile, @NotNull DiagnosticCheckerFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)((Object)filter2), (String)"filter");
        FileStructure fileStructure = this.fileStructureCache.getFileStructure(ktFile);
        return fileStructure.getAllDiagnosticsForFile(filter2);
    }
}

