/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.ClientData;
import org.jetbrains.security.VulnerabilitiesRepository;
import org.jetbrains.security.VulnerablePackage;
import org.jetbrains.security.dto.FalsePositiveReport;
import org.jetbrains.security.dto.HashesDto;
import org.jetbrains.security.dto.RequestDto;
import org.jetbrains.security.dto.VulnerablePackageDto;
import org.jetbrains.security.exceptions.AnalysisException;
import org.jetbrains.security.exceptions.AnalysisExceptionScope;
import org.jetbrains.security.model.HttpClientApi;
import org.jetbrains.security.model.HttpClientKt;
import org.jetbrains.security.model.ResourceUrl;
import org.jetbrains.security.model.VulnerabilitiesRepositoryServer;
import org.jetbrains.security.model.VulnerabilitiesRepositoryServerKt;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J%\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001b2\u0006\u0010#\u001a\u00020\u0019H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J!\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006+"}, d2={"Lorg/jetbrains/security/model/VulnerabilitiesRepositoryServer;", "Lorg/jetbrains/security/VulnerabilitiesRepository;", "clientData", "Lorg/jetbrains/security/ClientData;", "dbBaseUrl", "Lorg/jetbrains/security/model/ResourceUrl;", "packagesUrlString", "", "falsePositiveUrl", "attemptsToCheck", "", "requestTimeout", "Ljava/time/Duration;", "(Lorg/jetbrains/security/ClientData;Lorg/jetbrains/security/model/ResourceUrl;Ljava/lang/String;Ljava/lang/String;ILjava/time/Duration;)V", "chunkSize", "httpClient", "Lorg/jetbrains/security/model/HttpClientApi;", "getHttpClient", "()Lorg/jetbrains/security/model/HttpClientApi;", "httpClient$delegate", "Lkotlin/Lazy;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "createRequestDto", "Lorg/jetbrains/security/dto/RequestDto;", "packageChunk", "", "Lorg/jetbrains/security/package/Package;", "getVulnerabilities", "Lorg/jetbrains/security/VulnerablePackage;", "pkgs", "", "(Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getVulnerabilitiesFromServer", "requestData", "(Lorg/jetbrains/security/dto/RequestDto;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportFalsePositive", "", "pkg", "vulnerability", "Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;", "(Lorg/jetbrains/security/package/Package;Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nVulnerabilitiesRepositoryServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerabilitiesRepositoryServer.kt\norg/jetbrains/security/model/VulnerabilitiesRepositoryServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,145:1\n1360#2:146\n1446#2,2:147\n1448#2,3:150\n1549#2:153\n1620#2,3:154\n1549#2:157\n1620#2,3:158\n329#3:149\n*S KotlinDebug\n*F\n+ 1 VulnerabilitiesRepositoryServer.kt\norg/jetbrains/security/model/VulnerabilitiesRepositoryServer\n*L\n62#1:146\n62#1:147,2\n62#1:150,3\n121#1:153\n121#1:154,3\n136#1:157\n136#1:158,3\n63#1:149\n*E\n"})
public final class VulnerabilitiesRepositoryServer
implements VulnerabilitiesRepository {
    @NotNull
    private final ClientData clientData;
    @NotNull
    private final ResourceUrl dbBaseUrl;
    @NotNull
    private final String packagesUrlString;
    @NotNull
    private final String falsePositiveUrl;
    private final int attemptsToCheck;
    @NotNull
    private final Duration requestTimeout;
    private final int chunkSize;
    private final ObjectMapper objectMapper;
    @NotNull
    private final Lazy httpClient$delegate;

    public VulnerabilitiesRepositoryServer(@NotNull ClientData clientData, @NotNull ResourceUrl dbBaseUrl, @NotNull String packagesUrlString, @NotNull String falsePositiveUrl, int attemptsToCheck, @NotNull Duration requestTimeout) {
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        Intrinsics.checkNotNullParameter((Object)dbBaseUrl, (String)"dbBaseUrl");
        Intrinsics.checkNotNullParameter((Object)packagesUrlString, (String)"packagesUrlString");
        Intrinsics.checkNotNullParameter((Object)falsePositiveUrl, (String)"falsePositiveUrl");
        Intrinsics.checkNotNullParameter((Object)requestTimeout, (String)"requestTimeout");
        this.clientData = clientData;
        this.dbBaseUrl = dbBaseUrl;
        this.packagesUrlString = packagesUrlString;
        this.falsePositiveUrl = falsePositiveUrl;
        this.attemptsToCheck = attemptsToCheck;
        this.requestTimeout = requestTimeout;
        this.chunkSize = 4096;
        this.objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.httpClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HttpClientApi>(this){
            final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HttpClientApi invoke() {
                String string = VulnerabilitiesRepositoryServer.access$getClientData$p(this.this$0).getJbaUserId();
                if (string == null) {
                    string = VulnerabilitiesRepositoryServer.access$getClientData$p(this.this$0).getAnonymousToken();
                }
                return new HttpClientApi(HttpClientKt.getHeaderParams(string), VulnerabilitiesRepositoryServer.access$getRequestTimeout$p(this.this$0));
            }
        }));
    }

    public /* synthetic */ VulnerabilitiesRepositoryServer(ClientData clientData, ResourceUrl resourceUrl, String string, String string2, int n, Duration duration, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            LocalDateTime localDateTime = LocalDateTime.now().plusHours(1L);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now().plusHours(1)");
            resourceUrl = new ResourceUrl("https://vulnerability-search.europe-north1-gke.intellij.net", localDateTime);
        }
        if ((n2 & 4) != 0) {
            string = "/api/v3/vulnerabilities/cx";
        }
        if ((n2 & 8) != 0) {
            string2 = "/report";
        }
        if ((n2 & 0x10) != 0) {
            n = 3;
        }
        if ((n2 & 0x20) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(5)");
            duration = duration2;
        }
        this(clientData, resourceUrl, string, string2, n, duration);
    }

    private final HttpClientApi getHttpClient() {
        Lazy lazy = this.httpClient$delegate;
        return (HttpClientApi)lazy.getValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getVulnerabilities(@NotNull Iterable<Package> var1_1, @NotNull Continuation<? super List<VulnerablePackage>> var2_2) {
        block21: {
            block20: {
                if (!(var2_2 instanceof getVulnerabilities.1)) ** GOTO lbl-1000
                var18_3 = var2_2;
                if ((var18_3.label & -2147483648) != 0) {
                    var18_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var2_2){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.getVulnerabilities(null, (Continuation<? super List<VulnerablePackage>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var19_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block2 : switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!(this.attemptsToCheck > 0)) {
                            var4_6 = "Failed requirement.";
                            throw new IllegalArgumentException(var4_6.toString());
                        }
                        $this$flatMap$iv = CollectionsKt.chunked((Iterable)pkgs, (int)this.chunkSize);
                        $i$f$flatMap = false;
                        var5_9 = $this$flatMap$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$flatMapTo = false;
                        var8_12 = $this$flatMapTo$iv$iv.iterator();
lbl21:
                        // 2 sources

                        while (var8_12.hasNext()) {
                            element$iv$iv = var8_12.next();
                            pkgChunk = (List)element$iv$iv;
                            $i$a$-flatMap-VulnerabilitiesRepositoryServer$getVulnerabilities$2 = false;
                            $i$f$currentCoroutineContext = false;
                            JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                            attempt = 0;
                            exception = null;
lbl30:
                            // 3 sources

                            while (attempt < this.attemptsToCheck) {
                                ++attempt;
                                if (pkgChunk.isEmpty()) {
                                    v0 = CollectionsKt.emptyList();
                                    break block20;
                                }
                                $continuation.L$0 = this;
                                $continuation.L$1 = destination$iv$iv;
                                $continuation.L$2 = var8_12;
                                $continuation.L$3 = pkgChunk;
                                $continuation.L$4 = exception;
                                $continuation.I$0 = attempt;
                                $continuation.label = 1;
                                v1 = this.getVulnerabilitiesFromServer(this.createRequestDto(pkgChunk), (Continuation<? super List<VulnerablePackage>>)$continuation);
                                ** if (v1 != var19_5) goto lbl48
lbl47:
                                // 1 sources

                                return var19_5;
lbl48:
                                // 1 sources

                                ** GOTO lbl65
                            }
                            break block2;
                        }
                        break block21;
                    }
                    case 1: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-VulnerabilitiesRepositoryServer$getVulnerabilities$2 = false;
                        attempt = $continuation.I$0;
                        exception = (AnalysisException)$continuation.L$4;
                        pkgChunk = (List)$continuation.L$3;
                        var8_12 = (Iterator<T>)$continuation.L$2;
                        destination$iv$iv = (Collection)$continuation.L$1;
                        this = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl65:
                            // 2 sources

                            v0 = (List)v1;
                            break block20;
                        }
                        catch (Exception e) {
                            message = "Failed to check dependencies on server: " + this.dbBaseUrl.getUrl();
                            var16_22 = e;
                            if ((var16_22 instanceof IOException != false ? true : var16_22 instanceof IllegalArgumentException) != false ? true : var16_22 instanceof AnalysisException) {
                                VulnerabilitiesRepositoryServerKt.access$getLogger$p().warn(message);
                                VulnerabilitiesRepositoryServerKt.access$getLogger$p().debug((Throwable)e);
                                if (e instanceof AnalysisException) {
                                    v2 = (AnalysisException)e;
                                } else {
                                    v3 = e.getMessage();
                                    if (v3 == null) {
                                        v3 = e.getClass().getSimpleName();
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"e.message ?: e::class.java.simpleName");
                                    v2 = new AnalysisException(message, AnalysisExceptionScope.USER, v3);
                                }
                                exception = v2;
                            }
                            $continuation.L$0 = this;
                            $continuation.L$1 = destination$iv$iv;
                            $continuation.L$2 = var8_12;
                            $continuation.L$3 = pkgChunk;
                            $continuation.L$4 = exception;
                            $continuation.I$0 = attempt;
                            $continuation.label = 2;
                            v4 = DelayKt.delay((long)(attempt * 200), (Continuation)$continuation);
                            if (v4 != var19_5) ** GOTO lbl30
                            return var19_5;
                        }
                    }
                    case 2: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-VulnerabilitiesRepositoryServer$getVulnerabilities$2 = false;
                        attempt = $continuation.I$0;
                        exception = (AnalysisException)$continuation.L$4;
                        pkgChunk = (List)$continuation.L$3;
                        var8_12 = (Iterator)$continuation.L$2;
                        destination$iv$iv = (Collection)$continuation.L$1;
                        this = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        ** GOTO lbl30
                    }
                }
                if (exception != null) {
                    v5 = VulnerabilitiesRepositoryServerKt.access$getLogger$p();
                    var14_19 = exception.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)var14_19, (String)"exception.stackTrace");
                    v6 = var14_19;
                    v7 = LineSeparator.getSystemLineSeparator().getSeparatorString();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getSystemLineSeparator().separatorString");
                    v5.warn(ArraysKt.joinToString$default((Object[])v6, (CharSequence)v7, null, null, (int)0, null, null, (int)62, null));
                }
                v0 = CollectionsKt.emptyList();
            }
            list$iv$iv = v0;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            ** GOTO lbl21
        }
        return (List)destination$iv$iv;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object reportFalsePositive(@NotNull Package var1_1, @NotNull Vulnerability var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof reportFalsePositive.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.reportFalsePositive(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                falsePositiveReport = new FalsePositiveReport(vulnerability.getCve(), pkg.getSearchKey(), this.clientData.getAnonymousToken());
                falsePositiveReportJson = this.objectMapper.writeValueAsString((Object)falsePositiveReport);
                v0 = this.getHttpClient();
                v1 = this.dbBaseUrl.getUrl() + this.falsePositiveUrl;
                var7_10 = HttpRequest.BodyPublishers.ofString(falsePositiveReportJson);
                Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"ofString(falsePositiveReportJson)");
                v2 = HttpResponse.BodyHandlers.ofString();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"ofString()");
                $continuation.label = 1;
                v3 = v0.post(v1, var7_10, v2, $continuation);
                ** if (v3 != var10_6) goto lbl26
lbl25:
                // 1 sources

                return var10_6;
lbl26:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl32:
                    // 2 sources

                    if (!VulnerabilitiesRepositoryServerKt.access$isSuccess((response = (HttpResponse)v3).statusCode())) {
                        VulnerabilitiesRepositoryServerKt.access$getLogger$p().warn("Error during reporting FP, errorCode: " + response.statusCode());
                    }
                }
                catch (HttpTimeoutException var5_9) {
                    VulnerabilitiesRepositoryServerKt.access$getLogger$p().warn("Error during reporting FP, timeout reached");
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final RequestDto createRequestDto(List<Package> packageChunk) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = packageChunk;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Package package_ = (Package)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSearchKey());
        }
        List packageDtos = (List)destination$iv$iv;
        return new HashesDto(packageDtos, this.clientData.getAnonymousToken(), this.clientData.getApplicationMode());
    }

    /*
     * Unable to fully structure code
     */
    private final Object getVulnerabilitiesFromServer(RequestDto var1_1, Continuation<? super List<VulnerablePackage>> var2_2) {
        if (!(var2_2 instanceof getVulnerabilitiesFromServer.1)) ** GOTO lbl-1000
        var15_3 = var2_2;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VulnerabilitiesRepositoryServer.access$getVulnerabilitiesFromServer(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                requestDataJson = this.objectMapper.writeValueAsString((Object)requestData);
                v0 = this.getHttpClient();
                v1 = this.dbBaseUrl.getUrl() + this.packagesUrlString;
                var5_7 = HttpRequest.BodyPublishers.ofString(requestDataJson);
                Intrinsics.checkNotNullExpressionValue((Object)var5_7, (String)"ofString(requestDataJson)");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v2 = v0.post(v1, var5_7, (HttpResponse.BodyHandler<T>)LambdaMetafactory.metafactory(null, null, null, (Ljava/net/http/HttpResponse$ResponseInfo;)Ljava/net/http/HttpResponse$BodySubscriber;, getVulnerabilitiesFromServer$lambda$3(org.jetbrains.security.model.VulnerabilitiesRepositoryServer java.net.http.HttpResponse$ResponseInfo ), (Ljava/net/http/HttpResponse$ResponseInfo;)Ljava/net/http/HttpResponse$BodySubscriber;)((VulnerabilitiesRepositoryServer)this), $continuation);
                ** if (v2 != var16_5) goto lbl24
lbl23:
                // 1 sources

                return var16_5;
lbl24:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                this = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl31:
                    // 2 sources

                    var4_9 = ((HttpResponse)v2).body();
                    Intrinsics.checkNotNullExpressionValue(var4_9, (String)"httpClient.post(\n       \u2026\n        }\n      ).body()");
                    $this$map$iv = (Iterable)var4_9;
                    $i$f$map = false;
                    var6_11 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var11_16 = (VulnerablePackageDto)item$iv$iv;
                        var13_18 = destination$iv$iv;
                        $i$a$-map-VulnerabilitiesRepositoryServer$getVulnerabilitiesFromServer$3 = false;
                        var13_18.add(it.toVulnerablePackage());
                    }
                    var3_6 = (List)destination$iv$iv;
                }
                catch (Exception var4_10) {
                    throw new AnalysisException("Failed to check dependencies on server: " + this.dbBaseUrl.getUrl(), AnalysisExceptionScope.USER, null, 4, null);
                }
                return var3_6;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final List getVulnerabilitiesFromServer$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final HttpResponse.BodySubscriber getVulnerabilitiesFromServer$lambda$3(VulnerabilitiesRepositoryServer this$0, HttpResponse.ResponseInfo it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return HttpResponse.BodySubscribers.mapping(HttpResponse.BodySubscribers.ofByteArray(), arg_0 -> VulnerabilitiesRepositoryServer.getVulnerabilitiesFromServer$lambda$3$lambda$2((Function1)new Function1<byte[], List<? extends VulnerablePackageDto>>(this$0){
            final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final List<VulnerablePackageDto> invoke(byte[] it) {
                return (List)VulnerabilitiesRepositoryServer.access$getObjectMapper$p(this.this$0).readValue(it, (TypeReference)new TypeReference<List<? extends VulnerablePackageDto>>(){});
            }
        }, arg_0));
    }

    public static final /* synthetic */ Object access$getVulnerabilitiesFromServer(VulnerabilitiesRepositoryServer $this, RequestDto requestData, Continuation $completion) {
        return $this.getVulnerabilitiesFromServer(requestData, (Continuation<? super List<VulnerablePackage>>)$completion);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(VulnerabilitiesRepositoryServer $this) {
        return $this.objectMapper;
    }

    public static final /* synthetic */ ClientData access$getClientData$p(VulnerabilitiesRepositoryServer $this) {
        return $this.clientData;
    }

    public static final /* synthetic */ Duration access$getRequestTimeout$p(VulnerabilitiesRepositoryServer $this) {
        return $this.requestTimeout;
    }
}

