/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.api.PackageDeclaration;
import org.jetbrains.security.fus.PackageCheckerUsageStat;
import org.jetbrains.security.inspection.ProblemDescriptorBuilder;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.service.PackageChecker;
import org.jetbrains.security.service.PackageService;
import org.jetbrains.security.service.PackageStatus;
import org.jetbrains.security.service.Vulnerable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/security/inspection/VulnerableLibrariesLocalInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "matchCoordinates", "", "it", "Lorg/jetbrains/security/package/Package;", "runForWholeFile", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nVulnerableLibrariesLocalInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerableLibrariesLocalInspection.kt\norg/jetbrains/security/inspection/VulnerableLibrariesLocalInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1194#2,2:146\n1222#2,4:148\n1549#2:152\n1620#2,3:153\n766#2:156\n857#2,2:157\n1603#2,9:159\n1855#2:168\n1856#2:170\n1612#2:171\n1#3:169\n*S KotlinDebug\n*F\n+ 1 VulnerableLibrariesLocalInspection.kt\norg/jetbrains/security/inspection/VulnerableLibrariesLocalInspection\n*L\n31#1:146,2\n31#1:148,4\n33#1:152\n33#1:153,3\n34#1:156\n34#1:157,2\n39#1:159,9\n39#1:168\n39#1:170\n39#1:171\n39#1:169\n*E\n"})
public final class VulnerableLibrariesLocalInspection
extends LocalInspectionTool {
    public boolean runForWholeFile() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Package it;
        Object object;
        Iterable $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        Project project2 = project;
        PackageService service = PackageService.Companion.getInstance(project2);
        if (!service.isBuildFile(file2)) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Iterable $this$associateBy$iv = service.declaredDependencies(file2);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            PackageDeclaration packageDeclaration = (PackageDeclaration)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(((PackageDeclaration)((Object)it)).getPkg(), element$iv$iv);
        }
        Map declaredDependencies2 = destination$iv$iv;
        Iterable $this$map$iv = declaredDependencies2.keySet();
        boolean $i$f$map = false;
        $this$associateByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Package)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.matchCoordinates(it));
        }
        Set declaredIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = CollectionsKt.toSet((Iterable)service.importedDependencies(file2));
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Package it2 = (Package)element$iv$iv;
            boolean bl = false;
            if (!(!declaredIds.contains(this.matchCoordinates(it2)))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List transitiveDependencies = (List)destination$iv$iv2;
        PackageChecker packageChecker = PackageChecker.Companion.getInstance(project2);
        Iterable $this$mapNotNull$iv = SetsKt.plus(declaredDependencies2.keySet(), (Iterable)transitiveDependencies);
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$filterTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Vulnerable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Package it3 = (Package)element$iv$iv;
            boolean bl2 = false;
            PackageStatus packageStatus = packageChecker.packageStatus(it3);
            if ((packageStatus instanceof Vulnerable ? (Vulnerable)packageStatus : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List vulnerablePackages = (List)destination$iv$iv3;
        boolean headless = packageChecker.isHeadlessMode();
        List<ProblemDescriptor> problemDescriptors = new ProblemDescriptorBuilder(manager, file2, declaredDependencies2, service, headless).descriptors(vulnerablePackages);
        PackageCheckerUsageStat.localInspectionResult.log(project2, (Object)problemDescriptors.size());
        Collection collection = problemDescriptors;
        Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return (ProblemDescriptor[])UtilKt.toArray((Collection)collection, (Object[])ProblemDescriptor.EMPTY_ARRAY);
    }

    private final String matchCoordinates(Package it) {
        return it.getNamespace() + ":" + it.getName();
    }
}

