/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.inspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ModuleProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.VulnerablePackage;
import org.jetbrains.security.api.PackageDeclaration;
import org.jetbrains.security.fus.PackageCheckerUsageStat;
import org.jetbrains.security.inspection.fix.ChangeVersionQuickfix;
import org.jetbrains.security.inspection.fix.DeclarePackageFix;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.version.SingleVersion;
import org.jetbrains.security.problems.vulnerabilities.CallToAction;
import org.jetbrains.security.service.PackageChecker;
import org.jetbrains.security.service.PackageService;
import org.jetbrains.security.service.PackageStatus;
import org.jetbrains.security.service.PackageStatusKt;
import org.jetbrains.security.service.Vulnerable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016JH\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/security/inspection/VulnerableLibrariesGlobalInspection;", "Lcom/intellij/codeInspection/GlobalInspectionTool;", "()V", "isGraphNeeded", "", "reportProblems", "", "Lcom/intellij/codeInspection/CommonProblemDescriptor;", "vulnerablePackages", "Lorg/jetbrains/security/VulnerablePackage;", "declarations", "", "Lorg/jetbrains/security/package/Package;", "Lorg/jetbrains/security/api/PackageDeclaration;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "module", "Lcom/intellij/openapi/module/Module;", "supportsFixes", "runInspection", "", "scope", "Lcom/intellij/analysis/AnalysisScope;", "globalContext", "Lcom/intellij/codeInspection/GlobalInspectionContext;", "problemDescriptionsProcessor", "Lcom/intellij/codeInspection/ProblemDescriptionsProcessor;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nVulnerableLibrariesGlobalInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerableLibrariesGlobalInspection.kt\norg/jetbrains/security/inspection/VulnerableLibrariesGlobalInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,100:1\n1194#2,2:101\n1222#2,4:103\n1603#2,9:107\n1855#2:116\n1856#2:118\n1612#2:119\n1549#2:120\n1620#2,2:121\n1622#2:124\n1#3:117\n26#4:123\n*S KotlinDebug\n*F\n+ 1 VulnerableLibrariesGlobalInspection.kt\norg/jetbrains/security/inspection/VulnerableLibrariesGlobalInspection\n*L\n43#1:101,2\n43#1:103,4\n50#1:107,9\n50#1:116\n50#1:118\n50#1:119\n75#1:120\n75#1:121,2\n75#1:124\n50#1:117\n78#1:123\n*E\n"})
public final class VulnerableLibrariesGlobalInspection
extends GlobalInspectionTool {
    public boolean isGraphNeeded() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        Intrinsics.checkNotNullParameter((Object)problemDescriptionsProcessor, (String)"problemDescriptionsProcessor");
        Project project = scope.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"scope.project");
        Project project2 = project;
        PackageCheckerUsageStat.runGlobalInspection.log(project2);
        PackageChecker packageChecker = PackageChecker.Companion.getInstance(project2);
        PackageService packageService = PackageService.Companion.getInstance(project2);
        boolean headless = packageChecker.isHeadlessMode();
        int problemsCount = 0;
        Project project3 = globalContext.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"globalContext.project");
        for (Module module : ModuleManager.Companion.getInstance(project3).getModules()) {
            List list;
            Object object;
            Iterable $this$associateByTo$iv$iv;
            ProgressManager.checkCanceled();
            if (!scope.containsModule(module)) continue;
            List<Package> packages = packageService.importedDependencies(module);
            CommonProblemDescriptor[] $this$associateBy$iv = (CommonProblemDescriptor[])packageService.declaredDependencies(module);
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            CommonProblemDescriptor[] commonProblemDescriptorArray = $this$associateBy$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                object = (PackageDeclaration)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.getPkg(), element$iv$iv);
            }
            Map declarations = destination$iv$iv;
            if (headless) {
                list = packageChecker.getVulnerabilities(packages);
            } else {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = packages;
                boolean $i$f$mapNotNull = false;
                $this$associateByTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    VulnerablePackage it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl = false;
                    Package it = (Package)element$iv$iv;
                    boolean bl2 = false;
                    PackageStatus packageStatus = packageChecker.packageStatus(it);
                    Vulnerable vulnerable = packageStatus instanceof Vulnerable ? (Vulnerable)packageStatus : null;
                    if ((vulnerable != null ? vulnerable.getVulnerablePackage() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            List vulnerablePackages = list;
            boolean supportsFixes = packageService.supportsFixes(module);
            List<CommonProblemDescriptor> problems = this.reportProblems(vulnerablePackages, declarations, manager, module, supportsFixes);
            problemsCount += problems.size();
            RefEntity refEntity = (RefEntity)globalContext.getRefManager().getRefModule(module);
            Collection collection = problems;
            Intrinsics.checkNotNullExpressionValue((Object)ModuleProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            commonProblemDescriptorArray = (CommonProblemDescriptor[])UtilKt.toArray((Collection)collection, (Object[])ModuleProblemDescriptor.EMPTY_ARRAY);
            problemDescriptionsProcessor.addProblemElement(refEntity, Arrays.copyOf(commonProblemDescriptorArray, commonProblemDescriptorArray.length));
        }
        PackageCheckerUsageStat.globalInspectionResult.log(project2, (Object)problemsCount);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CommonProblemDescriptor> reportProblems(List<VulnerablePackage> vulnerablePackages, Map<Package, PackageDeclaration> declarations, InspectionManager manager, Module module, boolean supportsFixes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = vulnerablePackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ModuleProblemDescriptor createProblemDescriptor;
            SingleVersion call2action;
            void vulnerablePackage;
            VulnerablePackage vulnerablePackage2 = (VulnerablePackage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            boolean $i$f$emptyArray = false;
            QuickFix[] fix = new QuickFix[]{};
            CallToAction callToAction = vulnerablePackage.getCallToAction();
            SingleVersion singleVersion = call2action = callToAction != null ? callToAction.getNewVersion() : null;
            if (supportsFixes) {
                boolean managed = declarations.containsKey(vulnerablePackage.getPkg());
                if (call2action != null) {
                    QuickFix[] quickFixArray;
                    if (managed) {
                        var18_20 = new QuickFix[]{new ChangeVersionQuickfix(call2action.getValue(), vulnerablePackage.getPkg())};
                        quickFixArray = var18_20;
                    } else {
                        var18_20 = new QuickFix[]{new DeclarePackageFix(Package.copy$default(vulnerablePackage.getPkg(), null, null, null, new SingleVersion(call2action.getValue()), null, null, null, 119, null))};
                        quickFixArray = var18_20;
                    }
                    fix = quickFixArray;
                }
            }
            SingleVersion singleVersion2 = call2action;
            String message = PackageStatusKt.generateInspectionMessage((VulnerablePackage)vulnerablePackage, "inspection.template", singleVersion2 != null ? singleVersion2.getValue() : null);
            Intrinsics.checkNotNullExpressionValue((Object)manager.createProblemDescriptor(message, module, Arrays.copyOf(fix, fix.length)), (String)"manager.createProblemDes\u2026ule,\n        *fix\n      )");
            collection.add(createProblemDescriptor);
        }
        return (List)destination$iv$iv;
    }
}

