/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalHighlighter;", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "highlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "(Ljava/util/List;)V", "editor", "Lcom/intellij/openapi/editor/highlighter/HighlighterClient;", "createIterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "startOffset", "", "setEditor", "", "MyHighlighterIterator", "intellij.terminal"})
public final class TerminalHighlighter
implements EditorHighlighter {
    @NotNull
    private final List<HighlightingInfo> highlightings;
    @Nullable
    private HighlighterClient editor;

    public TerminalHighlighter(@NotNull List<HighlightingInfo> highlightings) {
        Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
        this.highlightings = highlightings;
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        return new MyHighlighterIterator();
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalHighlighter$MyHighlighterIterator;", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalHighlighter;)V", "curInd", "", "advance", "", "atEnd", "", "getDocument", "Lcom/intellij/openapi/editor/Document;", "getEnd", "getStart", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getTokenType", "Lcom/intellij/psi/tree/IElementType;", "retreat", "intellij.terminal"})
    private final class MyHighlighterIterator
    implements HighlighterIterator {
        private int curInd;

        public int getStart() {
            return ((HighlightingInfo)TerminalHighlighter.this.highlightings.get(this.curInd)).getStartOffset();
        }

        public int getEnd() {
            return ((HighlightingInfo)TerminalHighlighter.this.highlightings.get(this.curInd)).getEndOffset();
        }

        @NotNull
        public TextAttributes getTextAttributes() {
            return ((HighlightingInfo)TerminalHighlighter.this.highlightings.get(this.curInd)).getTextAttributes();
        }

        @Nullable
        public IElementType getTokenType() {
            return null;
        }

        public void advance() {
            if (this.curInd < TerminalHighlighter.this.highlightings.size()) {
                int n = this.curInd;
                this.curInd = n + 1;
            }
        }

        public void retreat() {
            if (this.curInd > -1) {
                int n = this.curInd;
                this.curInd = n + -1;
            }
        }

        public boolean atEnd() {
            return this.curInd < 0 || this.curInd >= TerminalHighlighter.this.highlightings.size();
        }

        @Nullable
        public Document getDocument() {
            HighlighterClient highlighterClient = TerminalHighlighter.this.editor;
            return highlighterClient != null ? highlighterClient.getDocument() : null;
        }
    }
}

