/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommitShort;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineGroupedCommits;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedEvents;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedSimpleEvents;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedStateEvents;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tJ\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002J\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergingModel;", "Ljavax/swing/AbstractListModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "()V", "list", "", "add", "", "items", "", "getElementAt", "index", "", "getSize", "remove", "item", "removeAll", "update", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRTimelineMergingModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRTimelineMergingModel.kt\norg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergingModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class GHPRTimelineMergingModel
extends AbstractListModel<GHPRTimelineItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<GHPRTimelineItem> list = new ArrayList();
    private static final long MERGE_THRESHOLD_MS = 120000L;

    @Override
    @NotNull
    public GHPRTimelineItem getElementAt(int index) {
        return this.list.get(index);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    public final void add(@NotNull List<? extends GHPRTimelineItem> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        int lastListIdx = CollectionsKt.getLastIndex(this.list);
        GHPRTimelineItem lastItem = (GHPRTimelineItem)CollectionsKt.lastOrNull(this.list);
        if (lastItem != null) {
            this.list.remove(lastListIdx);
            this.fireIntervalRemoved(this, lastListIdx, lastListIdx);
            --lastListIdx;
        }
        boolean added = false;
        Application application = ApplicationManager.getApplication();
        boolean bl = false;
        boolean hideUnknown = !application.isInternal() && !application.isEAP();
        for (GHPRTimelineItem gHPRTimelineItem : items2) {
            if (gHPRTimelineItem instanceof GHPRTimelineItem.Unknown && (hideUnknown || GHPRTimelineItem.Companion.getIGNORED_TYPES().contains(((GHPRTimelineItem.Unknown)gHPRTimelineItem).get__typename()))) continue;
            GHPRTimelineItem merged = GHPRTimelineMergingModel.Companion.mergeIfPossible(lastItem, gHPRTimelineItem);
            if (merged != null) {
                lastItem = merged;
                continue;
            }
            if (lastItem != null && !GHPRTimelineMergingModel.Companion.isCollapsedMerge(lastItem)) {
                this.list.add(lastItem);
                added = true;
            }
            lastItem = gHPRTimelineItem;
        }
        if (lastItem != null && !GHPRTimelineMergingModel.Companion.isCollapsedMerge(lastItem)) {
            this.list.add(lastItem);
            added = true;
        }
        if (added) {
            this.fireIntervalAdded(this, lastListIdx + 1, CollectionsKt.getLastIndex(this.list));
        }
    }

    public final void update(@NotNull GHPRTimelineItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int idx = this.list.indexOf(item);
        if (idx >= 0) {
            this.list.set(idx, item);
        }
        this.fireContentsChanged(this, idx, idx);
    }

    public final void remove(@NotNull GHPRTimelineItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int idx = this.list.indexOf(item);
        if (idx >= 0) {
            this.list.remove(idx);
        }
        this.fireIntervalRemoved(this, idx, idx);
    }

    public final void removeAll() {
        int lastIdx = Math.max(0, this.getSize() - 1);
        this.list.clear();
        if (lastIdx > 0) {
            this.fireIntervalRemoved(this, 0, lastIdx);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergingModel$Companion;", "", "()V", "MERGE_THRESHOLD_MS", "", "isCollapsedMerge", "", "event", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "mergeIfPossible", "existing", "new", "tryGroupCommits", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        private final GHPRTimelineItem mergeIfPossible(GHPRTimelineItem existing, GHPRTimelineItem gHPRTimelineItem) {
            GHPRTimelineItem groupedCommits = this.tryGroupCommits(existing, gHPRTimelineItem);
            if (groupedCommits != null) {
                return groupedCommits;
            }
            if (!(existing instanceof GHPRTimelineEvent) || !(gHPRTimelineItem instanceof GHPRTimelineEvent)) {
                return null;
            }
            if (!Intrinsics.areEqual((Object)((GHPRTimelineEvent)existing).getActor(), (Object)((GHPRTimelineEvent)gHPRTimelineItem).getActor())) {
                return null;
            }
            if (((GHPRTimelineEvent)gHPRTimelineItem).getCreatedAt().getTime() - ((GHPRTimelineEvent)existing).getCreatedAt().getTime() > 120000L) {
                return null;
            }
            if (existing instanceof GHPRTimelineEvent.Simple && gHPRTimelineItem instanceof GHPRTimelineEvent.Simple) {
                GHPRTimelineMergedSimpleEvents gHPRTimelineMergedSimpleEvents;
                if (existing instanceof GHPRTimelineMergedSimpleEvents) {
                    ((GHPRTimelineMergedSimpleEvents)existing).add((GHPRTimelineEvent)gHPRTimelineItem);
                    return existing;
                }
                GHPRTimelineMergedSimpleEvents $this$mergeIfPossible_u24lambda_u240 = gHPRTimelineMergedSimpleEvents = new GHPRTimelineMergedSimpleEvents();
                boolean bl = false;
                $this$mergeIfPossible_u24lambda_u240.add((GHPRTimelineEvent)existing);
                $this$mergeIfPossible_u24lambda_u240.add((GHPRTimelineEvent)gHPRTimelineItem);
                return gHPRTimelineMergedSimpleEvents;
            }
            if (existing instanceof GHPRTimelineEvent.State && gHPRTimelineItem instanceof GHPRTimelineEvent.State) {
                GHPRTimelineMergedStateEvents gHPRTimelineMergedStateEvents;
                if (existing instanceof GHPRTimelineMergedStateEvents) {
                    ((GHPRTimelineMergedStateEvents)existing).add((GHPRTimelineEvent)gHPRTimelineItem);
                    return existing;
                }
                GHPRTimelineMergedStateEvents $this$mergeIfPossible_u24lambda_u241 = gHPRTimelineMergedStateEvents = new GHPRTimelineMergedStateEvents((GHPRTimelineEvent.State)existing);
                boolean bl = false;
                $this$mergeIfPossible_u24lambda_u241.add((GHPRTimelineEvent)gHPRTimelineItem);
                return gHPRTimelineMergedStateEvents;
            }
            return null;
        }

        private final GHPRTimelineItem tryGroupCommits(GHPRTimelineItem existing, GHPRTimelineItem gHPRTimelineItem) {
            if (existing instanceof GHPullRequestCommitShort && gHPRTimelineItem instanceof GHPullRequestCommitShort) {
                GHPRTimelineGroupedCommits gHPRTimelineGroupedCommits;
                GHPRTimelineGroupedCommits $this$tryGroupCommits_u24lambda_u242 = gHPRTimelineGroupedCommits = new GHPRTimelineGroupedCommits();
                boolean bl = false;
                $this$tryGroupCommits_u24lambda_u242.add(existing);
                $this$tryGroupCommits_u24lambda_u242.add(gHPRTimelineItem);
                return gHPRTimelineGroupedCommits;
            }
            if (existing instanceof GHPRTimelineGroupedCommits && gHPRTimelineItem instanceof GHPullRequestCommitShort) {
                GHPRTimelineItem gHPRTimelineItem2 = existing;
                GHPRTimelineGroupedCommits $this$tryGroupCommits_u24lambda_u243 = (GHPRTimelineGroupedCommits)gHPRTimelineItem2;
                boolean bl = false;
                $this$tryGroupCommits_u24lambda_u243.add(gHPRTimelineItem);
                return gHPRTimelineItem2;
            }
            if (existing instanceof GHPullRequestCommitShort && gHPRTimelineItem instanceof GHPRTimelineGroupedCommits) {
                GHPRTimelineGroupedCommits gHPRTimelineGroupedCommits;
                GHPRTimelineGroupedCommits $this$tryGroupCommits_u24lambda_u244 = gHPRTimelineGroupedCommits = new GHPRTimelineGroupedCommits();
                boolean bl = false;
                $this$tryGroupCommits_u24lambda_u244.add(existing);
                for (GHPullRequestCommitShort item : ((GHPRTimelineGroupedCommits)gHPRTimelineItem).getItems()) {
                    $this$tryGroupCommits_u24lambda_u244.add((GHPRTimelineItem)item);
                }
                return gHPRTimelineGroupedCommits;
            }
            if (existing instanceof GHPRTimelineGroupedCommits && gHPRTimelineItem instanceof GHPRTimelineGroupedCommits) {
                GHPRTimelineItem gHPRTimelineItem3 = existing;
                GHPRTimelineGroupedCommits $this$tryGroupCommits_u24lambda_u245 = (GHPRTimelineGroupedCommits)gHPRTimelineItem3;
                boolean bl = false;
                for (GHPullRequestCommitShort item : ((GHPRTimelineGroupedCommits)gHPRTimelineItem).getItems()) {
                    $this$tryGroupCommits_u24lambda_u245.add((GHPRTimelineItem)item);
                }
                return gHPRTimelineItem3;
            }
            return null;
        }

        private final boolean isCollapsedMerge(GHPRTimelineItem event) {
            return event instanceof GHPRTimelineMergedEvents && !((GHPRTimelineMergedEvents)event).hasAnyChanges();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

