/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.list;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPanelFactory;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.SingleComponentCenteringLayout;
import com.intellij.util.ui.StatusText;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.ui.filters.GHPRListSearchValue;
import org.jetbrains.plugins.github.pullrequest.ui.filters.GHPRSearchPanelViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.list.GHPRErrorStatusPresenter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J \u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/list/GHPRListPanelController;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "listLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "searchVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/filters/GHPRSearchPanelViewModel;", "repository", "", "emptyText", "Lcom/intellij/util/ui/StatusText;", "listComponent", "Ljavax/swing/JComponent;", "mainPanel", "Lcom/intellij/ui/components/panels/Wrapper;", "listenersDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;Lorg/jetbrains/plugins/github/pullrequest/ui/filters/GHPRSearchPanelViewModel;Ljava/lang/String;Lcom/intellij/util/ui/StatusText;Ljavax/swing/JComponent;Lcom/intellij/ui/components/panels/Wrapper;Lcom/intellij/openapi/Disposable;)V", "errorPanel", "errorState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "loadingState", "", "createErrorPanel", "updateEmptyText", "", "isLoading", "searchValue", "Lorg/jetbrains/plugins/github/pullrequest/ui/filters/GHPRListSearchValue;", "intellij.vcs.github"})
public final class GHPRListPanelController {
    @NotNull
    private final GHListLoader<?> listLoader;
    @NotNull
    private final GHPRSearchPanelViewModel searchVm;
    @NotNull
    private final String repository;
    @NotNull
    private final StatusText emptyText;
    @NotNull
    private final JComponent listComponent;
    @NotNull
    private final Wrapper mainPanel;
    @NotNull
    private final MutableStateFlow<Boolean> loadingState;
    @NotNull
    private final MutableStateFlow<Throwable> errorState;
    @NotNull
    private final JComponent errorPanel;

    public GHPRListPanelController(@NotNull Project project, @NotNull CoroutineScope scope, @NotNull GithubAccount account, @NotNull GHListLoader<?> listLoader, @NotNull GHPRSearchPanelViewModel searchVm, @NotNull String repository, @NotNull StatusText emptyText, @NotNull JComponent listComponent, @NotNull Wrapper mainPanel2, @NotNull Disposable listenersDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter(listLoader, (String)"listLoader");
        Intrinsics.checkNotNullParameter((Object)((Object)searchVm), (String)"searchVm");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)emptyText, (String)"emptyText");
        Intrinsics.checkNotNullParameter((Object)listComponent, (String)"listComponent");
        Intrinsics.checkNotNullParameter((Object)mainPanel2, (String)"mainPanel");
        Intrinsics.checkNotNullParameter((Object)listenersDisposable, (String)"listenersDisposable");
        this.listLoader = listLoader;
        this.searchVm = searchVm;
        this.repository = repository;
        this.emptyText = emptyText;
        this.listComponent = listComponent;
        this.mainPanel = mainPanel2;
        this.loadingState = StateFlowKt.MutableStateFlow((Object)this.listLoader.getLoading());
        this.errorState = StateFlowKt.MutableStateFlow((Object)this.listLoader.getError());
        this.errorPanel = this.createErrorPanel(project, scope, account);
        this.listLoader.addLoadingStateChangeListener(listenersDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                loadingState.setValue((Object)listLoader.getLoading());
            }
        }));
        this.listLoader.addErrorChangeListener(listenersDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                errorState.setValue((Object)listLoader.getError());
            }
        }));
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GHPRListPanelController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.errorState.collect(new FlowCollector(){

                            @Nullable
                            public final Object emit(@Nullable Throwable error, @NotNull Continuation<? super Unit> $completion) {
                                this$0.mainPanel.setContent(error != null ? this$0.errorPanel : this$0.listComponent);
                                this$0.mainPanel.repaint();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GHPRListPanelController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = CoroutineUtilKt.combineAndCollect((Flow)((Flow)this.this$0.loadingState), (Flow)((Flow)this.this$0.searchVm.getSearchState()), (Function2)((Function2)new Function2<Boolean, GHPRListSearchValue, Unit>(){

                            public final void invoke(boolean isLoading, @NotNull GHPRListSearchValue searchValue) {
                                Intrinsics.checkNotNullParameter((Object)searchValue, (String)"searchValue");
                                this$0.updateEmptyText(isLoading, searchValue);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void updateEmptyText(boolean isLoading, GHPRListSearchValue searchValue) {
        this.emptyText.clear();
        if (isLoading) {
            this.emptyText.appendText(CollaborationToolsBundle.message((String)"review.list.empty.state.loading", (Object[])new Object[0]));
            return;
        }
        if (searchValue.getFilterCount() == 0) {
            Object[] objectArray = new Object[]{this.repository};
            this.emptyText.appendText(GithubBundle.message("pull.request.list.nothing.loaded", objectArray));
        } else {
            this.emptyText.appendText(GithubBundle.message("pull.request.list.no.matches", new Object[0])).appendSecondaryText(GithubBundle.message("pull.request.list.filters.clear", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> GHPRListPanelController.updateEmptyText$lambda$0(this, arg_0));
        }
    }

    private final JComponent createErrorPanel(Project project, CoroutineScope scope, GithubAccount account) {
        JPanel jPanel;
        GHPRErrorStatusPresenter errorPresenter2 = new GHPRErrorStatusPresenter(project, account, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GHPRListPanelController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GHPRListPanelController.access$getListLoader$p(this.this$0).reset();
                GHListLoader.loadMore$default(GHPRListPanelController.access$getListLoader$p(this.this$0), false, 1, null);
            }
        }));
        JComponent errorPanel = ErrorStatusPanelFactory.INSTANCE.create(scope, (Flow)this.errorState, (ErrorStatusPresenter)errorPresenter2);
        JPanel $this$createErrorPanel_u24lambda_u241 = jPanel = new JPanel((LayoutManager)new SingleComponentCenteringLayout());
        boolean bl = false;
        $this$createErrorPanel_u24lambda_u241.add(errorPanel);
        return jPanel;
    }

    private static final void updateEmptyText$lambda$0(GHPRListPanelController this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.searchVm.getSearchState().setValue((Object)GHPRListSearchValue.Companion.getEMPTY());
    }
}

