/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details.model;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewBranches;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewBranchesViewModel;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.CoroutineScopeKt;
import git4idea.commands.Git;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.ui.branch.GitBranchPopupActions;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRStatisticsCollector;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.GHPRBranchesModel;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.GHPRBranchesViewModel;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J.\u0010&\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\r\u0010'\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b(2\r\u0010)\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b(H\u0002J\b\u0010*\u001a\u00020\"H\u0016J&\u0010+\u001a\u0004\u0018\u00010,*\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u0010H\u0002J2\u0010/\u001a\u0004\u0018\u00010,*\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010-\u001a\u00020\u00102\b\u00100\u001a\u0004\u0018\u00010\u00102\b\u00101\u001a\u0004\u0018\u00010\u0010H\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/model/GHPRBranchesViewModel;", "Lcom/intellij/collaboration/ui/codereview/details/model/CodeReviewBranchesViewModel;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "branchesModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/model/GHPRBranchesModel;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/ui/details/model/GHPRBranchesModel;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;)V", "_showBranchesRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/collaboration/ui/codereview/details/model/CodeReviewBranches;", "_sourceBranch", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "_targetBranch", "cs", "git", "Lgit4idea/commands/Git;", "isCheckedOut", "Lkotlinx/coroutines/flow/SharedFlow;", "", "()Lkotlinx/coroutines/flow/SharedFlow;", "showBranchesRequests", "getShowBranchesRequests", "sourceBranch", "Lkotlinx/coroutines/flow/StateFlow;", "getSourceBranch", "()Lkotlinx/coroutines/flow/StateFlow;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "fetchAndCheckoutRemoteBranch", "", "isBranchCheckedOut", "repository", "Lgit4idea/repo/GitRepository;", "notifyRemoteError", "httpForkUrl", "Lcom/intellij/openapi/util/NlsSafe;", "sshForkUrl", "showBranches", "createRemote", "Lgit4idea/repo/GitRemote;", "remoteName", "url", "findOrCreateRemote", "httpUrl", "sshUrl", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRBranchesViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRBranchesViewModel.kt\norg/jetbrains/plugins/github/pullrequest/ui/details/model/GHPRBranchesViewModel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n29#2,3:169\n8#3:172\n1747#4,3:173\n1#5:176\n*S KotlinDebug\n*F\n+ 1 GHPRBranchesViewModel.kt\norg/jetbrains/plugins/github/pullrequest/ui/details/model/GHPRBranchesViewModel\n*L\n44#1:169,3\n64#1:172\n140#1:173,3\n*E\n"})
public final class GHPRBranchesViewModel
implements CodeReviewBranchesViewModel {
    @NotNull
    private final Project project;
    @NotNull
    private final GHPRBranchesModel branchesModel;
    @NotNull
    private final GHPRDetailsDataProvider detailsDataProvider;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Git git;
    @NotNull
    private final VcsNotifier vcsNotifier;
    @NotNull
    private final MutableStateFlow<String> _targetBranch;
    @NotNull
    private final MutableStateFlow<String> _sourceBranch;
    @NotNull
    private final StateFlow<String> sourceBranch;
    @NotNull
    private final SharedFlow<Boolean> isCheckedOut;
    @NotNull
    private final MutableSharedFlow<CodeReviewBranches> _showBranchesRequests;
    @NotNull
    private final SharedFlow<CodeReviewBranches> showBranchesRequests;

    public GHPRBranchesViewModel(@NotNull CoroutineScope parentCs, @NotNull Project project, @NotNull GHPRBranchesModel branchesModel, @NotNull GHPRDetailsDataProvider detailsDataProvider) {
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)branchesModel, (String)"branchesModel");
        Intrinsics.checkNotNullParameter((Object)detailsDataProvider, (String)"detailsDataProvider");
        this.project = project;
        this.branchesModel = branchesModel;
        this.detailsDataProvider = detailsDataProvider;
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, null, (boolean)false, (int)3, null);
        Git git = Git.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance()");
        this.git = git;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<VcsNotifier> serviceClass$iv = VcsNotifier.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        this.vcsNotifier = (VcsNotifier)object;
        this._targetBranch = StateFlowKt.MutableStateFlow((Object)this.branchesModel.getBaseBranch());
        this._sourceBranch = StateFlowKt.MutableStateFlow((Object)this.branchesModel.getHeadBranch());
        this.sourceBranch = FlowKt.asStateFlow(this._sourceBranch);
        Flow flow = FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super Boolean>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ GHPRBranchesViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        cs = $this$callbackFlow = (ProducerScope)this.L$0;
                        this.L$0 = $this$callbackFlow;
                        this.L$1 = cs;
                        this.label = 1;
                        v0 = $this$callbackFlow.send((Object)Boxing.boxBoolean((boolean)GHPRBranchesViewModel.access$isBranchCheckedOut(this.this$0, GHPRBranchesViewModel.access$getBranchesModel$p(this.this$0).getLocalRepository(), (String)this.this$0.getSourceBranch().getValue())), (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        cs = (ProducerScope)this.L$1;
                        $this$callbackFlow = (ProducerScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        v1 = GHPRBranchesViewModel.access$getProject$p(this.this$0).getMessageBus().connect((CoroutineScope)cs);
                        v2 = GitRepository.GIT_REPO_CHANGE;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"GIT_REPO_CHANGE");
                        v1.subscribe(v2, (Object)(GitRepositoryChangeListener)LambdaMetafactory.metafactory(null, null, null, (Lgit4idea/repo/GitRepository;)V, invokeSuspend$lambda$0(kotlinx.coroutines.channels.ProducerScope org.jetbrains.plugins.github.pullrequest.ui.details.model.GHPRBranchesViewModel git4idea.repo.GitRepository ), (Lgit4idea/repo/GitRepository;)V)((ProducerScope)$this$callbackFlow, (GHPRBranchesViewModel)this.this$0));
                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 2;
                        v3 = GHPRBranchesViewModel.access$get_sourceBranch$p(this.this$0).collect(new FlowCollector((ProducerScope<? super Boolean>)$this$callbackFlow, this.this$0){
                            final /* synthetic */ ProducerScope<Boolean> $$this$callbackFlow;
                            final /* synthetic */ GHPRBranchesViewModel this$0;
                            {
                                this.$$this$callbackFlow = $$this$callbackFlow;
                                this.this$0 = $receiver;
                            }

                            @Nullable
                            public final Object emit(@NotNull String sourceBranch, @NotNull Continuation<? super Unit> $completion) {
                                Object object = this.$$this$callbackFlow.send((Object)Boxing.boxBoolean((boolean)GHPRBranchesViewModel.access$isBranchCheckedOut(this.this$0, GHPRBranchesViewModel.access$getBranchesModel$p(this.this$0).getLocalRepository(), sourceBranch)), $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v3 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl32:
                        // 2 sources

                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super Boolean> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(ProducerScope $$this$callbackFlow, GHPRBranchesViewModel this$0, GitRepository it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                $$this$callbackFlow.trySend-JP2dKIU((Object)GHPRBranchesViewModel.access$isBranchCheckedOut(this$0, it, (String)this$0.getSourceBranch().getValue()));
            }
        }));
        GHPRBranchesViewModel $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GHPRBranchesViewModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        this.isCheckedOut = CoroutineUtilKt.modelFlow((Flow)flow, (CoroutineScope)this.cs, (Logger)logger);
        this._showBranchesRequests = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.showBranchesRequests = (SharedFlow)this._showBranchesRequests;
        this.branchesModel.addAndInvokeChangeListener((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                _targetBranch.setValue((Object)branchesModel.getBaseBranch());
                _sourceBranch.setValue((Object)branchesModel.getHeadBranch());
            }
        }));
    }

    @NotNull
    public StateFlow<String> getSourceBranch() {
        return this.sourceBranch;
    }

    @NotNull
    public SharedFlow<Boolean> isCheckedOut() {
        return this.isCheckedOut;
    }

    @NotNull
    public SharedFlow<CodeReviewBranches> getShowBranchesRequests() {
        return this.showBranchesRequests;
    }

    public void fetchAndCheckoutRemoteBranch() {
        GHPullRequest pullRequest = (GHPullRequest)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.detailsDataProvider.loadDetails(), (ProgressIndicator)((ProgressIndicator)new EmptyProgressIndicator()));
        if (pullRequest.getAuthor() == null) {
            this.vcsNotifier.notifyError("github.pull.request.cannot.set.tracking.branch", GithubBundle.message("pull.request.branch.checkout.remote.cannot.find", new Object[0]), GithubBundle.message("pull.request.branch.checkout.resolve.author.failed", new Object[0]));
            return;
        }
        Project project = this.project;
        String string = GithubBundle.message("pull.request.branch.checkout.task.indicator", new Object[0]);
        new Task.Backgroundable(pullRequest, this, project, string){
            final /* synthetic */ GHPullRequest $pullRequest;
            final /* synthetic */ GHPRBranchesViewModel this$0;
            {
                this.$pullRequest = $pullRequest;
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                String headBranch = this.$pullRequest.getHeadRefName();
                GHPullRequest.HeadRepository headRepository = this.$pullRequest.getHeadRepository();
                String httpForkUrl = headRepository != null ? headRepository.getUrl() : null;
                GHPullRequest.HeadRepository headRepository2 = this.$pullRequest.getHeadRepository();
                String sshForkUrl = headRepository2 != null ? headRepository2.getSshUrl() : null;
                GHActor pullRequestAuthor = this.$pullRequest.getAuthor();
                GitRepository repository = GHPRBranchesViewModel.access$getBranchesModel$p(this.this$0).getLocalRepository();
                GitRemote headRemote = GHPRBranchesViewModel.access$findOrCreateRemote(this.this$0, GHPRBranchesViewModel.access$getGit$p(this.this$0), repository, pullRequestAuthor.getLogin(), httpForkUrl, sshForkUrl);
                if (headRemote == null) {
                    GHPRBranchesViewModel.access$notifyRemoteError(this.this$0, GHPRBranchesViewModel.access$getVcsNotifier$p(this.this$0), httpForkUrl, sshForkUrl);
                    return;
                }
                GitFetchResult gitFetchResult = GitFetchSupport.fetchSupport((Project)this.getProject()).fetch(repository, headRemote, headBranch);
                Intrinsics.checkNotNullExpressionValue((Object)gitFetchResult, (String)"fetchSupport(project).fe\u2026, headRemote, headBranch)");
                GitFetchResult fetchResult = gitFetchResult;
                if (fetchResult.showNotificationIfFailed(GitBundle.message((String)"branches.update.failed", (Object[])new Object[0]))) {
                    String branch = headRemote.getName() + "/" + headBranch;
                    ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, repository, branch){
                        final /* synthetic */ fetchAndCheckoutRemoteBranch.1 this$0;
                        final /* synthetic */ GitRepository $repository;
                        final /* synthetic */ String $branch;
                        {
                            this.this$0 = $receiver;
                            this.$repository = $repository;
                            this.$branch = $branch;
                            super(0);
                        }

                        public final void invoke() {
                            GitBranchPopupActions.RemoteBranchActions.CheckoutRemoteBranchAction.checkoutRemoteBranch((Project)this.this$0.getProject(), (List)CollectionsKt.listOf((Object)this.$repository), (String)this.$branch);
                            Project project = this.this$0.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                            GHPRStatisticsCollector.INSTANCE.logDetailsBranchCheckedOut(project);
                        }
                    }), (int)1, null);
                }
            }
        }.queue();
    }

    private final void notifyRemoteError(VcsNotifier vcsNotifier, String httpForkUrl, String sshForkUrl) {
        String string = GithubBundle.message("pull.request.branch.checkout.resolve.remote.failed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.br\u2026t.resolve.remote.failed\")");
        Object failedMessage = string;
        if (httpForkUrl != null) {
            failedMessage = (String)failedMessage + "\n" + httpForkUrl;
        }
        if (sshForkUrl != null) {
            failedMessage = (String)failedMessage + "\n" + sshForkUrl;
        }
        vcsNotifier.notifyError("github.pull.request.cannot.set.tracking.branch", GithubBundle.message("pull.request.branch.checkout.remote.cannot.find", new Object[0]), (String)failedMessage);
    }

    private final boolean isBranchCheckedOut(GitRepository repository, String sourceBranch) {
        String currentBranchName = repository.getCurrentBranchName();
        return Intrinsics.areEqual((Object)currentBranchName, (Object)sourceBranch);
    }

    private final GitRemote findOrCreateRemote(Git $this$findOrCreateRemote, GitRepository repository, String remoteName, String httpUrl, String sshUrl) {
        String sshOrHttpUrl;
        GitRemote existingRemote;
        GitRemote gitRemote = existingRemote = GithubGitHelper.Companion.getInstance().findRemote(repository, httpUrl, sshUrl);
        if (gitRemote != null) {
            return gitRemote;
        }
        boolean useSshUrl = GithubSettings.getInstance().isCloneGitUsingSsh();
        String string = sshOrHttpUrl = useSshUrl ? sshUrl : httpUrl;
        if (sshOrHttpUrl != null) {
            boolean bl;
            block6: {
                Collection collection = repository.getRemotes();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.remotes");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRemote it = (GitRemote)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)remoteName)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return this.createRemote($this$findOrCreateRemote, repository, "pull_" + remoteName, sshOrHttpUrl);
            }
        }
        return useSshUrl && sshUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, sshUrl) : (!useSshUrl && httpUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, httpUrl) : (sshUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, sshUrl) : (httpUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, httpUrl) : null)));
    }

    private final GitRemote createRemote(Git $this$createRemote, GitRepository repository, String remoteName, String url) {
        Object v1;
        block1: {
            GitRepository $this$createRemote_u24lambda_u242 = repository;
            boolean bl = false;
            $this$createRemote.addRemote($this$createRemote_u24lambda_u242, remoteName, url);
            $this$createRemote_u24lambda_u242.update();
            Collection collection = $this$createRemote_u24lambda_u242.getRemotes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"remotes");
            Iterable iterable = collection;
            for (Object t : iterable) {
                GitRemote it = (GitRemote)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)remoteName)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    public void showBranches() {
        CoroutineUtilKt.launchNow$default((CoroutineScope)this.cs, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GHPRBranchesViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        source = (String)GHPRBranchesViewModel.access$get_sourceBranch$p(this.this$0).getValue();
                        target = (String)GHPRBranchesViewModel.access$get_targetBranch$p(this.this$0).getValue();
                        this.label = 1;
                        v0 = GHPRBranchesViewModel.access$get_showBranchesRequests$p(this.this$0).emit((Object)new CodeReviewBranches(source, target), (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        GHPRStatisticsCollector.INSTANCE.logDetailsBranchesOpened(GHPRBranchesViewModel.access$getProject$p(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ GitRemote access$findOrCreateRemote(GHPRBranchesViewModel $this, Git $receiver, GitRepository repository, String remoteName, String httpUrl, String sshUrl) {
        return $this.findOrCreateRemote($receiver, repository, remoteName, httpUrl, sshUrl);
    }

    public static final /* synthetic */ Git access$getGit$p(GHPRBranchesViewModel $this) {
        return $this.git;
    }

    public static final /* synthetic */ void access$notifyRemoteError(GHPRBranchesViewModel $this, VcsNotifier vcsNotifier, String httpForkUrl, String sshForkUrl) {
        $this.notifyRemoteError(vcsNotifier, httpForkUrl, sshForkUrl);
    }

    public static final /* synthetic */ VcsNotifier access$getVcsNotifier$p(GHPRBranchesViewModel $this) {
        return $this.vcsNotifier;
    }

    public static final /* synthetic */ MutableSharedFlow access$get_showBranchesRequests$p(GHPRBranchesViewModel $this) {
        return $this._showBranchesRequests;
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRBranchesViewModel $this) {
        return $this.project;
    }

    public static final /* synthetic */ boolean access$isBranchCheckedOut(GHPRBranchesViewModel $this, GitRepository repository, String sourceBranch) {
        return $this.isBranchCheckedOut(repository, sourceBranch);
    }
}

