/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomCustomElement;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.CustomAntElementsRegistry;
import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.lang.ant.dom.PropertyExpander;
import com.intellij.lang.ant.dom.PropertyProviderFinder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.DomElement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class AntStringResolver
extends PropertyProviderFinder {
    private final PropertyExpander myExpander;
    private final boolean mySkipCustomTags;
    private static final Key<Map<String, String>> RESOLVED_STRINGS_MAP_KEY = Key.create((String)"_ant_resolved_strings_cache_");

    private AntStringResolver(DomElement contextElement, PropertyExpander expander) {
        super(contextElement);
        this.myExpander = expander;
        this.mySkipCustomTags = CustomAntElementsRegistry.ourIsBuildingClasspathForCustomTagLoading.get();
    }

    @Override
    public void visitAntDomCustomElement(AntDomCustomElement custom) {
        if (!this.mySkipCustomTags) {
            super.visitAntDomCustomElement(custom);
        }
    }

    @NotNull
    public static String computeString(final @NotNull DomElement context, @NotNull @NlsSafe String valueString) {
        PropertyExpander expander;
        if (context == null) {
            AntStringResolver.$$$reportNull$$$0(0);
        }
        if (valueString == null) {
            AntStringResolver.$$$reportNull$$$0(1);
        }
        if (!(expander = new PropertyExpander(valueString)).hasPropertiesToExpand()) {
            String string = valueString;
            if (string == null) {
                AntStringResolver.$$$reportNull$$$0(2);
            }
            return string;
        }
        Map cached = (Map)RESOLVED_STRINGS_MAP_KEY.get((UserDataHolder)context);
        if (cached != null) {
            expander.acceptProvider(new CachedPropertiesProvider(cached));
            if (!expander.hasPropertiesToExpand()) {
                String string = expander.getResult();
                if (string == null) {
                    AntStringResolver.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        expander.setPropertyExpansionListener(new PropertyExpander.PropertyExpansionListener(){

            @Override
            public void onPropertyExpanded(String propName, String propValue) {
                PropertyProviderFinder.cacheResult(context, RESOLVED_STRINGS_MAP_KEY, propName, propValue);
            }
        });
        AntDomProject project = (AntDomProject)context.getParentOfType(AntDomProject.class, false);
        if (project == null) {
            String string = expander.getResult();
            if (string == null) {
                AntStringResolver.$$$reportNull$$$0(4);
            }
            return string;
        }
        project = project.getContextAntProject();
        new AntStringResolver(context, expander).execute(project, project.getDefaultTarget().getRawText());
        String string = expander.getResult();
        if (string == null) {
            AntStringResolver.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    protected void propertyProviderFound(PropertiesProvider propertiesProvider) {
        this.myExpander.acceptProvider(propertiesProvider);
        if (!this.myExpander.hasPropertiesToExpand()) {
            this.stop();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/dom/AntStringResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/dom/AntStringResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class CachedPropertiesProvider
    implements PropertiesProvider,
    PropertiesProvider.SkipPropertyExpansionInValues {
        Set<String> allNames;
        private final Map<String, String> myCached;

        CachedPropertiesProvider(Map<String, String> cached) {
            this.myCached = cached;
        }

        @Override
        @NotNull
        public Iterator<String> getNamesIterator() {
            if (this.allNames == null) {
                this.allNames = new HashSet<String>(this.myCached.keySet());
            }
            Iterator<String> iterator = this.allNames.iterator();
            if (iterator == null) {
                CachedPropertiesProvider.$$$reportNull$$$0(0);
            }
            return iterator;
        }

        @Override
        public String getPropertyValue(String propertyName) {
            return this.myCached.get(propertyName);
        }

        @Override
        public PsiElement getNavigationElement(String propertyName) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntStringResolver$CachedPropertiesProvider", "getNamesIterator"));
        }
    }
}

