/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.actions;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.actions.TargetAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AntBuildGroup
extends ActionGroup
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AntBuildGroup.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(project != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AntBuildGroup.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                AntBuildGroup.$$$reportNull$$$0(2);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                AntBuildGroup.$$$reportNull$$$0(3);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ArrayList<DefaultActionGroup> children = new ArrayList<DefaultActionGroup>();
        AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(project);
        for (AntBuildFile antBuildFile : antConfiguration.getBuildFileList()) {
            String name = antBuildFile.getPresentableName();
            DefaultActionGroup subgroup = DefaultActionGroup.createUserDataAwareGroup((String)this.getTemplateText());
            subgroup.getTemplatePresentation().setText(name, false);
            subgroup.setPopup(true);
            AntBuildGroup.fillGroup(antBuildFile, subgroup, antConfiguration);
            if (subgroup.getChildrenCount() <= 0) continue;
            children.add(subgroup);
        }
        AnAction[] anActionArray = children.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            AntBuildGroup.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    private static void fillGroup(AntBuildFile buildFile, DefaultActionGroup group, AntConfiguration antConfiguration) {
        AntBuildModelBase model = (AntBuildModelBase)buildFile.getModel();
        if (model.getDefaultTargetName() != null) {
            DefaultActionGroup subgroup = new DefaultActionGroup();
            subgroup.add(AntBuildGroup.getOrCreateAction(buildFile, TargetAction.getDefaultTargetName(), Collections.singletonList(TargetAction.getDefaultTargetName()), null, model.getDefaultTargetActionId()));
            group.add((AnAction)subgroup);
        }
        HashSet addedTargetNames = new HashSet();
        AntBuildGroup.addGroupOfTargets(buildFile, model.getFilteredTargets(), addedTargetNames, group);
        AntBuildGroup.addGroupOfTargets(buildFile, antConfiguration.getMetaTargets(buildFile), addedTargetNames, group);
    }

    private static void addGroupOfTargets(AntBuildFile buildFile, AntBuildTarget[] targets, Set<? super String> addedTargetNames, DefaultActionGroup group) {
        DefaultActionGroup subgroup = new DefaultActionGroup();
        for (AntBuildTarget target : targets) {
            String displayName = target.getName();
            if (addedTargetNames.contains(displayName)) continue;
            addedTargetNames.add(displayName);
            subgroup.add(AntBuildGroup.getOrCreateAction(buildFile, displayName, target.getTargetNames(), target.getNotEmptyDescription(), ((AntBuildTargetBase)target).getActionId()));
        }
        if (subgroup.getChildrenCount() > 0) {
            group.add((AnAction)subgroup);
        }
    }

    private static AnAction getOrCreateAction(AntBuildFile buildFile, @NlsActions.ActionText String displayName, List<String> targets, @NlsActions.ActionDescription String targetDescription, String actionId) {
        Object action = null;
        if (actionId != null) {
            action = ActionManager.getInstance().getAction(actionId);
        }
        if (action == null) {
            action = new TargetAction(buildFile, displayName, targets, targetDescription);
        }
        return action;
    }

    public String getTemplateText() {
        return AntBundle.message("action.ant.build.group.text", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/config/actions/AntBuildGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/config/actions/AntBuildGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

