/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.IDEACoverageRunner;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageClassFilterEditor;
import com.intellij.execution.configurations.coverage.CoverageConfigurable;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.ui.NestedGroupFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class CoverageFragment<T extends RunConfigurationBase<?>>
extends NestedGroupFragment<T> {
    private final RunConfigurationBase<?> myConfiguration;

    public CoverageFragment(RunConfigurationBase<?> configuration) {
        super("coverage", JavaCoverageBundle.message("coverage.settings", new Object[0]), JavaCoverageBundle.message("coverage.settings.group", new Object[0]), p -> false);
        this.myConfiguration = configuration;
    }

    public String getChildrenGroupName() {
        return JavaCoverageBundle.message("coverage.settings.menu", new Object[0]);
    }

    protected List<SettingsEditorFragment<T, ?>> createChildren() {
        ArrayList fragments = new ArrayList();
        SettingsEditorFragment<T, CoverageClassFilterEditor> include = this.createFilterEditor("coverage.include", JavaCoverageBundle.message("record.coverage.filters.title", new Object[0]), true, JavaCoverageBundle.message("coverage.settings.include", new Object[0]));
        include.setActionHint(JavaCoverageBundle.message("show.coverage.data.only.in.specified.classes.and.packages", new Object[0]));
        fragments.add(include);
        SettingsEditorFragment<T, CoverageClassFilterEditor> exclude = this.createFilterEditor("coverage.exclude", JavaCoverageBundle.message("exclude.coverage.filters.title", new Object[0]), false, JavaCoverageBundle.message("coverage.settings.exclude", new Object[0]));
        exclude.setActionHint(JavaCoverageBundle.message("do.not.show.coverage.data.in.specified.classes.and.packages", new Object[0]));
        fragments.add(exclude);
        fragments.add(this.createRunnerFragment());
        SettingsEditorFragment tracing = SettingsEditorFragment.createTag((String)"coverage.tracing", (String)JavaCoverageBundle.message("coverage.settings.tracing", new Object[0]), null, t -> CoverageFragment.getConfiguration(t).isTracingEnabled(), (t, value) -> CoverageFragment.getConfiguration(t).setTracingEnabled((boolean)value));
        tracing.setActionHint(JavaCoverageBundle.message("enables.accurate.collection", new Object[0]));
        fragments.add(tracing);
        SettingsEditorFragment tests = SettingsEditorFragment.createTag((String)"coverage.test.folders", (String)JavaCoverageBundle.message("coverage.settings.test.folders", new Object[0]), null, t -> CoverageFragment.getConfiguration(t).isTrackTestFolders(), (t, value) -> CoverageFragment.getConfiguration(t).setTrackTestFolders((boolean)value));
        tests.setActionHint(JavaCoverageBundle.message("collect.code.coverage.statistics.for.tests", new Object[0]));
        fragments.add(tests);
        return fragments;
    }

    @NotNull
    private SettingsEditorFragment<T, CoverageClassFilterEditor> createFilterEditor(String id, @NotNull @Nls String message, boolean included, @NotNull @Nls String optionName) {
        if (message == null) {
            CoverageFragment.$$$reportNull$$$0(0);
        }
        if (optionName == null) {
            CoverageFragment.$$$reportNull$$$0(1);
        }
        CoverageClassFilterEditor filterEditor = new CoverageClassFilterEditor(this.myConfiguration.getProject());
        filterEditor.setBorder((Border)IdeBorderFactory.createTitledBorder((String)message, (boolean)false, (Insets)JBInsets.emptyInsets()));
        filterEditor.setupEasyFocusTraversing();
        return new SettingsEditorFragment(id, optionName, null, (JComponent)((Object)filterEditor), (p, editor) -> editor.setFilters(CoverageConfigurable.getCoveragePatterns(CoverageFragment.getConfiguration(p), included)), (p, editor) -> CoverageFragment.setCoveragePatterns(CoverageFragment.getConfiguration(p), this.isSelected() && filterEditor.isVisible() ? editor.getFilters() : ClassFilter.EMPTY_ARRAY, included), p -> CoverageConfigurable.getCoveragePatterns(CoverageFragment.getConfiguration(p), included).length > 0);
    }

    @NotNull
    private static JavaCoverageEnabledConfiguration getConfiguration(RunConfigurationBase<?> configuration) {
        JavaCoverageEnabledConfiguration javaCoverageEnabledConfiguration = (JavaCoverageEnabledConfiguration)CoverageEnabledConfiguration.getOrCreate(configuration);
        if (javaCoverageEnabledConfiguration == null) {
            CoverageFragment.$$$reportNull$$$0(2);
        }
        return javaCoverageEnabledConfiguration;
    }

    private static void setCoveragePatterns(JavaCoverageEnabledConfiguration configuration, ClassFilter[] filters, boolean included) {
        Object[] patterns = CoverageConfigurable.getCoveragePatterns(configuration, !included);
        for (ClassFilter filter : filters) {
            filter.INCLUDE = included;
        }
        configuration.setCoveragePatterns((ClassFilter[])ArrayUtil.mergeArrays((Object[])filters, (Object[])patterns));
    }

    private SettingsEditorFragment<T, ?> createRunnerFragment() {
        DefaultComboBoxModel<CoverageRunner> model = new DefaultComboBoxModel<CoverageRunner>();
        ComboBox comboBox = new ComboBox(model);
        JavaCoverageEngine provider = JavaCoverageEngine.getInstance();
        for (CoverageRunner runner : CoverageRunner.EP_NAME.getExtensionList()) {
            if (!runner.acceptsCoverageEngine((CoverageEngine)provider)) continue;
            model.addElement(runner);
        }
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", CoverageRunner::getPresentableName));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)comboBox, "West");
        LabeledComponent component = LabeledComponent.create((JComponent)panel, (String)JavaCoverageBundle.message("run.configuration.choose.coverage.runner", new Object[0]), (String)"West");
        SettingsEditorFragment fragment = new SettingsEditorFragment("coverage.runner", JavaCoverageBundle.message("coverage.settings.runner", new Object[0]), null, (JComponent)component, (t, c) -> comboBox.setItem((Object)CoverageFragment.getConfiguration(t).getCoverageRunner()), (t, c) -> CoverageFragment.getConfiguration(t).setCoverageRunner(this.isSelected() && component.isVisible() ? (CoverageRunner)comboBox.getItem() : (CoverageRunner)model.getElementAt(0)), t -> !(CoverageFragment.getConfiguration(t).getCoverageRunner() instanceof IDEACoverageRunner));
        fragment.setEditorGetter(c -> comboBox);
        fragment.setActionHint(JavaCoverageBundle.message("select.to.use.a.code.coverage.runner.other.than.the.built.in.one", new Object[0]));
        return fragment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/coverage/CoverageFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/coverage/CoverageFragment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFilterEditor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

