/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.xml;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.coverage.xml.XMLReportAnnotatorKt;
import com.intellij.coverage.xml.XMLReportSuite;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.report.XMLProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004JD\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/coverage/xml/XMLReportAnnotator;", "Lcom/intellij/coverage/JavaCoverageAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "addDirCoverage", "", "packageName", "", "fileName", "coverage", "Lcom/intellij/coverage/PackageAnnotator$ClassCoverageInfo;", "directoryCoverage", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/coverage/PackageAnnotator$PackageCoverageInfo;", "sourceRoots", "", "createRenewRequest", "Ljava/lang/Runnable;", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "dataManager", "Lcom/intellij/coverage/CoverageDataManager;", "getCoverageForClass", "classInfo", "Lcom/intellij/rt/coverage/report/XMLProjectData$ClassInfo;", "Companion", "intellij.java.coverage"})
@SourceDebugExtension(value={"SMAP\nXMLReportAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XMLReportAnnotator.kt\ncom/intellij/coverage/xml/XMLReportAnnotator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,129:1\n361#2,7:130\n361#2,7:144\n361#2,7:151\n361#2,7:158\n361#2,7:169\n26#3:137\n10242#4:138\n10664#4,5:139\n1477#5:165\n1502#5,3:166\n1505#5,3:176\n1855#5,2:180\n215#6:179\n216#6:182\n*S KotlinDebug\n*F\n+ 1 XMLReportAnnotator.kt\ncom/intellij/coverage/xml/XMLReportAnnotator\n*L\n82#1:130,7\n33#1:144,7\n43#1:151,7\n45#1:158,7\n53#1:169,7\n24#1:137\n25#1:138\n25#1:139,5\n53#1:165\n53#1:166,3\n53#1:176,3\n55#1:180,2\n53#1:179\n53#1:182\n*E\n"})
public final class XMLReportAnnotator
extends JavaCoverageAnnotator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public XMLReportAnnotator(@Nullable Project project) {
        super(project);
    }

    @Override
    @NotNull
    protected Runnable createRenewRequest(@NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)dataManager, (String)"dataManager");
        return () -> XMLReportAnnotator.createRenewRequest$lambda$8(this, dataManager, suite);
    }

    private final void addDirCoverage(String packageName2, String fileName, PackageAnnotator.ClassCoverageInfo coverage, Map<VirtualFile, PackageAnnotator.PackageCoverageInfo> directoryCoverage, List<? extends VirtualFile> sourceRoots) {
        if (fileName == null) {
            return;
        }
        String path = XMLReportSuite.Companion.getPath(packageName2, fileName);
        for (VirtualFile virtualFile : sourceRoots) {
            VirtualFile file = virtualFile.findFileByRelativePath(path);
            if (file == null) continue;
            for (file = file.getParent(); file != null; file = file.getParent()) {
                PackageAnnotator.PackageCoverageInfo packageCoverageInfo;
                Map<VirtualFile, PackageAnnotator.PackageCoverageInfo> $this$getOrPut$iv = directoryCoverage;
                boolean $i$f$getOrPut = false;
                PackageAnnotator.PackageCoverageInfo value$iv = $this$getOrPut$iv.get(file);
                if (value$iv == null) {
                    boolean bl = false;
                    PackageAnnotator.PackageCoverageInfo answer$iv = new PackageAnnotator.PackageCoverageInfo();
                    $this$getOrPut$iv.put(file, answer$iv);
                    packageCoverageInfo = answer$iv;
                } else {
                    packageCoverageInfo = value$iv;
                }
                packageCoverageInfo.append(coverage);
            }
        }
    }

    private final PackageAnnotator.ClassCoverageInfo getCoverageForClass(XMLProjectData.ClassInfo classInfo) {
        PackageAnnotator.ClassCoverageInfo coverage = new PackageAnnotator.ClassCoverageInfo();
        coverage.totalBranchCount = classInfo.coveredBranches + classInfo.missedBranches;
        coverage.coveredBranchCount = classInfo.coveredBranches;
        coverage.totalMethodCount = classInfo.coveredMethods + classInfo.missedMethods;
        coverage.coveredMethodCount = classInfo.coveredMethods;
        coverage.totalClassCount = coverage.totalMethodCount > 0 ? 1 : 0;
        coverage.coveredClassCount = classInfo.coveredMethods > 0 ? 1 : 0;
        coverage.totalLineCount = classInfo.coveredLines + classInfo.missedLines;
        coverage.fullyCoveredLineCount = classInfo.coveredLines;
        return coverage;
    }

    private static final Module[] createRenewRequest$lambda$8$lambda$0(CoverageSuitesBundle $suite) {
        Intrinsics.checkNotNullParameter((Object)$suite, (String)"$suite");
        Project project = $suite.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"suite.project");
        return ModuleManager.Companion.getInstance(project).getModules();
    }

    /*
     * WARNING - void declaration
     */
    private static final void createRenewRequest$lambda$8(XMLReportAnnotator this$0, CoverageDataManager $dataManager, CoverageSuitesBundle $suite) {
        PackageAnnotator.PackageCoverageInfo coverage;
        void $this$forEach$iv;
        Iterator $this$groupByTo$iv$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv2422;
        CoverageSuite[] $this$flatMap$iv;
        Module[] moduleArray;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dataManager, (String)"$dataManager");
        Intrinsics.checkNotNullParameter((Object)$suite, (String)"$suite");
        JavaCoverageAnnotator.JavaPackageAnnotator annotator = this$0.new JavaCoverageAnnotator.JavaPackageAnnotator();
        HashMap classCoverage = new HashMap();
        HashMap packageCoverage = new HashMap();
        HashMap flattenPackageCoverage = new HashMap();
        HashMap directoryCoverage = new HashMap();
        Object object = (Module[])$dataManager.doInReadActionIfProjectOpen(() -> XMLReportAnnotator.createRenewRequest$lambda$8$lambda$0($suite));
        if (object == null) {
            boolean bl = false;
            moduleArray = new Module[]{};
        } else {
            moduleArray = object;
        }
        object = moduleArray;
        boolean entry = false;
        void var11_18 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv2422).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv2422[i];
            boolean bl = false;
            VirtualFile[] virtualFileArray = OrderEnumerator.orderEntries((Module)it).withoutSdk().withoutLibraries().withoutDepModules().productionOnly().getSourceRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"orderEntries(it).without\u2026ductionOnly().sourceRoots");
            list$iv$iv = ArraysKt.toList((Object[])virtualFileArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List sourceRoots = (List)destination$iv$iv;
        CoverageSuite[] coverageSuiteArray = $suite.getSuites();
        Intrinsics.checkNotNullExpressionValue((Object)coverageSuiteArray, (String)"suite.suites");
        $this$flatMap$iv = coverageSuiteArray;
        entry = false;
        int $this$flatMapTo$iv$iv2422 = $this$flatMap$iv.length;
        while (entry < $this$flatMapTo$iv$iv2422) {
            CoverageSuite xmlSuite = $this$flatMap$iv[entry];
            if (xmlSuite instanceof XMLReportSuite && ((XMLReportSuite)xmlSuite).getReportData() != null) {
                XMLProjectData xmlReport;
                block2: for (XMLProjectData.ClassInfo classInfo : xmlReport.getClasses()) {
                    Object object2;
                    PackageAnnotator.PackageCoverageInfo answer$iv;
                    Object object3;
                    String key$iv;
                    void $this$getOrPut$iv;
                    list$iv$iv = classCoverage;
                    Intrinsics.checkNotNullExpressionValue((Object)classInfo.name, (String)"classInfo.name");
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        PackageAnnotator.ClassCoverageInfo answer$iv2 = new PackageAnnotator.ClassCoverageInfo();
                        $this$getOrPut$iv.put(key$iv, answer$iv2);
                        object3 = answer$iv2;
                    } else {
                        object3 = value$iv;
                    }
                    PackageAnnotator.ClassCoverageInfo currentCoverage = (PackageAnnotator.ClassCoverageInfo)object3;
                    Intrinsics.checkNotNullExpressionValue((Object)classInfo, (String)"classInfo");
                    PackageAnnotator.ClassCoverageInfo thisSuiteCoverage = this$0.getCoverageForClass(classInfo);
                    PackageAnnotator.ClassCoverageInfo coverage2 = XMLReportAnnotatorKt.access$minus(thisSuiteCoverage, currentCoverage);
                    currentCoverage.append(coverage2);
                    String string = classInfo.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classInfo.name");
                    String packageName3 = XMLReportAnnotatorKt.access$removeLastPart(string);
                    this$0.addDirCoverage(packageName3, classInfo.fileName, coverage2, directoryCoverage, sourceRoots);
                    Map $this$getOrPut$iv2 = flattenPackageCoverage;
                    boolean $i$f$getOrPut2 = false;
                    Object value$iv2 = $this$getOrPut$iv2.get(packageName3);
                    if (value$iv2 == null) {
                        boolean bl = false;
                        answer$iv = new PackageAnnotator.PackageCoverageInfo();
                        $this$getOrPut$iv2.put(packageName3, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv2;
                    }
                    ((PackageAnnotator.PackageCoverageInfo)object2).append(coverage2);
                    while (true) {
                        Object object4;
                        Map $this$getOrPut$iv3 = packageCoverage;
                        boolean $i$f$getOrPut3 = false;
                        Object value$iv3 = $this$getOrPut$iv3.get(packageName3);
                        if (value$iv3 == null) {
                            boolean bl = false;
                            answer$iv = new PackageAnnotator.PackageCoverageInfo();
                            $this$getOrPut$iv3.put(packageName3, answer$iv);
                            object4 = answer$iv;
                        } else {
                            object4 = value$iv3;
                        }
                        ((PackageAnnotator.PackageCoverageInfo)object4).append(coverage2);
                        if (((CharSequence)packageName3).length() == 0) continue block2;
                        packageName3 = XMLReportAnnotatorKt.access$removeLastPart(packageName3);
                    }
                }
            }
            ++entry;
        }
        Set set = classCoverage.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"classCoverage.entries");
        Object $this$groupBy$iv = set;
        boolean bl = false;
        Iterable $this$flatMapTo$iv$iv2422 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object5;
            Object element$iv$iv = iterator.next();
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            String key$iv$iv = PackageAnnotator.getSourceToplevelFQName((String)it.getKey());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv;
            }
            List list$iv$iv2 = (List)object5;
            list$iv$iv2.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean bl3 = false;
        $this$groupByTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry2 = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl4 = false;
            String className = (String)entry2.getKey();
            List classes = (List)entry2.getValue();
            PackageAnnotator.ClassCoverageInfo coverage3 = new PackageAnnotator.ClassCoverageInfo();
            Iterable $this$forEach$iv2 = classes;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map.Entry it = (Map.Entry)element$iv2;
                boolean bl32 = false;
                coverage3.append((PackageAnnotator.ClassCoverageInfo)it.getValue());
            }
            annotator.annotateClass(className, coverage3);
        }
        for (Map.Entry entry3 : ((Map)packageCoverage).entrySet()) {
            String packageName2 = (String)entry3.getKey();
            coverage = (PackageAnnotator.PackageCoverageInfo)entry3.getValue();
            annotator.annotatePackage(packageName2, coverage, false);
        }
        for (Map.Entry entry4 : ((Map)flattenPackageCoverage).entrySet()) {
            String packageName2 = (String)entry4.getKey();
            coverage = (PackageAnnotator.PackageCoverageInfo)entry4.getValue();
            annotator.annotatePackage(packageName2, coverage, true);
        }
        for (Map.Entry entry5 : ((Map)directoryCoverage).entrySet()) {
            VirtualFile file = (VirtualFile)entry5.getKey();
            coverage = (PackageAnnotator.PackageCoverageInfo)entry5.getValue();
            annotator.annotateSourceDirectory(file, coverage, null);
        }
        $dataManager.triggerPresentationUpdate();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/coverage/xml/XMLReportAnnotator$Companion;", "", "()V", "getInstance", "Lcom/intellij/coverage/xml/XMLReportAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.java.coverage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final XMLReportAnnotator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(XMLReportAnnotator.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(XMLReportAnnotator::class.java)");
            return (XMLReportAnnotator)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

