/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006H&J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/streams/resolve/PartialReductionResolverBase;", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver;", "()V", "buildResult", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver$Result;", "mapping", "", "Lcom/intellij/debugger/streams/trace/TraceElement;", "", "resolve", "info", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "intellij.java.debugger.streams"})
public abstract class PartialReductionResolverBase
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        List<TraceElement> valuesBefore = TraceUtil.sortedByTime(info.getValuesOrderBefore().values());
        List<TraceElement> valuesAfter = TraceUtil.sortedByTime(info.getValuesOrderAfter().values());
        Map reverseMapping = new LinkedHashMap();
        int i = 0;
        for (TraceElement valueAfter : valuesAfter) {
            List reverseList = new ArrayList();
            while (i + 1 < valuesBefore.size() && valuesBefore.get(i + 1).getTime() < valueAfter.getTime()) {
                ((Collection)reverseList).add(valuesBefore.get(i));
                ++i;
            }
            Intrinsics.checkNotNullExpressionValue((Object)valueAfter, (String)"valueAfter");
            reverseMapping.put(valueAfter, reverseList);
        }
        Intrinsics.checkNotNullExpressionValue(valuesAfter, (String)"valuesAfter");
        if (!((Collection)valuesAfter).isEmpty()) {
            Intrinsics.checkNotNullExpressionValue(valuesBefore, (String)"valuesBefore");
            if (!((Collection)valuesBefore).isEmpty()) {
                Object v = reverseMapping.get(CollectionsKt.last(valuesAfter));
                Intrinsics.checkNotNull(v);
                ((Collection)v).add(CollectionsKt.last(valuesBefore));
            }
        }
        return this.buildResult(reverseMapping);
    }

    @NotNull
    public abstract ValuesOrderResolver.Result buildResult(@NotNull Map<TraceElement, ? extends List<? extends TraceElement>> var1);
}

