/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays;

import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.Point;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"VIEWPORT_INLAY_RANGE", "", "calculateInlayExpansionRange", "Lkotlin/ranges/IntRange;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "viewportRange", "calculateViewportRange", "intellij.notebooks.visualization"})
public final class InlayEditorManagerKt {
    public static final int VIEWPORT_INLAY_RANGE = 20;

    @NotNull
    public static final IntRange calculateViewportRange(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JViewport viewport = editor.getScrollPane().getViewport();
        int yMin = viewport.getViewPosition().y;
        int yMax = yMin + viewport.getHeight();
        return RangesKt.until((int)yMin, (int)yMax);
    }

    @NotNull
    public static final IntRange calculateInlayExpansionRange(@NotNull EditorImpl editor, @NotNull IntRange viewportRange) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)viewportRange, (String)"viewportRange");
        int startLine = editor.xyToLogicalPosition((Point)new Point((int)0, (int)viewportRange.getFirst())).line;
        int endLine = editor.xyToLogicalPosition((Point)new Point((int)0, (int)(viewportRange.getLast() + 1))).line;
        int startOffset = editor.getDocument().getLineStartOffset(Math.max(startLine - 20, 0));
        int endOffset = editor.getDocument().getLineStartOffset(Math.max(Math.min(endLine + 20, editor.getDocument().getLineCount() - 1), 0));
        return new IntRange(startOffset, endOffset);
    }
}

