/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.utils;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00040\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/fileActions/utils/GoogleCommonUtils;", "", "()V", "runProcessWithGoogleCredentials", "T", "project", "Lcom/intellij/openapi/project/Project;", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "process", "Lkotlin/Function1;", "(Lcom/intellij/openapi/project/Project;Lcom/google/api/client/auth/oauth2/Credential;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.markdown.core"})
public final class GoogleCommonUtils {
    @NotNull
    public static final GoogleCommonUtils INSTANCE = new GoogleCommonUtils();

    private GoogleCommonUtils() {
    }

    @Nullable
    public final <T> T runProcessWithGoogleCredentials(@NotNull Project project, @NotNull Credential credential, @NotNull Function1<? super Credential, ? extends T> process) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Intrinsics.checkNotNullParameter(process, (String)"process");
        try {
            return (T)process.invoke((Object)credential);
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 401) {
                GoogleCredentials googleCredentials = GoogleAccountsUtils.INSTANCE.tryToReLogin(project);
                if (googleCredentials == null) {
                    return null;
                }
                GoogleCredentials accountCredentials = googleCredentials;
                Credential newCredential = GoogleAccountsUtils.INSTANCE.createCredentialsForGoogleApi(accountCredentials);
                return this.runProcessWithGoogleCredentials(project, newCredential, process);
            }
            throw e;
        }
    }
}

