/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.mermaid;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.extensions.jcef.mermaid.MermaidPluginAdvertisementKt;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidCodeFenceLanguageProvider;", "Lorg/intellij/plugins/markdown/injection/CodeFenceLanguageProvider;", "()V", "getCompletionVariantsForInfoString", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "getLanguageByInfoString", "Lcom/intellij/lang/Language;", "infoString", "", "Companion", "intellij.markdown.core"})
public final class MermaidCodeFenceLanguageProvider
implements CodeFenceLanguageProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MERMAID = "mermaid";

    @Override
    @Nullable
    public Language getLanguageByInfoString(@NotNull String infoString) {
        Intrinsics.checkNotNullParameter((Object)infoString, (String)"infoString");
        if (MermaidPluginAdvertisementKt.isMermaidPluginInstalled()) {
            return null;
        }
        return Companion.isMermaidInfoString$intellij_markdown_core(infoString) ? Companion.obtainMermaidLanguage$intellij_markdown_core() : null;
    }

    @Override
    @NotNull
    public List<LookupElement> getCompletionVariantsForInfoString(@NotNull CompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (MermaidPluginAdvertisementKt.isMermaidPluginInstalled()) {
            return CollectionsKt.emptyList();
        }
        Project project = parameters.getOriginalFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parameters.originalFile.project");
        Project project2 = project;
        Language language = Companion.obtainMermaidLanguage$intellij_markdown_core();
        LanguageFileType languageFileType = language.getAssociatedFileType();
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)MERMAID).withIcon(languageFileType != null ? languageFileType.getIcon() : null).withInsertHandler((arg_0, arg_1) -> MermaidCodeFenceLanguageProvider.getCompletionVariantsForInfoString$lambda$0(project2, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(MERMAID)\n      .w\u2026eMermaidPlugin(project) }");
        LookupElementBuilder lookupElement = lookupElementBuilder;
        return CollectionsKt.listOf((Object)lookupElement);
    }

    private static final void getCompletionVariantsForInfoString$lambda$0(Project $project, InsertionContext insertionContext, LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<anonymous parameter 1>");
        MermaidPluginAdvertisementKt.advertiseMermaidPlugin($project);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\bJ\r\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidCodeFenceLanguageProvider$Companion;", "", "()V", "MERMAID", "", "isMermaidInfoString", "", "infoString", "isMermaidInfoString$intellij_markdown_core", "obtainMermaidLanguage", "Lcom/intellij/lang/Language;", "obtainMermaidLanguage$intellij_markdown_core", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isMermaidInfoString$intellij_markdown_core(@NotNull String infoString) {
            Intrinsics.checkNotNullParameter((Object)infoString, (String)"infoString");
            return Intrinsics.areEqual((Object)infoString, (Object)MermaidCodeFenceLanguageProvider.MERMAID);
        }

        @NotNull
        public final Language obtainMermaidLanguage$intellij_markdown_core() {
            Language existingLanguage = Language.findLanguageByID((String)"Mermaid");
            Language language = existingLanguage;
            if (language == null) {
                PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"INSTANCE");
                language = (Language)plainTextLanguage;
            }
            return language;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

