/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.toc;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/editor/toc/OutdatedTableOfContentsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkFile", "", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "UpdateTocSectionQuickFix", "intellij.markdown.core"})
public final class OutdatedTableOfContentsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MarkdownElementVisitor(this, holder){
            final /* synthetic */ OutdatedTableOfContentsInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitMarkdownFile(@NotNull MarkdownFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                super.visitMarkdownFile(file);
                OutdatedTableOfContentsInspection.access$checkFile(this.this$0, file, this.$holder);
            }
        };
    }

    private final void checkFile(MarkdownFile file, ProblemsHolder holder) {
        List existingRanges = SequencesKt.toList(GenerateTableOfContentsAction.Companion.findExistingTocs(file));
        if (existingRanges.isEmpty()) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
        if (document == null) {
            return;
        }
        Document document2 = document;
        String expectedToc = GenerateTableOfContentsAction.Companion.obtainToc(file);
        for (TextRange range : CollectionsKt.asReversed((List)existingRanges)) {
            String text2;
            Intrinsics.checkNotNullExpressionValue((Object)document2.getText(range), (String)"document.getText(range)");
            if (Intrinsics.areEqual((Object)text2, (Object)expectedToc)) continue;
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new UpdateTocSectionQuickFix(expectedToc)};
            holder.registerProblem((PsiElement)file, MarkdownBundle.message("markdown.outdated.table.of.contents.inspection.description", new Object[0]), ProblemHighlightType.WARNING, range, localQuickFixArray);
        }
    }

    public static final /* synthetic */ void access$checkFile(OutdatedTableOfContentsInspection $this, MarkdownFile file, ProblemsHolder holder) {
        $this.checkFile(file, holder);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/editor/toc/OutdatedTableOfContentsInspection$UpdateTocSectionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "expectedToc", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "intellij.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nOutdatedTableOfContentsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutdatedTableOfContentsInspection.kt\norg/intellij/plugins/markdown/editor/toc/OutdatedTableOfContentsInspection$UpdateTocSectionQuickFix\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,66:1\n8#2:67\n*S KotlinDebug\n*F\n+ 1 OutdatedTableOfContentsInspection.kt\norg/intellij/plugins/markdown/editor/toc/OutdatedTableOfContentsInspection$UpdateTocSectionQuickFix\n*L\n58#1:67\n*E\n"})
    private static final class UpdateTocSectionQuickFix
    implements LocalQuickFix {
        @NotNull
        private final String expectedToc;

        public UpdateTocSectionQuickFix(@NotNull String expectedToc) {
            Intrinsics.checkNotNullParameter((Object)expectedToc, (String)"expectedToc");
            this.expectedToc = expectedToc;
        }

        @NotNull
        public String getName() {
            String string = MarkdownBundle.message("markdown.outdated.table.of.contents.quick.fix.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"markdown.outdat\u2026contents.quick.fix.name\")");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = MarkdownBundle.message("markdown.inspection.group.ruby.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"markdown.inspection.group.ruby.name\")");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Object object = descriptor.getPsiElement();
            PsiFile file = object instanceof PsiFile ? (PsiFile)object : null;
            if (file == null) {
                object = "Required value was null.";
                throw new IllegalStateException(object.toString());
            }
            Document document = file.getViewProvider().getDocument();
            if (document == null) {
                UpdateTocSectionQuickFix $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(UpdateTocSectionQuickFix.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.error("Failed to find document for the quick fix");
                return;
            }
            TextRange range = descriptor.getTextRangeInElement();
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)this.expectedToc);
        }
    }
}

