/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.ui.FlatSpeedSearchPopup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserFilterPopupComponent
extends MultipleValueFilterPopupComponent<VcsLogUserFilter, FilterModel.SingleFilterModel<VcsLogUserFilter>> {
    @NotNull
    private final VcsLogData myLogData;

    UserFilterPopupComponent(@NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogData logData, @NotNull FilterModel.SingleFilterModel<VcsLogUserFilter> filterModel) {
        if (uiProperties == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(1);
        }
        if (filterModel == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(2);
        }
        super("User", VcsLogBundle.messagePointer("vcs.log.user.filter.label", new Object[0]), uiProperties, filterModel);
        this.myLogData = logData;
    }

    @Override
    @NotNull
    protected ActionGroup createActionGroup() {
        ArrayList<Object> group2 = new ArrayList<Object>();
        group2.add(this.createSelectMultipleValuesAction());
        if (!this.myLogData.getCurrentUser().isEmpty()) {
            group2.add((Object)new MultipleValueFilterPopupComponent.PredefinedValueAction(this, Collections.singletonList("*"), () -> UserFilterPopupComponent.me(), true));
        }
        group2.addAll(this.createRecentItemsActionGroup());
        return new DefaultActionGroup(group2);
    }

    @NotNull
    protected ActionGroup createSpeedSearchActionGroup() {
        ArrayList<SpeedsearchPredefinedValueAction> group2 = new ArrayList<SpeedsearchPredefinedValueAction>();
        group2.add(new SpeedsearchPredefinedValueAction("*", () -> UserFilterPopupComponent.me()));
        group2.add((SpeedsearchPredefinedValueAction)Separator.getInstance());
        for (String user : UserFilterPopupComponent.collectUsers(this.myLogData)) {
            group2.add(new SpeedsearchPredefinedValueAction(user, () -> user));
        }
        return new DefaultActionGroup(group2);
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        List list = ContainerUtil.concat(Collections.singletonList(UserFilterPopupComponent.me()), UserFilterPopupComponent.collectUsers(this.myLogData));
        if (list == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    protected ListPopup createPopupMenu() {
        ActionGroup actionGroup = this.createActionGroup();
        ActionGroup speedsearchGroup = this.createSpeedSearchActionGroup();
        return new UserLogSpeedSearchPopup(new DefaultActionGroup(new AnAction[]{actionGroup, speedsearchGroup}), DataManager.getInstance().getDataContext((Component)((Object)this)));
    }

    @Override
    @Nullable
    protected VcsLogUserFilter createFilter(@NotNull List<String> values2) {
        if (values2 == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(4);
        }
        return (VcsLogUserFilter)((FilterModel.SingleFilterModel)this.myFilterModel).createFilter(values2);
    }

    @Override
    @NotNull
    protected List<String> getFilterValues(@NotNull VcsLogUserFilter filter2) {
        if (filter2 == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(5);
        }
        List<String> list = ((FilterModel.SingleFilterModel)this.myFilterModel).getFilterValues(filter2);
        if (list == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<String> parseLocalizedValues(@NotNull Collection<String> values2) {
        if (values2 == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.map(values2, user -> user.equals(UserFilterPopupComponent.me()) ? "*" : user);
        if (list == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<String> getLocalizedValues(@NotNull Collection<String> values2) {
        if (values2 == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.map(values2, user -> user.equals("*") ? UserFilterPopupComponent.me() : user);
        if (list == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static String me() {
        String string2 = VcsLogBundle.message("vcs.log.user.filter.me", new Object[0]);
        if (string2 == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    private static List<String> collectUsers(@NotNull VcsLogData logData) {
        if (logData == null) {
            UserFilterPopupComponent.$$$reportNull$$$0(12);
        }
        List users = ContainerUtil.map(logData.getAllUsers(), user -> {
            String shortPresentation = VcsUserUtil.getShortPresentation(user);
            Couple<String> firstAndLastName = VcsUserUtil.getFirstAndLastName(shortPresentation);
            if (firstAndLastName == null) {
                return shortPresentation;
            }
            return VcsUserUtil.capitalizeName((String)firstAndLastName.first) + " " + VcsUserUtil.capitalizeName((String)firstAndLastName.second);
        });
        TreeSet sortedUniqueUsers = new TreeSet(users);
        return new ArrayList<String>(sortedUniqueUsers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterModel";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLocalizedValues";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalizedValues";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "me";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFilter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilterValues";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseLocalizedValues";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLocalizedValues";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectUsers";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 6, 8, 10, 11 -> new IllegalStateException(string2);
        };
    }

    private class SpeedsearchPredefinedValueAction
    extends MultipleValueFilterPopupComponent.PredefinedValueAction
    implements FlatSpeedSearchPopup.SpeedsearchAction {
        SpeedsearchPredefinedValueAction(@NotNull String user, Supplier<String> supplier2) {
            if (user == null) {
                SpeedsearchPredefinedValueAction.$$$reportNull$$$0(0);
            }
            if (supplier2 == null) {
                SpeedsearchPredefinedValueAction.$$$reportNull$$$0(1);
            }
            super(UserFilterPopupComponent.this, Collections.singletonList(user), supplier2, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "user";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "supplier";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$SpeedsearchPredefinedValueAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UserLogSpeedSearchPopup
    extends FlatSpeedSearchPopup {
        UserLogSpeedSearchPopup(@NotNull DefaultActionGroup actionGroup, @NotNull DataContext dataContext) {
            if (actionGroup == null) {
                UserLogSpeedSearchPopup.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                UserLogSpeedSearchPopup.$$$reportNull$$$0(1);
            }
            super(null, (ActionGroup)actionGroup, dataContext, null, false);
            this.setMinimumSize((Dimension)new JBDimension(200, 0));
        }

        @Override
        public boolean shouldBeShowing(@NotNull AnAction action2) {
            if (action2 == null) {
                UserLogSpeedSearchPopup.$$$reportNull$$$0(2);
            }
            if (!super.shouldBeShowing(action2)) {
                return false;
            }
            if (this.getSpeedSearch().isHoldingFilter()) {
                if (action2 instanceof MultipleValueFilterPopupComponent.PredefinedValueAction) {
                    return action2 instanceof FlatSpeedSearchPopup.SpeedsearchAction || ((MultipleValueFilterPopupComponent.PredefinedValueAction)action2).myValues.size() > 1;
                }
                return true;
            }
            return !UserLogSpeedSearchPopup.isSpeedsearchAction(action2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent$UserLogSpeedSearchPopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldBeShowing";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

