/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.ProjectLevelConnectionManager;
import com.intellij.vcs.log.data.index.SqliteVcsLogStorageBackend;
import com.intellij.vcs.log.data.index.SqliteVcsLogStorageBackendKt;
import com.intellij.vcs.log.data.index.SqliteVcsLogWriter;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.data.index.VcsLogWriter;
import com.intellij.vcs.log.data.index.VcsRefTypeSerializer;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.impl.VcsRefImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.sqlite.Binder;
import org.jetbrains.sqlite.EmptyBinder;
import org.jetbrains.sqlite.IntBinder;
import org.jetbrains.sqlite.ObjectBinder;
import org.jetbrains.sqlite.SqliteConnection;
import org.jetbrains.sqlite.SqlitePreparedStatement;
import org.jetbrains.sqlite.SqliteResultSet;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J:\u0010.\u001a\f\u0012\u0006\u0012\u0004\u0018\u000100\u0018\u00010/2\u0006\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u0002002\u0006\u00105\u001a\u00020\u0015H\u0016J\b\u00106\u001a\u000207H\u0016J\u0012\u00108\u001a\u0004\u0018\u0001092\u0006\u0010*\u001a\u00020+H\u0016J\"\u0010:\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002090\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020+0;H\u0016J*\u0010<\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002090\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020+0;2\u0006\u0010=\u001a\u00020\u0015H\u0002J\"\u0010>\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020?0\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020+0@H\u0016J\u0012\u0010A\u001a\u0004\u0018\u00010)2\u0006\u0010B\u001a\u00020+H\u0016J\u001f\u0010A\u001a\u0004\u0018\u00010+2\u0006\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020EH\u0002\u00a2\u0006\u0002\u0010FJ\"\u0010G\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020)0\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020+0@H\u0016J\u0018\u0010H\u001a\u00020+2\u0006\u0010D\u001a\u00020E2\u0006\u00103\u001a\u00020\u0007H\u0016J\"\u0010I\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020?0\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020+0@H\u0016J8\u0010J\u001a\u0002072\u0006\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010%2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020L0O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0016J\u0016\u0010T\u001a\u00020%2\f\u0010U\u001a\b\u0012\u0004\u0012\u0002090VH\u0016J\u001a\u0010W\u001a\u0004\u0018\u0001092\u0006\u0010*\u001a\u00020+2\u0006\u0010X\u001a\u00020+H\u0002J\"\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002090\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020+0;H\u0016J\u0012\u0010Z\u001a\u0004\u0018\u0001092\u0006\u0010*\u001a\u00020+H\u0016J\u0012\u0010[\u001a\u0004\u0018\u00010L2\u0006\u0010*\u001a\u00020+H\u0016J\"\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020L0\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020+0@H\u0016J\u0010\u0010]\u001a\u00020^2\u0006\u0010*\u001a\u00020+H\u0016J(\u0010]\u001a\u0014\u0012\u0004\u0012\u00020+\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0\u001d0\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020+0@H\u0016J\u0012\u0010_\u001a\u0004\u0018\u00010`2\u0006\u0010a\u001a\u00020+H\u0002J\u001f\u0010b\u001a\u0004\u0018\u00010+2\u0006\u00103\u001a\u00020\u00072\u0006\u0010c\u001a\u00020LH\u0002\u00a2\u0006\u0002\u0010dJ\u0010\u0010b\u001a\u00020+2\u0006\u0010e\u001a\u00020`H\u0002J\u0018\u0010f\u001a\u00020+2\u0006\u00103\u001a\u00020\u00072\u0006\u0010c\u001a\u00020LH\u0002J\b\u0010g\u001a\u00020hH\u0016J\u0010\u0010i\u001a\u00020+2\u0006\u0010j\u001a\u00020kH\u0016J\u0018\u0010l\u001a\u00020^2\u0006\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020+H\u0016J*\u0010m\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020?0\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020+0@2\u0006\u0010n\u001a\u00020\u0015H\u0002J\u0012\u0010o\u001a\u0004\u0018\u00010p2\u0006\u0010*\u001a\u00020+H\u0016J\u0012\u0010q\u001a\u0004\u0018\u00010k2\u0006\u0010r\u001a\u00020+H\u0016J,\u0010s\u001a\u0002072\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u0002002\u0012\u0010P\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020u0\u001d0tH\u0016J\u0018\u0010v\u001a\u0002072\u000e\u0010P\u001a\n\u0012\u0006\b\u0000\u0012\u00020)0wH\u0016J\u001e\u0010x\u001a\u0002072\u0006\u0010y\u001a\u00020+2\f\u0010z\u001a\b\u0012\u0004\u0012\u00020\u00150{H\u0016J\b\u0010|\u001a\u000207H\u0016J\"\u0010}\u001a\u0002072\u0018\u0010z\u001a\u0014\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020\u00150~H\u0016R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u007f"}, d2={"Lcom/intellij/vcs/log/data/index/SqliteVcsLogStorageBackend;", "Lcom/intellij/vcs/log/data/index/VcsLogStorageBackend;", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "project", "Lcom/intellij/openapi/project/Project;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "errorHandler", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;Lcom/intellij/openapi/Disposable;)V", "connection", "Lorg/jetbrains/sqlite/SqliteConnection;", "getConnection", "()Lorg/jetbrains/sqlite/SqliteConnection;", "connectionManager", "Lcom/intellij/vcs/log/data/index/ProjectLevelConnectionManager;", "value", "", "isFresh", "()Z", "setFresh", "(Z)V", "rootsToPosition", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "sortedRoots", "", "storageId", "Lcom/intellij/vcs/log/util/StorageId$File;", "getStorageId", "()Lcom/intellij/vcs/log/util/StorageId$File;", "userRegistry", "Lcom/intellij/vcs/log/VcsUserRegistry;", "collectMissingCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "commitIds", "containsCommit", "id", "Lcom/intellij/vcs/log/CommitId;", "commitId", "", "createWriter", "Lcom/intellij/vcs/log/data/index/VcsLogWriter;", "findRename", "Lcom/intellij/vcs/log/history/EdgeData;", "Lcom/intellij/openapi/vcs/FilePath;", "parent", "child", "root", "path", "isChildPath", "flush", "", "getAuthorForCommit", "Lcom/intellij/vcs/log/VcsUser;", "getAuthorForCommits", "", "getAuthorOrCommitter", "isAuthor", "getAuthorTime", "", "", "getCommitId", "commitIndex", "position", "hash", "Lcom/intellij/vcs/log/Hash;", "(ILcom/intellij/vcs/log/Hash;)Ljava/lang/Integer;", "getCommitIds", "getCommitIndex", "getCommitTime", "getCommitsForSubstring", "string", "", "candidates", "noTrigramSources", "", "consumer", "Ljava/util/function/IntConsumer;", "filter", "Lcom/intellij/vcs/log/VcsLogTextFilter;", "getCommitsForUsers", "users", "", "getCommitterForCommit", "isCommitter", "getCommitterForCommits", "getCommitterOrAuthorForCommit", "getMessage", "getMessages", "getParents", "", "getPath", "Lcom/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePath;", "pathId", "getPathId", "relativePath", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)Ljava/lang/Integer;", "filePath", "getPathIdOrFail", "getPathsEncoder", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$PathsEncoder;", "getRefIndex", "ref", "Lcom/intellij/vcs/log/VcsRef;", "getRename", "getTime", "isAuthorTime", "getTimestamp", "", "getVcsRef", "refIndex", "iterateChangesInCommits", "Ljava/util/function/ObjIntConsumer;", "Lcom/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKind;", "iterateCommits", "Ljava/util/function/Predicate;", "iterateIndexedCommits", "limit", "processor", "Ljava/util/function/IntFunction;", "markCorrupted", "processMessages", "Lkotlin/Function2;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nSqliteVcsLogStorageBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteVcsLogStorageBackend.kt\ncom/intellij/vcs/log/data/index/SqliteVcsLogStorageBackend\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,823:1\n29#2,3:824\n1864#3,3:827\n1#4:830\n*S KotlinDebug\n*F\n+ 1 SqliteVcsLogStorageBackend.kt\ncom/intellij/vcs/log/data/index/SqliteVcsLogStorageBackend\n*L\n164#1:824,3\n169#1:827,3\n*E\n"})
public final class SqliteVcsLogStorageBackend
implements VcsLogStorageBackend,
VcsLogStorage {
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    @NotNull
    private final VcsLogErrorHandler errorHandler;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private volatile ProjectLevelConnectionManager connectionManager;
    @NotNull
    private final VcsUserRegistry userRegistry;
    @NotNull
    private final List<VirtualFile> sortedRoots;
    @NotNull
    private final Object2IntOpenHashMap<VirtualFile> rootsToPosition;

    /*
     * WARNING - void declaration
     */
    public SqliteVcsLogStorageBackend(@NotNull Project project2, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull VcsLogErrorHandler errorHandler2, @NotNull Disposable disposable) {
        void it;
        ProjectLevelConnectionManager projectLevelConnectionManager;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter((Object)errorHandler2, (String)"errorHandler");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.logProviders = logProviders;
        this.errorHandler = errorHandler2;
        this.disposable = disposable;
        ProjectLevelConnectionManager projectLevelConnectionManager2 = projectLevelConnectionManager = new ProjectLevelConnectionManager(project2, PersistentUtil.calcLogId(project2, this.logProviders));
        SqliteVcsLogStorageBackend sqliteVcsLogStorageBackend = this;
        boolean bl = false;
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)it));
        sqliteVcsLogStorageBackend.connectionManager = projectLevelConnectionManager;
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service22 = false;
        Class<VcsUserRegistry> serviceClass$iv = VcsUserRegistry.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        this.userRegistry = (VcsUserRegistry)object;
        Iterable iterable = this.logProviders.keySet();
        Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> SqliteVcsLogStorageBackend.sortedRoots$lambda$1(sortedRoots.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing(VirtualFile::getPath)");
        this.sortedRoots = CollectionsKt.sortedWith((Iterable)iterable, comparator2);
        ProjectLevelConnectionManager $i$f$service22 = projectLevelConnectionManager = new Object2IntOpenHashMap();
        sqliteVcsLogStorageBackend = this;
        boolean bl2 = false;
        Iterable $this$forEachIndexed$iv = this.sortedRoots;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void root;
            void $this$rootsToPosition_u24lambda_u243;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VirtualFile virtualFile = (VirtualFile)item$iv;
            int index = n;
            boolean bl3 = false;
            $this$rootsToPosition_u24lambda_u243.put((Object)root, index);
        }
        sqliteVcsLogStorageBackend.rootsToPosition = projectLevelConnectionManager;
    }

    @Override
    @NotNull
    public StorageId.File getStorageId() {
        return this.connectionManager.storageId;
    }

    @Override
    public boolean isFresh() {
        return this.connectionManager.isFresh();
    }

    @Override
    public void setFresh(boolean value2) {
        this.connectionManager.setFresh(value2);
    }

    private final SqliteConnection getConnection() {
        return this.connectionManager.connection;
    }

    @Override
    @NotNull
    public VcsLogWriter createWriter() {
        return new SqliteVcsLogWriter(this.getConnection(), this);
    }

    @Override
    public boolean containsCommit(int commitId2) {
        return this.getConnection().selectBoolean("select exists(select 1 from log where commitId = ?)", (Object)commitId2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IntSet collectMissingCommits(@NotNull IntSet commitIds) {
        Intrinsics.checkNotNullParameter((Object)commitIds, (String)"commitIds");
        IntOpenHashSet missing = new IntOpenHashSet();
        IntBinder batch = new IntBinder(1, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement("select exists (select commitId from log where commitId = ?)", (Binder)batch);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            commitIds.forEach(arg_0 -> SqliteVcsLogStorageBackend.collectMissingCommits$lambda$5$lambda$4(batch, statement, missing, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (IntSet)missing;
    }

    @Override
    public void iterateIndexedCommits(int limit, @NotNull IntFunction<Boolean> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        this.connectionManager.runUnderReadonlyConnection((Function1)new Function1<SqliteConnection, Unit>(limit, processor2){
            final /* synthetic */ int $limit;
            final /* synthetic */ IntFunction<Boolean> $processor;
            {
                this.$limit = $limit;
                this.$processor = $processor;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull SqliteConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                String limitClause = this.$limit > 0 ? " limit " + this.$limit : "";
                AutoCloseable autoCloseable = (AutoCloseable)connection.prepareStatement("select commitId from log" + limitClause, (Binder)new IntBinder(0, 0, 2, null));
                IntFunction<Boolean> intFunction = this.$processor;
                Throwable throwable = null;
                try {
                    SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
                    boolean bl = false;
                    SqliteResultSet rs = statement.executeQuery();
                    while (rs.next()) {
                        if (intFunction.apply(rs.getInt(0)).booleanValue()) continue;
                        return;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
        });
    }

    @Override
    @Nullable
    public String getMessage(int commitId2) {
        return this.getConnection().selectString("select message from log where commitId = ?", (Object)commitId2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<Integer, String> getMessages(@NotNull Collection<Integer> commitIds) {
        Intrinsics.checkNotNullParameter(commitIds, (String)"commitIds");
        HashMap<Integer, String> result2 = new HashMap<Integer, String>();
        ObjectBinder paramBinder = new ObjectBinder(0, 0, 2, null);
        String inClause = SqliteVcsLogStorageBackendKt.access$toInClause(commitIds);
        String sql = "select commitId, message from log where commitId in " + inClause;
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement(sql, (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                int commitId2 = rs.getInt(0);
                Integer n = commitId2;
                String string2 = rs.getString(1);
                Intrinsics.checkNotNull((Object)string2);
                result2.put(n, string2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public VcsUser getCommitterOrAuthorForCommit(int commitId2) {
        IntBinder batch = new IntBinder(1, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement("select isCommitter from log where commitId = ?", (Binder)batch);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            batch.bind(commitId2);
            SqliteResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                VcsUser vcsUser = null;
                return vcsUser;
            }
            int isCommitter = resultSet.getInt(0);
            VcsUser vcsUser = isCommitter == 1 ? this.getCommitterForCommit(commitId2, isCommitter) : this.getAuthorForCommit(commitId2);
            return vcsUser;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public long[] getTimestamp(int commitId2) {
        IntBinder batch = new IntBinder(1, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement("select authorTime, commitTime from log where commitId = ?", (Binder)batch);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            batch.bind(commitId2);
            SqliteResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                long[] lArray = null;
                return lArray;
            }
            long[] lArray = new long[]{resultSet.getLong(0), resultSet.getLong(1)};
            long[] lArray2 = lArray;
            return lArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public Map<Integer, Long> getAuthorTime(@NotNull Collection<Integer> commitIds) {
        Intrinsics.checkNotNullParameter(commitIds, (String)"commitIds");
        return this.getTime(commitIds, true);
    }

    @Override
    @NotNull
    public Map<Integer, Long> getCommitTime(@NotNull Collection<Integer> commitIds) {
        Intrinsics.checkNotNullParameter(commitIds, (String)"commitIds");
        return this.getTime(commitIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<Integer, Long> getTime(Collection<Integer> commitIds, boolean isAuthorTime) {
        HashMap<Integer, Long> result2 = new HashMap<Integer, Long>();
        ObjectBinder paramBinder = new ObjectBinder(0, 0, 2, null);
        String inClause = SqliteVcsLogStorageBackendKt.access$toInClause(commitIds);
        String sql = "select commitId, " + (isAuthorTime ? "authorTime" : "commitTime") + "  from log where commitId in " + inClause;
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement(sql, (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                int commitId2 = rs.getInt(0);
                result2.put(commitId2, rs.getLong(1));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result2;
    }

    @Override
    @NotNull
    public int[] getParents(int commitId2) {
        return (int[])this.connectionManager.selectParent.use((Function2)new Function2<SqlitePreparedStatement<IntBinder>, IntBinder, int[]>(commitId2){
            final /* synthetic */ int $commitId;
            {
                this.$commitId = $commitId;
                super(2);
            }

            @NotNull
            public final int[] invoke(@NotNull SqlitePreparedStatement<IntBinder> statement, @NotNull IntBinder binder) {
                Intrinsics.checkNotNullParameter(statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                binder.bind(this.$commitId);
                return SqliteVcsLogStorageBackendKt.access$readIntArray(statement);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Integer, List<Hash>> getParents(@NotNull Collection<Integer> commitIds) {
        Intrinsics.checkNotNullParameter(commitIds, (String)"commitIds");
        HashMap<Object, List> result2 = new HashMap<Object, List>();
        ObjectBinder paramBinder = new ObjectBinder(0, 0, 2, null);
        String inClause = SqliteVcsLogStorageBackendKt.access$toInClause(commitIds);
        String sql = "select p.rowid, c.hash from commit_hashes c inner join parent p on p.parent = c.rowid where p.commitId in " + inClause;
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement(sql, (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                void p0;
                List hashes2;
                int commitId2 = rs.getInt(0);
                Intrinsics.checkNotNullExpressionValue((Object)result2.computeIfAbsent(commitId2, arg_0 -> SqliteVcsLogStorageBackend.getParents$lambda$11$lambda$10(getParents.2.hashes.1.INSTANCE, arg_0)), (String)"result.computeIfAbsent(c\u2026itId) { mutableListOf() }");
                Intrinsics.checkNotNull((Object)rs.getString(1));
                List list = hashes2;
                boolean bl2 = false;
                Hash hash2 = HashImpl.build((String)p0);
                Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"rs.getString(1)!!.let(HashImpl::build)");
                list.add(hash2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessages(@NotNull Function2<? super Integer, ? super String, Boolean> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement("select commitId, message from log", (Binder)EmptyBinder.INSTANCE);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(0);
                String string2 = resultSet.getString(1);
                Intrinsics.checkNotNull((Object)string2);
                if (((Boolean)processor2.invoke((Object)n, (Object)string2)).booleanValue()) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public int[] getRename(int parent, int child) {
        return (int[])this.connectionManager.selectRename.use((Function2)new Function2<SqlitePreparedStatement<IntBinder>, IntBinder, int[]>(parent, child){
            final /* synthetic */ int $parent;
            final /* synthetic */ int $child;
            {
                this.$parent = $parent;
                this.$child = $child;
                super(2);
            }

            @NotNull
            public final int[] invoke(@NotNull SqlitePreparedStatement<IntBinder> statement, @NotNull IntBinder binder) {
                Intrinsics.checkNotNullParameter(statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                binder.bind(this.$parent, this.$child);
                return SqliteVcsLogStorageBackendKt.access$readIntArray(statement);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCommitsForSubstring(@NotNull String string2, @Nullable IntSet candidates, @NotNull List<String> noTrigramSources, @NotNull IntConsumer consumer, @NotNull VcsLogTextFilter filter2) {
        SqlitePreparedStatement sqlitePreparedStatement;
        Object object;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        Intrinsics.checkNotNullParameter(noTrigramSources, (String)"noTrigramSources");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        String stringParam = null;
        ObjectBinder batch = new ObjectBinder(1, 0, 2, null);
        if (string2.length() >= 3) {
            char c = '\"';
            object = StringsKt.replace$default((String)string2, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
            stringParam = c + (String)object + "\"";
            sqlitePreparedStatement = this.getConnection().prepareStatement("select rowid, message from fts_message_index(?)", (Binder)batch);
        } else {
            stringParam = "%" + StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"!", (String)"!!", (boolean)false, (int)4, null), (String)"%", (String)"!%", (boolean)false, (int)4, null), (String)"_", (String)"!_", (boolean)false, (int)4, null), (String)"[", (String)"![", (boolean)false, (int)4, null) + "%";
            sqlitePreparedStatement = this.getConnection().prepareStatement("select rowid, message from fts_message_index where message like ? escape '!'", (Binder)batch);
        }
        SqlitePreparedStatement statement = sqlitePreparedStatement;
        AutoCloseable autoCloseable = (AutoCloseable)statement;
        object = null;
        try {
            SqlitePreparedStatement it = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            batch.bind((Object)stringParam);
            SqliteResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                return;
            }
            do {
                int commitId2 = resultSet.getInt(0);
                if (candidates != null && !candidates.contains(commitId2)) continue;
                String string3 = resultSet.getString(1);
                Intrinsics.checkNotNull((Object)string3);
                if (!filter2.matches(string3)) continue;
                consumer.accept(commitId2);
            } while (resultSet.next());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void markCorrupted() {
        void it;
        ProjectLevelConnectionManager projectLevelConnectionManager;
        ProjectLevelConnectionManager oldConnectionManager = this.connectionManager;
        ProjectLevelConnectionManager projectLevelConnectionManager2 = projectLevelConnectionManager = this.connectionManager.recreate();
        SqliteVcsLogStorageBackend sqliteVcsLogStorageBackend = this;
        boolean bl = false;
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)it));
        sqliteVcsLogStorageBackend.connectionManager = projectLevelConnectionManager;
        Disposer.dispose((Disposable)oldConnectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public VcsUser getAuthorForCommit(int commitId2) {
        IntBinder paramBinder = new IntBinder(1, 0, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement("select name, email from user where commitId = ? and isCommitter = 0", (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            paramBinder.bind(commitId2);
            SqliteResultSet rs = statement.executeQuery();
            if (!rs.next()) {
                VcsUser vcsUser = null;
                return vcsUser;
            }
            String string2 = rs.getString(0);
            Intrinsics.checkNotNull((Object)string2);
            String string3 = rs.getString(1);
            Intrinsics.checkNotNull((Object)string3);
            VcsUser vcsUser = this.userRegistry.createUser(string2, string3);
            return vcsUser;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public Map<Integer, VcsUser> getAuthorForCommits(@NotNull Iterable<Integer> commitIds) {
        Intrinsics.checkNotNullParameter(commitIds, (String)"commitIds");
        return this.getAuthorOrCommitter(commitIds, true);
    }

    @Override
    @NotNull
    public Map<Integer, VcsUser> getCommitterForCommits(@NotNull Iterable<Integer> commitIds) {
        Intrinsics.checkNotNullParameter(commitIds, (String)"commitIds");
        return this.getAuthorOrCommitter(commitIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<Integer, VcsUser> getAuthorOrCommitter(Iterable<Integer> commitIds, boolean isAuthor) {
        HashMap<Integer, VcsUser> result2 = new HashMap<Integer, VcsUser>();
        ObjectBinder paramBinder = new ObjectBinder(0, 0, 2, null);
        String inClause = SqliteVcsLogStorageBackendKt.access$toInClause(commitIds);
        int isCommitter = isAuthor ? 0 : 1;
        String sql = "select commitId, name, email from user where isCommitter = " + isCommitter + " and commitId in " + inClause;
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement(sql, (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                int commitId2 = rs.getInt(0);
                Integer n = commitId2;
                String string2 = rs.getString(1);
                Intrinsics.checkNotNull((Object)string2);
                String string3 = rs.getString(2);
                Intrinsics.checkNotNull((Object)string3);
                result2.put(n, this.userRegistry.createUser(string2, string3));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result2;
    }

    @Override
    @NotNull
    public IntSet getCommitsForUsers(@NotNull Set<? extends VcsUser> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        IntOpenHashSet commitIds = new IntOpenHashSet();
        for (VcsUser vcsUser : users) {
            this.connectionManager.selectCommitsForUserPool.use((Function2)new Function2<SqlitePreparedStatement<ObjectBinder>, ObjectBinder, Unit>(vcsUser, commitIds){
                final /* synthetic */ VcsUser $user;
                final /* synthetic */ IntOpenHashSet $commitIds;
                {
                    this.$user = $user;
                    this.$commitIds = $commitIds;
                    super(2);
                }

                public final void invoke(@NotNull SqlitePreparedStatement<ObjectBinder> statement, @NotNull ObjectBinder binder) {
                    Intrinsics.checkNotNullParameter(statement, (String)"statement");
                    Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                    binder.bind((Object)this.$user.getName(), (Object)this.$user.getEmail());
                    SqliteResultSet rs = statement.executeQuery();
                    while (rs.next()) {
                        this.$commitIds.add(rs.getInt(0));
                    }
                }
            });
        }
        return (IntSet)commitIds;
    }

    private final VcsUser getCommitterForCommit(int commitId2, int isCommitter) {
        return (VcsUser)this.connectionManager.selectCommitterForCommitPool.use((Function2)new Function2<SqlitePreparedStatement<IntBinder>, IntBinder, VcsUser>(commitId2, isCommitter, this){
            final /* synthetic */ int $commitId;
            final /* synthetic */ int $isCommitter;
            final /* synthetic */ SqliteVcsLogStorageBackend this$0;
            {
                this.$commitId = $commitId;
                this.$isCommitter = $isCommitter;
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final VcsUser invoke(@NotNull SqlitePreparedStatement<IntBinder> statement, @NotNull IntBinder binder) {
                VcsUser vcsUser;
                Intrinsics.checkNotNullParameter(statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                binder.bind(this.$commitId, this.$isCommitter);
                SqliteResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    VcsUserRegistry vcsUserRegistry = SqliteVcsLogStorageBackend.access$getUserRegistry$p(this.this$0);
                    String string2 = rs.getString(0);
                    Intrinsics.checkNotNull((Object)string2);
                    String string3 = rs.getString(1);
                    Intrinsics.checkNotNull((Object)string3);
                    vcsUser = vcsUserRegistry.createUser(string2, string3);
                } else {
                    vcsUser = null;
                }
                return vcsUser;
            }
        });
    }

    @Override
    public void flush() {
    }

    @Override
    public void iterateChangesInCommits(@NotNull VirtualFile root, @NotNull FilePath path2, @NotNull ObjIntConsumer<List<VcsLogPathsIndex.ChangeKind>> consumer) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.connectionManager.runUnderReadonlyConnection((Function1)new Function1<SqliteConnection, Unit>(this, root, path2, consumer){
            final /* synthetic */ SqliteVcsLogStorageBackend this$0;
            final /* synthetic */ VirtualFile $root;
            final /* synthetic */ FilePath $path;
            final /* synthetic */ ObjIntConsumer<List<VcsLogPathsIndex.ChangeKind>> $consumer;
            {
                this.this$0 = $receiver;
                this.$root = $root;
                this.$path = $path;
                this.$consumer = $consumer;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull SqliteConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                int position = SqliteVcsLogStorageBackend.access$getRootsToPosition$p(this.this$0).getInt((Object)this.$root);
                String string2 = new VcsLogPathsIndex.LightFilePath(this.$root, this.$path).getRelativePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LightFilePath(root, path).relativePath");
                String relativePath = string2;
                Int2ObjectOpenHashMap changesInCommit = new Int2ObjectOpenHashMap();
                ObjectBinder paramBinder = new ObjectBinder(2, 0, 2, null);
                AutoCloseable autoCloseable = (AutoCloseable)connection.prepareStatement("select commitId, kind from path as p join path_change as c on p.rowid = c.pathId where p.position = ? and p.relativePath = ?", (Binder)paramBinder);
                Throwable object2 = null;
                try {
                    SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
                    boolean bl = false;
                    paramBinder.bind((Object)position, (Object)relativePath);
                    SqliteResultSet rs = statement.executeQuery();
                    while (rs.next()) {
                        List changes = (List)changesInCommit.computeIfAbsent(rs.getInt(0), iterateChangesInCommits.1::invoke$lambda$1$lambda$0);
                        VcsLogPathsIndex.ChangeKind changeKind = VcsLogPathsIndex.ChangeKind.getChangeKindById((byte)rs.getInt(1));
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)changeKind), (String)"getChangeKindById(rs.getInt(1).toByte())");
                        changes.add(changeKind);
                    }
                    statement = Unit.INSTANCE;
                }
                catch (Throwable statement) {
                    Throwable throwable = statement;
                    throw statement;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, object2);
                }
                for (Map.Entry entry2 : ((Map)changesInCommit).entrySet()) {
                    Integer commitId2 = (Integer)entry2.getKey();
                    List changes = (List)entry2.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)commitId2, (String)"commitId");
                    this.$consumer.accept(changes, commitId2);
                }
            }

            private static final ArrayList invoke$lambda$1$lambda$0(int it) {
                return new ArrayList<E>();
            }
        });
    }

    @Override
    @Nullable
    public EdgeData<FilePath> findRename(int parent, int child, @NotNull VirtualFile root, @NotNull FilePath path2, boolean isChildPath) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        int[] renames = this.getRename(parent, child);
        if (renames.length == 0) {
            return null;
        }
        int pathId = this.getPathId(new VcsLogPathsIndex.LightFilePath(root, path2));
        int i = 0;
        int n = renames.length + -1;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                int first = renames[i];
                int second = renames[i + 1];
                if (isChildPath && second == pathId || !isChildPath && first == pathId) {
                    FilePath filePath;
                    FilePath filePath2;
                    VcsLogPathsIndex.LightFilePath lightFilePath = this.getPath(first);
                    if (lightFilePath != null) {
                        VcsLogPathsIndex.LightFilePath it = lightFilePath;
                        boolean bl = false;
                        filePath2 = VcsLogPathsIndex.toFilePath(it, path2.isDirectory());
                    } else {
                        filePath2 = null;
                    }
                    FilePath path1 = filePath2;
                    VcsLogPathsIndex.LightFilePath lightFilePath2 = this.getPath(second);
                    if (lightFilePath2 != null) {
                        VcsLogPathsIndex.LightFilePath it = lightFilePath2;
                        boolean bl = false;
                        filePath = VcsLogPathsIndex.toFilePath(it, path2.isDirectory());
                    } else {
                        filePath = null;
                    }
                    FilePath path22 = filePath;
                    return new EdgeData<FilePath>(path1, path22);
                }
                if (i == n2) break;
                i += 2;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public VcsLogIndexer.PathsEncoder getPathsEncoder() {
        return (arg_0, arg_1, arg_2) -> SqliteVcsLogStorageBackend.getPathsEncoder$lambda$19(this, arg_0, arg_1, arg_2);
    }

    private final VcsLogPathsIndex.LightFilePath getPath(int pathId) {
        return (VcsLogPathsIndex.LightFilePath)this.connectionManager.selectPathPool.use((Function2)new Function2<SqlitePreparedStatement<IntBinder>, IntBinder, VcsLogPathsIndex.LightFilePath>(pathId, this){
            final /* synthetic */ int $pathId;
            final /* synthetic */ SqliteVcsLogStorageBackend this$0;
            {
                this.$pathId = $pathId;
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final VcsLogPathsIndex.LightFilePath invoke(@NotNull SqlitePreparedStatement<IntBinder> statement, @NotNull IntBinder binder) {
                VcsLogPathsIndex.LightFilePath lightFilePath;
                Intrinsics.checkNotNullParameter(statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                binder.bind(this.$pathId);
                SqliteResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    VirtualFile virtualFile = (VirtualFile)SqliteVcsLogStorageBackend.access$getSortedRoots$p(this.this$0).get(rs.getInt(0));
                    String string2 = rs.getString(1);
                    Intrinsics.checkNotNull((Object)string2);
                    lightFilePath = new VcsLogPathsIndex.LightFilePath(virtualFile, string2);
                } else {
                    lightFilePath = null;
                }
                return lightFilePath;
            }
        });
    }

    private final int getPathId(VcsLogPathsIndex.LightFilePath filePath) {
        VirtualFile virtualFile = filePath.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"filePath.root");
        String string2 = filePath.getRelativePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"filePath.relativePath");
        return this.getPathIdOrFail(virtualFile, string2);
    }

    private final int getPathIdOrFail(VirtualFile root, String relativePath) {
        Integer n = this.getPathId(root, relativePath);
        if (n == null) {
            throw new IOException("Path " + root + " with relativePath = " + relativePath + " not stored");
        }
        return n;
    }

    private final Integer getPathId(VirtualFile root, String relativePath) {
        int position = this.rootsToPosition.getInt((Object)root);
        return (Integer)this.connectionManager.selectPathIdPool.use((Function2)new Function2<SqlitePreparedStatement<ObjectBinder>, ObjectBinder, Integer>(position, relativePath){
            final /* synthetic */ int $position;
            final /* synthetic */ String $relativePath;
            {
                this.$position = $position;
                this.$relativePath = $relativePath;
                super(2);
            }

            @Nullable
            public final Integer invoke(@NotNull SqlitePreparedStatement<ObjectBinder> statement, @NotNull ObjectBinder binder) {
                Intrinsics.checkNotNullParameter(statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                binder.bind((Object)this.$position, (Object)this.$relativePath);
                return statement.selectInt();
            }
        });
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash2, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        int position = this.rootsToPosition.getInt((Object)root);
        Integer commitId2 = this.getCommitId(position, hash2);
        if (commitId2 != null) {
            return commitId2;
        }
        return ((Number)this.connectionManager.insertCommitPool.use((Function2)new Function2<SqlitePreparedStatement<ObjectBinder>, ObjectBinder, Integer>(position, hash2){
            final /* synthetic */ int $position;
            final /* synthetic */ Hash $hash;
            {
                this.$position = $position;
                this.$hash = $hash;
                super(2);
            }

            @NotNull
            public final Integer invoke(@NotNull SqlitePreparedStatement<ObjectBinder> statement, @NotNull ObjectBinder binder) {
                Intrinsics.checkNotNullParameter(statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                binder.bind((Object)this.$position, (Object)this.$hash.asString());
                return statement.selectNotNullInt();
            }
        })).intValue();
    }

    private final Integer getCommitId(int position, Hash hash2) {
        return (Integer)this.connectionManager.getSelectCommitPool().use((Function2)new Function2<SqlitePreparedStatement<ObjectBinder>, ObjectBinder, Integer>(position, hash2){
            final /* synthetic */ int $position;
            final /* synthetic */ Hash $hash;
            {
                this.$position = $position;
                this.$hash = $hash;
                super(2);
            }

            @Nullable
            public final Integer invoke(@NotNull SqlitePreparedStatement<ObjectBinder> statement, @NotNull ObjectBinder binder) {
                Intrinsics.checkNotNullParameter(statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                binder.bind((Object)this.$position, (Object)this.$hash.asString());
                return statement.selectInt();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<Integer, CommitId> getCommitIds(@NotNull Collection<Integer> commitIds) {
        Intrinsics.checkNotNullParameter(commitIds, (String)"commitIds");
        ObjectBinder paramBinder = new ObjectBinder(0, 0, 2, null);
        Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
        String inClause = SqliteVcsLogStorageBackendKt.access$toInClause(commitIds);
        String sql = "select rowid, position, hash from commit_hashes where rowid in " + inClause;
        AutoCloseable autoCloseable = (AutoCloseable)this.getConnection().prepareStatement(sql, (Binder)paramBinder);
        Throwable throwable = null;
        try {
            SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
            boolean bl = false;
            SqliteResultSet rs = statement.executeQuery();
            while (rs.next()) {
                Hash hash2;
                String p0;
                int commitId2 = rs.getInt(0);
                VirtualFile root = this.sortedRoots.get(rs.getInt(1));
                Intrinsics.checkNotNull((Object)rs.getString(2));
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build(p0), (String)"rs.getString(2)!!.let(HashImpl::build)");
                result2.put(commitId2, (Object)new CommitId(hash2, root));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (Map)result2;
    }

    @Override
    @Nullable
    public CommitId getCommitId(int commitIndex) {
        CommitId result2 = (CommitId)this.connectionManager.runUnderReadonlyConnection((Function1)new Function1<SqliteConnection, CommitId>(commitIndex, this){
            final /* synthetic */ int $commitIndex;
            final /* synthetic */ SqliteVcsLogStorageBackend this$0;
            {
                this.$commitIndex = $commitIndex;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final CommitId invoke(@NotNull SqliteConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                IntBinder paramBinder = new IntBinder(1, 0, 2, null);
                AutoCloseable autoCloseable = (AutoCloseable)connection.prepareStatement("select position, hash from commit_hashes where rowid = ?", (Binder)paramBinder);
                int n = this.$commitIndex;
                SqliteVcsLogStorageBackend sqliteVcsLogStorageBackend = this.this$0;
                Throwable throwable = null;
                try {
                    SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
                    boolean bl = false;
                    paramBinder.bind(n);
                    SqliteResultSet rs = statement.executeQuery();
                    if (rs.next()) {
                        VirtualFile root = (VirtualFile)SqliteVcsLogStorageBackend.access$getSortedRoots$p(sqliteVcsLogStorageBackend).get(rs.getInt(0));
                        String string2 = rs.getString(1);
                        Intrinsics.checkNotNull((Object)string2);
                        String p0 = string2;
                        boolean bl2 = false;
                        Hash hash2 = HashImpl.build(p0);
                        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"rs.getString(1)!!.let(HashImpl::build)");
                        Hash hash3 = hash2;
                        CommitId commitId2 = new CommitId(hash3, root);
                        return commitId2;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return null;
            }
        });
        if (result2 == null) {
            this.errorHandler.handleError(VcsLogErrorHandler.Source.Storage, new RuntimeException("Unknown commit index: " + commitIndex));
        }
        return result2;
    }

    @Override
    public boolean containsCommit(@NotNull CommitId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        int position = this.rootsToPosition.getInt((Object)id.getRoot());
        String string2 = id.getHash().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id.hash.asString()");
        String hashStr = string2;
        Object[] objectArray = new Object[]{position, hashStr};
        return !this.getConnection().selectBoolean("select not exists (select 1 from commit_hashes where position = ? and hash = ?)", (Object)objectArray);
    }

    @Override
    public int getRefIndex(@NotNull VcsRef ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        int position = this.rootsToPosition.getInt((Object)ref.getRoot());
        String string2 = ref.getCommitHash().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ref.commitHash.asString()");
        String hashStr = string2;
        String string3 = ref.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ref.name");
        String name = string3;
        VcsRefTypeSerializer refTypeSerializer = new VcsRefTypeSerializer();
        VcsLogProvider vcsLogProvider = this.logProviders.get(ref.getRoot());
        Intrinsics.checkNotNull((Object)vcsLogProvider);
        vcsLogProvider.getReferenceManager().serialize(refTypeSerializer, ref.getType());
        int type2 = refTypeSerializer.readInt();
        Hash hash2 = ref.getCommitHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"ref.commitHash");
        Integer commitId2 = this.getCommitId(position, hash2);
        if (commitId2 == null) {
            return ((Number)this.connectionManager.getInsertMoreCommitPool().use((Function2)new Function2<SqlitePreparedStatement<ObjectBinder>, ObjectBinder, Integer>(position, hashStr, name, type2){
                final /* synthetic */ int $position;
                final /* synthetic */ String $hashStr;
                final /* synthetic */ String $name;
                final /* synthetic */ int $type;
                {
                    this.$position = $position;
                    this.$hashStr = $hashStr;
                    this.$name = $name;
                    this.$type = $type;
                    super(2);
                }

                @NotNull
                public final Integer invoke(@NotNull SqlitePreparedStatement<ObjectBinder> statement, @NotNull ObjectBinder binder) {
                    Intrinsics.checkNotNullParameter(statement, (String)"statement");
                    Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                    binder.bind((Object)this.$position, (Object)this.$hashStr, (Object)this.$name, (Object)this.$type);
                    return statement.selectNotNullInt();
                }
            })).intValue();
        }
        return ((Number)this.connectionManager.getUpdateCommitPool().use((Function2)new Function2<SqlitePreparedStatement<ObjectBinder>, ObjectBinder, Integer>(name, type2, position, hashStr){
            final /* synthetic */ String $name;
            final /* synthetic */ int $type;
            final /* synthetic */ int $position;
            final /* synthetic */ String $hashStr;
            {
                this.$name = $name;
                this.$type = $type;
                this.$position = $position;
                this.$hashStr = $hashStr;
                super(2);
            }

            @NotNull
            public final Integer invoke(@NotNull SqlitePreparedStatement<ObjectBinder> statement, @NotNull ObjectBinder binder) {
                Intrinsics.checkNotNullParameter(statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                binder.bind((Object)this.$name, (Object)this.$type, (Object)this.$position, (Object)this.$hashStr);
                return statement.selectNotNullInt();
            }
        })).intValue();
    }

    @Override
    @Nullable
    public VcsRef getVcsRef(int refIndex) {
        return (VcsRef)this.connectionManager.runUnderReadonlyConnection((Function1)new Function1<SqliteConnection, VcsRefImpl>(refIndex, this){
            final /* synthetic */ int $refIndex;
            final /* synthetic */ SqliteVcsLogStorageBackend this$0;
            {
                this.$refIndex = $refIndex;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final VcsRefImpl invoke(@NotNull SqliteConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                IntBinder paramBinder = new IntBinder(1, 0, 2, null);
                AutoCloseable autoCloseable = (AutoCloseable)connection.prepareStatement("select position, hash, name, type from commit_hashes where rowid = ?", (Binder)paramBinder);
                int n = this.$refIndex;
                SqliteVcsLogStorageBackend sqliteVcsLogStorageBackend = this.this$0;
                Throwable throwable = null;
                try {
                    SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
                    boolean bl = false;
                    paramBinder.bind(n);
                    SqliteResultSet rs = statement.executeQuery();
                    if (rs.next()) {
                        VirtualFile root = (VirtualFile)SqliteVcsLogStorageBackend.access$getSortedRoots$p(sqliteVcsLogStorageBackend).get(rs.getInt(0));
                        String string2 = rs.getString(1);
                        Intrinsics.checkNotNull((Object)string2);
                        Object p0 = string2;
                        boolean bl2 = false;
                        Hash hash2 = HashImpl.build((String)p0);
                        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"rs.getString(1)!!.let(HashImpl::build)");
                        Hash hash3 = hash2;
                        String string3 = rs.getString(2);
                        Intrinsics.checkNotNull((Object)string3);
                        String name = string3;
                        Object $this$invoke_u24lambda_u241_u24lambda_u240 = p0 = new VcsRefTypeSerializer();
                        boolean bl3 = false;
                        ((VcsRefTypeSerializer)$this$invoke_u24lambda_u241_u24lambda_u240).writeInt(rs.getInt(3));
                        Object refTypeSerializer = p0;
                        V v = SqliteVcsLogStorageBackend.access$getLogProviders$p(sqliteVcsLogStorageBackend).get(root);
                        Intrinsics.checkNotNull(v);
                        VcsRefType vcsRefType = ((VcsLogProvider)v).getReferenceManager().deserialize((DataInput)refTypeSerializer);
                        Intrinsics.checkNotNullExpressionValue((Object)vcsRefType, (String)"logProviders[root]!!.ref\u2026ialize(refTypeSerializer)");
                        VcsRefType type2 = vcsRefType;
                        VcsRefImpl vcsRefImpl = new VcsRefImpl(hash3, name, type2, root);
                        return vcsRefImpl;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return null;
            }
        });
    }

    @Override
    public void iterateCommits(@NotNull Predicate<? super CommitId> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.connectionManager.runUnderReadonlyConnection((Function1)new Function1<SqliteConnection, Unit>(this, consumer){
            final /* synthetic */ SqliteVcsLogStorageBackend this$0;
            final /* synthetic */ Predicate<? super CommitId> $consumer;
            {
                this.this$0 = $receiver;
                this.$consumer = $consumer;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull SqliteConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                IntBinder paramBinder = new IntBinder(0, 0, 2, null);
                AutoCloseable autoCloseable = (AutoCloseable)connection.prepareStatement("select position, hash from commit_hashes", (Binder)paramBinder);
                SqliteVcsLogStorageBackend sqliteVcsLogStorageBackend = this.this$0;
                Predicate<? super CommitId> predicate = this.$consumer;
                Throwable throwable = null;
                try {
                    SqlitePreparedStatement statement = (SqlitePreparedStatement)autoCloseable;
                    boolean bl = false;
                    SqliteResultSet rs = statement.executeQuery();
                    while (rs.next()) {
                        Hash hash2;
                        String p0;
                        VirtualFile root = (VirtualFile)SqliteVcsLogStorageBackend.access$getSortedRoots$p(sqliteVcsLogStorageBackend).get(rs.getInt(0));
                        Intrinsics.checkNotNull((Object)rs.getString(1));
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build(p0), (String)"rs.getString(1)!!.let(HashImpl::build)");
                        if (predicate.test(new CommitId(hash2, root))) continue;
                        break;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
        });
    }

    private static final String sortedRoots$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void collectMissingCommits$lambda$5$lambda$4(IntBinder $batch, SqlitePreparedStatement $statement, IntOpenHashSet $missing, int it) {
        Intrinsics.checkNotNullParameter((Object)$batch, (String)"$batch");
        Intrinsics.checkNotNullParameter((Object)$statement, (String)"$statement");
        Intrinsics.checkNotNullParameter((Object)$missing, (String)"$missing");
        $batch.bind(it);
        if (!$statement.selectBoolean()) {
            $missing.add(it);
        }
    }

    private static final List getParents$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final int getPathsEncoder$lambda$19(SqliteVcsLogStorageBackend this$0, VirtualFile root, String relativePath, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        int position = this$0.rootsToPosition.getInt((Object)root);
        Integer pathId = this$0.getPathId(root, relativePath);
        return pathId != null ? pathId.intValue() : ((Number)this$0.connectionManager.insertPathPool.use((Function2)new Function2<SqlitePreparedStatement<ObjectBinder>, ObjectBinder, Integer>(position, relativePath){
            final /* synthetic */ int $position;
            final /* synthetic */ String $relativePath;
            {
                this.$position = $position;
                this.$relativePath = $relativePath;
                super(2);
            }

            @NotNull
            public final Integer invoke(@NotNull SqlitePreparedStatement<ObjectBinder> statement, @NotNull ObjectBinder binder) {
                Intrinsics.checkNotNullParameter(statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                binder.bind((Object)this.$position, (Object)this.$relativePath);
                return statement.selectNotNullInt();
            }
        })).intValue();
    }

    public static final /* synthetic */ VcsUserRegistry access$getUserRegistry$p(SqliteVcsLogStorageBackend $this) {
        return $this.userRegistry;
    }

    public static final /* synthetic */ Object2IntOpenHashMap access$getRootsToPosition$p(SqliteVcsLogStorageBackend $this) {
        return $this.rootsToPosition;
    }

    public static final /* synthetic */ List access$getSortedRoots$p(SqliteVcsLogStorageBackend $this) {
        return $this.sortedRoots;
    }

    public static final /* synthetic */ Map access$getLogProviders$p(SqliteVcsLogStorageBackend $this) {
        return $this.logProviders;
    }
}

