/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.InspectionMetaDataDialog;
import com.intellij.profile.codeInspection.ui.InspectionProfileActionProvider;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.InspectionProfileUtil;
import com.intellij.structuralsearch.inspection.SSBasedInspection;
import com.intellij.structuralsearch.inspection.StructuralSearchInspectionToolWrapper;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.intellij.lang.regexp.inspection.custom.CustomRegExpInspection;
import org.intellij.lang.regexp.inspection.custom.CustomRegExpInspectionToolWrapper;
import org.intellij.lang.regexp.inspection.custom.RegExpDialog;
import org.intellij.lang.regexp.inspection.custom.RegExpInspectionConfiguration;
import org.jetbrains.annotations.NotNull;

public class StructuralSearchProfileActionProvider
extends InspectionProfileActionProvider {
    @NotNull
    public List<AnAction> getActions(@NotNull SingleInspectionProfilePanel panel2) {
        if (panel2 == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(0);
        }
        StructuralSearchProfileActionProvider.enableSSIfDisabled(panel2.getProfile(), panel2.getProject());
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{new AddInspectionAction(panel2, SSRBundle.message("SSRInspection.add.search.template.button", new Object[0]), false), new AddInspectionAction(panel2, SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0]), true), new AddCustomRegExpInspectionAction(panel2, SSRBundle.message("action.add.regexp.search.inspection.text", new Object[0]), false), new AddCustomRegExpInspectionAction(panel2, SSRBundle.message("action.add.regexp.replace.inspection.text", new Object[0]), true)});
        actionGroup.setPopup(true);
        actionGroup.registerCustomShortcutSet(CommonShortcuts.getNew(), (JComponent)panel2);
        Presentation presentation2 = actionGroup.getTemplatePresentation();
        presentation2.setIcon(AllIcons.General.Add);
        presentation2.setText(SSRBundle.messagePointer("add.inspection.button", new Object[0]));
        List<AnAction> list = Arrays.asList(new AnAction[]{actionGroup, new RemoveInspectionAction(panel2)});
        if (list == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static void enableSSIfDisabled(@NotNull InspectionProfileModifiableModel profile, @NotNull Project project2) {
        if (profile == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(3);
        }
        if (profile.getToolsOrNull("SSBasedInspection", null) != null && !profile.isToolEnabled(HighlightDisplayKey.find((String)"SSBasedInspection"))) {
            profile.setToolEnabled("SSBasedInspection", true, project2, false);
            for (ScopeToolState tool : profile.getAllTools()) {
                InspectionToolWrapper wrapper = tool.getTool();
                if (!(wrapper instanceof StructuralSearchInspectionToolWrapper)) continue;
                tool.setEnabled(false);
            }
        }
    }

    public static void createNewInspection(@NotNull Configuration configuration, @NotNull Project project2) {
        if (configuration == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(5);
        }
        StructuralSearchProfileActionProvider.createNewInspection(configuration, project2, InspectionProfileManager.getInstance((Project)project2).getCurrentProfile());
    }

    public static boolean createNewInspection(@NotNull Configuration configuration, @NotNull Project project2, @NotNull InspectionProfileImpl profile) {
        if (configuration == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(7);
        }
        if (profile == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(8);
        }
        SSBasedInspection inspection = InspectionProfileUtil.getStructuralSearchInspection((InspectionProfile)profile);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            InspectionMetaDataDialog dialog = inspection.createMetaDataDialog(project2, null);
            if (configuration instanceof ReplaceConfiguration) {
                dialog.showCleanupOption(false);
            }
            if (!dialog.showAndGet()) {
                return false;
            }
            configuration.setOrder(0);
            configuration.setName(dialog.getName());
            configuration.setDescription(dialog.getDescription());
            configuration.setProblemDescriptor(dialog.getProblemDescriptor());
            configuration.setSuppressId(dialog.getSuppressId());
        }
        configuration.setUuid(null);
        inspection.addConfiguration(configuration);
        StructuralSearchProfileActionProvider.addInspectionToProfile(project2, profile, configuration);
        if (profile instanceof InspectionProfileModifiableModel) {
            ((InspectionProfileModifiableModel)profile).setModified(true);
        }
        InspectionProfileUtil.fireProfileChanged(profile);
        return true;
    }

    private static void addInspectionToProfile(@NotNull Project project2, @NotNull InspectionProfileImpl profile, @NotNull Configuration configuration) {
        String shortName;
        InspectionToolWrapper toolWrapper;
        if (project2 == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(9);
        }
        if (profile == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(11);
        }
        if ((toolWrapper = profile.getInspectionTool(shortName = configuration.getUuid(), project2)) != null) {
            return;
        }
        StructuralSearchInspectionToolWrapper wrapped = new StructuralSearchInspectionToolWrapper(Collections.singletonList(configuration));
        profile.addTool(project2, (InspectionToolWrapper)wrapped, null);
        profile.setToolEnabled(shortName, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enableSSIfDisabled";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNewInspection";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addInspectionToProfile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    static final class AddInspectionAction
    extends DumbAwareAction {
        private final SingleInspectionProfilePanel myPanel;
        private final boolean myReplace;

        AddInspectionAction(@NotNull SingleInspectionProfilePanel panel2, @NlsActions.ActionText String text2, boolean replace) {
            if (panel2 == null) {
                AddInspectionAction.$$$reportNull$$$0(0);
            }
            super(text2);
            this.myPanel = panel2;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SearchContext context;
            StructuralSearchDialog dialog;
            if (e == null) {
                AddInspectionAction.$$$reportNull$$$0(1);
            }
            if (!(dialog = new StructuralSearchDialog(context = new SearchContext(e.getDataContext()), this.myReplace, true)).showAndGet()) {
                return;
            }
            InspectionProfileModifiableModel profile = this.myPanel.getProfile();
            Configuration configuration = dialog.getConfiguration();
            if (!StructuralSearchProfileActionProvider.createNewInspection(configuration, context.getProject(), (InspectionProfileImpl)profile)) {
                return;
            }
            this.myPanel.selectInspectionTool(configuration.getUuid());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$AddInspectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class AddCustomRegExpInspectionAction
    extends DumbAwareAction {
        private final SingleInspectionProfilePanel myPanel;
        private final boolean myReplace;

        AddCustomRegExpInspectionAction(@NotNull SingleInspectionProfilePanel panel2, @NlsActions.ActionText String text2, boolean replace) {
            if (panel2 == null) {
                AddCustomRegExpInspectionAction.$$$reportNull$$$0(0);
            }
            super(text2);
            this.myPanel = panel2;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddCustomRegExpInspectionAction.$$$reportNull$$$0(1);
            }
            RegExpDialog dialog = new RegExpDialog(e.getProject(), true, this.myReplace ? RegExpInspectionConfiguration.InspectionPattern.EMPTY_REPLACE_PATTERN : null);
            if (this.myReplace) {
                // empty if block
            }
            if (!dialog.showAndGet()) {
                return;
            }
            RegExpInspectionConfiguration.InspectionPattern pattern2 = dialog.getPattern();
            InspectionProfileModifiableModel profile = this.myPanel.getProfile();
            CustomRegExpInspection inspection = InspectionProfileUtil.getCustomRegExpInspection((InspectionProfile)profile);
            Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project2 == null) {
                return;
            }
            InspectionMetaDataDialog metaDataDialog = inspection.createMetaDataDialog(project2, null);
            if (pattern2.replacement() != null) {
                metaDataDialog.showCleanupOption(false);
            }
            if (!metaDataDialog.showAndGet()) {
                return;
            }
            RegExpInspectionConfiguration configuration = new RegExpInspectionConfiguration(metaDataDialog.getName());
            configuration.addPattern(pattern2);
            configuration.setDescription(metaDataDialog.getDescription());
            configuration.setSuppressId(metaDataDialog.getSuppressId());
            configuration.setProblemDescriptor(metaDataDialog.getProblemDescriptor());
            configuration.setCleanup(metaDataDialog.isCleanup());
            configuration.setUuid(null);
            inspection.addConfiguration(configuration);
            CustomRegExpInspection.addInspectionToProfile(project2, (InspectionProfileImpl)profile, configuration);
            profile.setModified(true);
            InspectionProfileUtil.fireProfileChanged((InspectionProfileImpl)profile);
            this.myPanel.selectInspectionTool(configuration.getUuid());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$AddCustomRegExpInspectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RemoveInspectionAction
    extends DumbAwareAction {
        private final SingleInspectionProfilePanel myPanel;

        private RemoveInspectionAction(@NotNull SingleInspectionProfilePanel panel2) {
            if (panel2 == null) {
                RemoveInspectionAction.$$$reportNull$$$0(0);
            }
            super(SSRBundle.message("remove.inspection.button", new Object[0]), null, AllIcons.General.Remove);
            this.myPanel = panel2;
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)this.myPanel);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveInspectionAction.$$$reportNull$$$0(1);
            }
            InspectionToolWrapper selectedTool = this.myPanel.getSelectedTool();
            e.getPresentation().setEnabled(selectedTool instanceof CustomRegExpInspectionToolWrapper || selectedTool instanceof StructuralSearchInspectionToolWrapper);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RemoveInspectionAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveInspectionAction.$$$reportNull$$$0(3);
            }
            InspectionToolWrapper selectedTool = this.myPanel.getSelectedTool();
            String shortName = selectedTool.getShortName();
            String mainToolId = selectedTool.getMainToolId();
            this.myPanel.removeSelectedRow();
            InspectionProfileModifiableModel profile = this.myPanel.getProfile();
            InspectionProfileEntry inspection = InspectionProfileUtil.getInspection((InspectionProfile)profile, mainToolId);
            if (inspection instanceof SSBasedInspection) {
                SSBasedInspection ssBasedInspection = (SSBasedInspection)inspection;
                ssBasedInspection.removeConfigurationsWithUuid(shortName);
            } else if (inspection instanceof CustomRegExpInspection) {
                CustomRegExpInspection customRegExpInspection = (CustomRegExpInspection)inspection;
                customRegExpInspection.removeConfigurationWithUuid(shortName);
            }
            profile.removeTool(selectedTool);
            profile.setModified(true);
            InspectionProfileUtil.fireProfileChanged((InspectionProfileImpl)profile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$RemoveInspectionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$RemoveInspectionAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

