/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.contentAnnotation;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.contentAnnotation.ContentAnnotationCache;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationSettings;
import com.intellij.openapi.vcs.history.HistoryCacheWithRevisionKey;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.SLRUMap;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

final class ContentAnnotationCacheImpl
implements ContentAnnotationCache {
    private final SLRUMap<HistoryCacheWithRevisionKey, TreeMap<Integer, Long>> myCache;
    private final Object myLock = new Object();

    ContentAnnotationCacheImpl() {
        this.myCache = new SLRUMap(50, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ThreeState isRecent(VirtualFile vf, VcsKey vcsKey, VcsRevisionNumber number, TextRange range, long boundTime) {
        TreeMap treeMap;
        Object object = this.myLock;
        synchronized (object) {
            treeMap = (TreeMap)this.myCache.get((Object)new HistoryCacheWithRevisionKey(VcsContextFactory.getInstance().createFilePathOn(vf), vcsKey, number));
        }
        if (treeMap != null) {
            Map.Entry last = treeMap.floorEntry(range.getEndOffset());
            if (last == null || last.getKey() < range.getStartOffset()) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    ContentAnnotationCacheImpl.$$$reportNull$$$0(0);
                }
                return threeState;
            }
            Map.Entry first = treeMap.ceilingEntry(range.getStartOffset());
            assert (first != null);
            SortedMap interval = treeMap.subMap(first.getKey(), last.getKey());
            for (Map.Entry entry2 : interval.entrySet()) {
                if ((Long)entry2.getValue() < boundTime) continue;
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    ContentAnnotationCacheImpl.$$$reportNull$$$0(1);
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ContentAnnotationCacheImpl.$$$reportNull$$$0(2);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            ContentAnnotationCacheImpl.$$$reportNull$$$0(3);
        }
        return threeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(VirtualFile vf, VcsKey vcsKey, VcsRevisionNumber number, FileAnnotation fa) {
        HistoryCacheWithRevisionKey key2 = new HistoryCacheWithRevisionKey(VcsContextFactory.getInstance().createFilePathOn(vf), vcsKey, number);
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCache.get((Object)key2) != null) {
                return;
            }
        }
        long absoluteLimit = System.currentTimeMillis() - VcsContentAnnotationSettings.ourAbsoluteLimit;
        TreeMap<Integer, Long> map2 = new TreeMap<Integer, Long>();
        int lineCount = fa.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            Date lineDate = fa.getLineDate(i);
            if (lineDate == null) {
                return;
            }
            if (lineDate.getTime() < absoluteLimit) continue;
            map2.put(i, lineDate.getTime());
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            this.myCache.put((Object)key2, map2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/contentAnnotation/ContentAnnotationCacheImpl", "isRecent"));
    }
}

