/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.CommonBundle;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.BackgroundRefresher;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SpecificFilesViewDialog
extends DialogWrapper {
    protected final JPanel myPanel;
    protected final ChangesListView myView;
    protected final Project myProject;
    private final BackgroundRefresher<@NotNull Runnable> myBackgroundRefresher;

    protected SpecificFilesViewDialog(@NotNull Project project2, @NotNull @NlsContexts.DialogTitle String title2, final @NotNull DataKey<Iterable<FilePath>> shownDataKey) {
        if (project2 == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(0);
        }
        if (title2 == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(1);
        }
        if (shownDataKey == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(2);
        }
        super(project2, true);
        this.setTitle(title2);
        this.myProject = project2;
        this.myBackgroundRefresher = new BackgroundRefresher(((Object)((Object)this)).getClass().getSimpleName() + " refresh", this.getDisposable());
        this.myView = new ChangesListView(project2, false){

            @Override
            @Nullable
            public Object getData(@NotNull String dataId) {
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (shownDataKey.is(dataId)) {
                    return VcsTreeModelData.selected((JTree)((Object)this)).iterateUserObjects(FilePath.class);
                }
                return super.getData(dataId);
            }

            @Override
            public void onGroupingChanged() {
                SpecificFilesViewDialog.this.refreshView();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog$1", "getData"));
            }
        };
        Runnable closer = () -> this.close(0);
        EditSourceOnEnterKeyHandler.install((JComponent)((Object)this.myView), (Runnable)closer);
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myView), (Runnable)closer);
        this.myView.setMinimumSize((Dimension)new JBDimension(100, 100));
        this.myPanel = this.createPanel();
        this.setOKButtonText(CommonBundle.getCancelButtonText());
        this.init();
        ChangeListAdapter changeListListener = new ChangeListAdapter(){

            @Override
            public void changeListUpdateDone() {
                SpecificFilesViewDialog.this.refreshView();
            }
        };
        ChangeListManager.getInstance(this.myProject).addChangeListListener(changeListListener, this.myDisposable);
        this.refreshView();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    private JPanel createPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        DefaultActionGroup group2 = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SPECIFIC_FILES_DIALOG", (ActionGroup)group2, true);
        this.addCustomActions(group2);
        CommonActionsManager cam = CommonActionsManager.getInstance();
        Expander expander = new Expander();
        group2.addSeparator();
        group2.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        DefaultActionGroup treeActions = new DefaultActionGroup();
        treeActions.add(cam.createExpandAllHeaderAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        treeActions.add(cam.createCollapseAllHeaderAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        TreeActionsToolbarPanel toolbarPanel = new TreeActionsToolbarPanel(actionToolbar, (ActionGroup)treeActions, (JComponent)((Object)this.myView));
        panel2.add((Component)toolbarPanel, "North");
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myView)), "Center");
        return panel2;
    }

    protected void addCustomActions(@NotNull DefaultActionGroup group2) {
        if (group2 == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(4);
        }
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.openapi.vcs.changes.SpecificFilesViewDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void updateTreeModel(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(5);
        }
        TreeState state = TreeState.createOn((JTree)((Object)this.myView));
        this.myView.setModel(treeModel);
        this.myView.expandPath(new TreePath(this.myView.getRoot().getPath()));
        state.applyTo((JTree)((Object)this.myView));
    }

    @NotNull
    private DefaultTreeModel buildTreeModel() {
        List<FilePath> files2 = this.getFiles();
        DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromFilePaths(this.myProject, this.myView.getGrouping(), files2);
        if (defaultTreeModel == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(6);
        }
        return defaultTreeModel;
    }

    protected void refreshView() {
        this.myView.setPaintBusy(true);
        ModalityState modalityState = ModalityState.stateForComponent((Component)((Object)this.myView));
        this.myBackgroundRefresher.requestRefresh(0, (Computable<Runnable>)((Computable)() -> {
            DefaultTreeModel treeModel = this.buildTreeModel();
            return () -> this.updateTreeModel(treeModel);
        })).thenAsync(callback2 -> AppUIExecutor.onUiThread((ModalityState)modalityState).submit(callback2)).onProcessed(__ -> this.myView.setPaintBusy(false));
    }

    @NotNull
    protected abstract List<FilePath> getFiles();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shownDataKey";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCustomActions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateTreeModel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 6 -> new IllegalStateException(string2);
        };
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)SpecificFilesViewDialog.this.myView));
        }

        public boolean canExpand() {
            return !SpecificFilesViewDialog.this.myView.getGroupingSupport().isNone();
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)1);
            TreeUtil.expand((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)0);
        }

        public boolean canCollapse() {
            return !SpecificFilesViewDialog.this.myView.getGroupingSupport().isNone();
        }
    }
}

