/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.maven.server.m40.Maven40ServerEmbedderImpl;
import com.intellij.maven.server.m40.utils.Maven40AetherModelConverter;
import com.intellij.maven.server.m40.utils.Maven40ExecutionResult;
import com.intellij.maven.server.m40.utils.Maven40ImporterSpy;
import com.intellij.maven.server.m40.utils.Maven40ModelConverter;
import com.intellij.maven.server.m40.utils.Maven40ProfileUtil;
import com.intellij.maven.server.m40.utils.Maven40ResolverUtil;
import com.intellij.maven.server.m40.utils.Maven40TransferListenerAdapter;
import com.intellij.maven.server.m40.utils.Maven40WorkspaceMapReader;
import com.intellij.maven.server.m40.utils.Maven40WorkspaceReader;
import com.intellij.maven.server.m40.utils.RemoteNativeMaven40ProjectHolder;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.LongRunningTask;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorImpl;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.ParallelRunner;

public class Maven40ProjectResolver {
    @NotNull
    private final Maven40ServerEmbedderImpl myEmbedder;
    private final boolean myUpdateSnapshots;
    @NotNull
    private final Maven40ImporterSpy myImporterSpy;
    @NotNull
    private final MavenServerConsoleIndicatorImpl myCurrentIndicator;
    @Nullable
    private final MavenWorkspaceMap myWorkspaceMap;
    @NotNull
    private final File myLocalRepositoryFile;

    public Maven40ProjectResolver(@NotNull Maven40ServerEmbedderImpl embedder, boolean updateSnapshots, @NotNull Maven40ImporterSpy importerSpy, @NotNull MavenServerConsoleIndicatorImpl currentIndicator, @Nullable MavenWorkspaceMap workspaceMap, @NotNull File localRepositoryFile) {
        if (embedder == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(0);
        }
        if (importerSpy == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(1);
        }
        if (currentIndicator == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(2);
        }
        if (localRepositoryFile == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(3);
        }
        this.myEmbedder = embedder;
        this.myUpdateSnapshots = updateSnapshots;
        this.myImporterSpy = importerSpy;
        this.myCurrentIndicator = currentIndicator;
        this.myWorkspaceMap = workspaceMap;
        this.myLocalRepositoryFile = localRepositoryFile;
    }

    @NotNull
    public Collection<MavenServerExecutionResult> resolveProjects(@NotNull LongRunningTask task, @NotNull Collection<File> files, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles) {
        List list;
        if (task == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(4);
        }
        if (files == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(5);
        }
        if (activeProfiles == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(6);
        }
        if (inactiveProfiles == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(7);
        }
        try {
            Collection<Maven40ExecutionResult> results = this.doResolveProject(task, files, activeProfiles, inactiveProfiles);
            list = ContainerUtilRt.map2List(results, result -> this.createExecutionResult((Maven40ExecutionResult)result));
        }
        catch (Exception e) {
            throw this.myEmbedder.wrapToSerializableRuntimeException(e);
        }
        if (list == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private Collection<Maven40ExecutionResult> doResolveProject(@NotNull LongRunningTask task, @NotNull Collection<File> files, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles) {
        if (task == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(9);
        }
        if (files == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(10);
        }
        if (activeProfiles == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(11);
        }
        if (inactiveProfiles == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(12);
        }
        File file = !files.isEmpty() ? files.iterator().next() : null;
        MavenExecutionRequest request = this.myEmbedder.createRequest(file, activeProfiles, inactiveProfiles);
        request.setUpdateSnapshots(this.myUpdateSnapshots);
        ArrayList<Maven40ExecutionResult> executionResults = new ArrayList<Maven40ExecutionResult>();
        HashMap buildingResultsToResolveDependencies = new HashMap();
        this.myEmbedder.executeWithMavenSession(request, () -> {
            try {
                MavenSession mavenSession = this.myEmbedder.getComponent(LegacySupport.class).getSession();
                RepositorySystemSession repositorySession = this.myEmbedder.getComponent(LegacySupport.class).getRepositorySession();
                if (repositorySession instanceof DefaultRepositorySystemSession) {
                    DefaultRepositorySystemSession session = (DefaultRepositorySystemSession)repositorySession;
                    this.myImporterSpy.setIndicator((MavenServerConsoleIndicator)this.myCurrentIndicator);
                    session.setTransferListener((TransferListener)new Maven40TransferListenerAdapter(this.myCurrentIndicator));
                    if (this.myWorkspaceMap != null) {
                        session.setWorkspaceReader((WorkspaceReader)new Maven40WorkspaceMapReader(this.myWorkspaceMap));
                    }
                    session.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
                    session.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
                }
                List<ProjectBuildingResult> buildingResults = this.getProjectBuildingResults(request, files);
                Maven40ProjectResolver.fillSessionCache(mavenSession, repositorySession, buildingResults);
                for (ProjectBuildingResult buildingResult : buildingResults) {
                    ArrayList<Exception> exceptions;
                    MavenProject project = buildingResult.getProject();
                    if (project == null) {
                        exceptions = new ArrayList<Exception>();
                        for (ModelProblem problem : buildingResult.getProblems()) {
                            exceptions.add(problem.getException());
                        }
                        executionResults.add(new Maven40ExecutionResult(buildingResult.getPomFile(), exceptions));
                        continue;
                    }
                    exceptions = new ArrayList();
                    this.loadExtensions(project, exceptions);
                    buildingResultsToResolveDependencies.put(buildingResult, exceptions);
                }
                task.updateTotalRequests(buildingResultsToResolveDependencies.size());
                boolean runInParallel = this.canResolveDependenciesInParallel();
                List execResults = ParallelRunner.execute((boolean)runInParallel, buildingResultsToResolveDependencies.entrySet(), entry -> {
                    if (task.isCanceled()) {
                        return new Maven40ExecutionResult(Collections.emptyList());
                    }
                    Maven40ExecutionResult result = this.resolveBuildingResult(repositorySession, (ProjectBuildingResult)entry.getKey(), (List)entry.getValue());
                    task.incrementFinishedRequests();
                    return result;
                });
                executionResults.addAll(execResults);
            }
            catch (Exception e) {
                executionResults.add(Maven40ProjectResolver.handleException(e));
            }
        });
        ArrayList<Maven40ExecutionResult> arrayList = executionResults;
        if (arrayList == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private boolean canResolveDependenciesInParallel() {
        return true;
    }

    @NotNull
    private Maven40ExecutionResult resolveBuildingResult(RepositorySystemSession repositorySession, ProjectBuildingResult buildingResult, List<Exception> exceptions) {
        MavenProject project = buildingResult.getProject();
        try {
            ArrayList<ModelProblem> modelProblems = new ArrayList<ModelProblem>();
            if (buildingResult.getProblems() != null) {
                modelProblems.addAll(buildingResult.getProblems());
            }
            DependencyResolutionResult dependencyResolutionResult = this.resolveDependencies(project, repositorySession);
            Set<Artifact> artifacts = this.resolveArtifacts(dependencyResolutionResult);
            project.setArtifacts(artifacts);
            return new Maven40ExecutionResult(project, dependencyResolutionResult, exceptions, modelProblems);
        }
        catch (Exception e) {
            Maven40ExecutionResult maven40ExecutionResult = Maven40ProjectResolver.handleException(project, e);
            if (maven40ExecutionResult == null) {
                Maven40ProjectResolver.$$$reportNull$$$0(14);
            }
            return maven40ExecutionResult;
        }
    }

    private DependencyResolutionResult resolveDependencies(MavenProject project, RepositorySystemSession session) {
        DependencyResolutionResult resolutionResult;
        try {
            ProjectDependenciesResolver dependencyResolver = this.myEmbedder.getComponent(ProjectDependenciesResolver.class);
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, session);
            resolutionResult = dependencyResolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            resolutionResult = e.getResult();
        }
        LinkedHashSet artifacts = new LinkedHashSet();
        if (resolutionResult.getDependencyGraph() != null) {
            RepositoryUtils.toArtifacts(artifacts, (Collection)resolutionResult.getDependencyGraph().getChildren(), null == project.getArtifact() ? Collections.emptyList() : Collections.singletonList(project.getArtifact().getId()), null);
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            for (Artifact artifact : artifacts) {
                if (artifact.isResolved()) continue;
                String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact((Artifact)artifact));
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
        }
        project.setResolvedArtifacts(artifacts);
        project.setArtifacts(artifacts);
        return resolutionResult;
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(Maven40ExecutionResult result) {
        File file = result.getPomFile();
        Collection problems = MavenProjectProblem.createProblemsList();
        this.myEmbedder.collectProblems(file, result.getExceptions(), result.getModelProblems(), problems);
        HashSet<MavenProjectProblem> unresolvedProblems = new HashSet<MavenProjectProblem>();
        this.collectUnresolvedArtifactProblems(file, result.getDependencyResolutionResult(), unresolvedProblems);
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            return new MavenServerExecutionResult(null, problems, Collections.emptySet());
        }
        MavenModel model = new MavenModel();
        try {
            DependencyResolutionResult dependencyResolutionResult = result.getDependencyResolutionResult();
            DependencyNode dependencyGraph = dependencyResolutionResult != null ? dependencyResolutionResult.getDependencyGraph() : null;
            List dependencyNodes = dependencyGraph != null ? dependencyGraph.getChildren() : Collections.emptyList();
            model = Maven40AetherModelConverter.convertModelWithAetherDependencyTree(mavenProject.getModel(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), mavenProject.getArtifacts(), dependencyNodes, Collections.emptyList(), this.myLocalRepositoryFile);
        }
        catch (Exception e) {
            this.myEmbedder.collectProblems(mavenProject.getFile(), Collections.singleton(e), result.getModelProblems(), problems);
        }
        RemoteNativeMaven40ProjectHolder holder = new RemoteNativeMaven40ProjectHolder(mavenProject);
        try {
            UnicastRemoteObject.exportObject((Remote)((Object)holder), 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        Collection<String> activatedProfiles = Maven40ProfileUtil.collectActivatedProfiles(mavenProject);
        Map<String, String> mavenModelMap = Maven40ModelConverter.convertToMap(mavenProject.getModel());
        MavenServerExecutionResult.ProjectData data = new MavenServerExecutionResult.ProjectData(model, mavenModelMap, (NativeMavenProjectHolder)holder, activatedProfiles);
        if (null == model.getBuild() || null == model.getBuild().getDirectory()) {
            data = null;
        }
        return new MavenServerExecutionResult(data, problems, Collections.emptySet(), unresolvedProblems);
    }

    private void collectUnresolvedArtifactProblems(@Nullable File file, @Nullable DependencyResolutionResult result, Collection<MavenProjectProblem> problems) {
        if (result == null) {
            return;
        }
        String path = file == null ? "" : file.getPath();
        for (Dependency unresolvedDependency : result.getUnresolvedDependencies()) {
            Iterator iterator = result.getResolutionErrors(unresolvedDependency).iterator();
            if (!iterator.hasNext()) continue;
            Exception exception = (Exception)iterator.next();
            String message = Maven40ServerEmbedderImpl.getRootMessage(exception);
            Artifact artifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)unresolvedDependency.getArtifact());
            MavenArtifact mavenArtifact = Maven40ModelConverter.convertArtifact(artifact, this.myLocalRepositoryFile);
            problems.add(MavenProjectProblem.createUnresolvedArtifactProblem((String)path, (String)message, (boolean)true, (MavenArtifact)mavenArtifact));
        }
    }

    private static Maven40ExecutionResult handleException(Exception e) {
        return new Maven40ExecutionResult(Collections.singletonList(e));
    }

    private static Maven40ExecutionResult handleException(MavenProject mavenProject, Exception e) {
        return new Maven40ExecutionResult(mavenProject, Collections.singletonList(e));
    }

    @NotNull
    private Set<Artifact> resolveArtifacts(DependencyResolutionResult dependencyResolutionResult) {
        IdentityHashMap<Dependency, Artifact> winnerDependencyMap = new IdentityHashMap<Dependency, Artifact>();
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        Set addedDependencies = Collections.newSetFromMap(new IdentityHashMap());
        Maven40ProjectResolver.resolveConflicts(dependencyResolutionResult, winnerDependencyMap);
        if (dependencyResolutionResult.getDependencyGraph() != null) {
            dependencyResolutionResult.getDependencyGraph().getChildren();
        }
        for (Dependency dependency : dependencyResolutionResult.getDependencies()) {
            Artifact artifact = dependency == null ? null : (Artifact)winnerDependencyMap.get(dependency);
            if (artifact == null) continue;
            addedDependencies.add(dependency);
            artifacts.add(artifact);
            this.resolveAsModule(artifact);
        }
        ArrayDeque queue = new ArrayDeque(dependencyResolutionResult.getDependencyGraph().getChildren());
        while (!queue.isEmpty()) {
            Artifact artifact;
            DependencyNode node = (DependencyNode)queue.poll();
            queue.addAll(node.getChildren());
            Dependency dependency = node.getDependency();
            if (dependency == null || !addedDependencies.add(dependency) || (artifact = (Artifact)winnerDependencyMap.get(dependency)) == null) continue;
            addedDependencies.add(dependency);
            artifacts.add(artifact);
            this.resolveAsModule(artifact);
        }
        LinkedHashSet<Artifact> linkedHashSet = artifacts;
        if (linkedHashSet == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(15);
        }
        return linkedHashSet;
    }

    private static void fillSessionCache(MavenSession mavenSession, RepositorySystemSession session, List<ProjectBuildingResult> buildingResults) {
        if (session instanceof DefaultRepositorySystemSession) {
            int initialCapacity = (int)((double)buildingResults.size() * 1.5);
            HashMap<MavenId, Model> cacheMavenModelMap = new HashMap<MavenId, Model>(initialCapacity);
            HashMap<String, MavenProject> mavenProjectMap = new HashMap<String, MavenProject>(initialCapacity);
            for (ProjectBuildingResult result : buildingResults) {
                if (result.getProblems() != null && !result.getProblems().isEmpty()) continue;
                Model model = result.getProject().getModel();
                String key = ArtifactUtils.key((String)model.getGroupId(), (String)model.getArtifactId(), (String)model.getVersion());
                mavenProjectMap.put(key, result.getProject());
                cacheMavenModelMap.put(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()), model);
            }
            mavenSession.setProjectMap(mavenProjectMap);
            ((DefaultRepositorySystemSession)session).setWorkspaceReader((WorkspaceReader)new Maven40WorkspaceReader(session.getWorkspaceReader(), cacheMavenModelMap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions(MavenProject project, List<Exception> exceptions) {
        LegacySupport legacySupport;
        MavenSession session;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Collection<AbstractMavenLifecycleParticipant> lifecycleParticipants = this.myEmbedder.getLifecycleParticipants(Collections.singletonList(project));
        if (!lifecycleParticipants.isEmpty() && null != (session = (legacySupport = this.myEmbedder.getComponent(LegacySupport.class)).getSession())) {
            session.setCurrentProject(project);
            try {
                session.setAllProjects(Collections.singletonList(project));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            session.setProjects(Collections.singletonList(project));
            for (AbstractMavenLifecycleParticipant listener : lifecycleParticipants) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                try {
                    listener.afterProjectsRead(session);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
    }

    private boolean resolveAsModule(Artifact a) {
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return false;
        }
        MavenWorkspaceMap.Data resolved = map.findFileAndOriginalId(Maven40ModelConverter.createMavenId(a));
        if (resolved == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(resolved.getFile(a.getType()));
        a.selectVersion(resolved.originalId.getVersion());
        return true;
    }

    private static void resolveConflicts(DependencyResolutionResult dependencyResolutionResult, final Map<Dependency, Artifact> winnerDependencyMap) {
        dependencyResolutionResult.getDependencyGraph().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                Object winner = node.getData().get("conflict.winner");
                Dependency dependency = node.getDependency();
                if (dependency != null && winner == null) {
                    Artifact winnerArtifact = Maven40AetherModelConverter.toArtifact(dependency);
                    winnerDependencyMap.put(dependency, winnerArtifact);
                }
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        }));
    }

    @NotNull
    private List<ProjectBuildingResult> getProjectBuildingResults(@NotNull MavenExecutionRequest request, @NotNull Collection<File> files) {
        if (request == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(16);
        }
        if (files == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(17);
        }
        ProjectBuilder builder = this.myEmbedder.getComponent(ProjectBuilder.class);
        List<Object> buildingResults = new ArrayList<ProjectBuildingResult>();
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        projectBuildingRequest.setValidationLevel(0);
        projectBuildingRequest.setResolveDependencies(false);
        if (files.size() == 1) {
            this.buildSinglePom(builder, buildingResults, projectBuildingRequest, files.iterator().next());
        } else {
            try {
                buildingResults = builder.build(new ArrayList<File>(files), false, projectBuildingRequest);
            }
            catch (ProjectBuildingException e) {
                for (ProjectBuildingResult result : e.getResults()) {
                    if (result.getProject() != null) {
                        buildingResults.add(result);
                        continue;
                    }
                    this.buildSinglePom(builder, buildingResults, projectBuildingRequest, result.getPomFile());
                }
            }
        }
        List<Object> list = buildingResults;
        if (list == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(18);
        }
        return list;
    }

    private void buildSinglePom(ProjectBuilder builder, List<ProjectBuildingResult> buildingResults, ProjectBuildingRequest projectBuildingRequest, File pomFile) {
        try {
            ProjectBuildingResult build = builder.build(pomFile, projectBuildingRequest);
            buildingResults.add(build);
        }
        catch (ProjectBuildingException e) {
            Maven40ResolverUtil.handleProjectBuildingException(buildingResults, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importerSpy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentIndicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRepositoryFile";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/maven/server/m40/utils/Maven40ProjectResolver";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/maven/server/m40/utils/Maven40ProjectResolver";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProjects";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProject";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBuildingResult";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifacts";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBuildingResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjects";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doResolveProject";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProjectBuildingResults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

