/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.languagetool.UserConfig;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionarySpellMatchFilter
implements RuleMatchFilter {
    private static final Logger log = LoggerFactory.getLogger(DictionarySpellMatchFilter.class);
    private final UserConfig userConfig;
    private static final int CACHE_SIZE = 100;
    private static final long CACHE_TTL_SECONDS = 600L;
    private static final LoadingCache<UserConfig, AhoCorasickDoubleArrayTrie<String>> phraseSearcher = CacheBuilder.newBuilder().recordStats().maximumSize(100L).expireAfterAccess(600L, TimeUnit.SECONDS).build((CacheLoader)new PhraseSearchLoader());

    public DictionarySpellMatchFilter(UserConfig userConfig) {
        this.userConfig = userConfig;
    }

    @Override
    public List<RuleMatch> filter(List<RuleMatch> ruleMatches, AnnotatedText text2) {
        Set<String> dictionary = this.userConfig.getAcceptedPhrases();
        if (dictionary.size() > 0) {
            ArrayList<RuleMatch> cleanMatches = new ArrayList<RuleMatch>(ruleMatches);
            try {
                AhoCorasickDoubleArrayTrie searcher = (AhoCorasickDoubleArrayTrie)phraseSearcher.get((Object)this.userConfig);
                List phrases = searcher.parseText(text2.getPlainText());
                for (AhoCorasickDoubleArrayTrie.Hit phrase : phrases) {
                    Iterator iter = cleanMatches.iterator();
                    while (iter.hasNext()) {
                        RuleMatch match = (RuleMatch)iter.next();
                        if (!match.getRule().isDictionaryBasedSpellingRule() || match.getFromPos() < phrase.begin || match.getToPos() > phrase.end) continue;
                        iter.remove();
                    }
                }
                return cleanMatches;
            }
            catch (ExecutionException e) {
                log.error("Couldn't set up phrase search, accepted phrases won't work.", (Throwable)e);
                return ruleMatches;
            }
        }
        return ruleMatches;
    }

    public Map<String, List<RuleMatch>> getPhrases(List<RuleMatch> ruleMatches, AnnotatedText text2) {
        HashMap<String, List<RuleMatch>> phraseToMatches = new HashMap<String, List<RuleMatch>>();
        int prevToPos = Integer.MIN_VALUE;
        ArrayList<RuleMatch> collectedMatches = new ArrayList<RuleMatch>();
        ArrayList<String> collectedTerms = new ArrayList<String>();
        for (RuleMatch match : ruleMatches) {
            if (!match.getRule().isDictionaryBasedSpellingRule()) continue;
            String covered = text2.getPlainText().substring(match.getFromPos(), match.getToPos());
            if (match.getFromPos() == prevToPos + 1) {
                String key2 = String.join((CharSequence)" ", collectedTerms) + " " + covered;
                ArrayList<RuleMatch> l = new ArrayList<RuleMatch>(collectedMatches);
                l.add(match);
                phraseToMatches.put(key2, l);
            } else {
                collectedTerms.clear();
                collectedMatches.clear();
            }
            collectedTerms.add(covered);
            collectedMatches.add(match);
            prevToPos = match.getToPos();
        }
        return phraseToMatches;
    }

    private static class PhraseSearchLoader
    extends CacheLoader<UserConfig, AhoCorasickDoubleArrayTrie<String>> {
        private PhraseSearchLoader() {
        }

        public AhoCorasickDoubleArrayTrie<String> load(UserConfig key2) throws Exception {
            AhoCorasickDoubleArrayTrie<String> searcher = new AhoCorasickDoubleArrayTrie<String>();
            HashMap<String, String> phrases = new HashMap<String, String>();
            for (String phrase : key2.getAcceptedPhrases()) {
                phrases.put(phrase, phrase);
            }
            searcher.build(phrases);
            return searcher;
        }
    }
}

