/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.lookup.AbstractStringLookup;
import org.apache.commons.text.lookup.IllegalArgumentExceptions;

final class FileStringLookup
extends AbstractStringLookup {
    static final AbstractStringLookup INSTANCE = new FileStringLookup();

    private FileStringLookup() {
    }

    @Override
    public String lookup(String key2) {
        if (key2 == null) {
            return null;
        }
        String[] keys = key2.split(String.valueOf(':'));
        int keyLen = keys.length;
        if (keyLen < 2) {
            throw IllegalArgumentExceptions.format("Bad file key format [%s], expected format is CharsetName:DocumentPath.", key2);
        }
        String charsetName = keys[0];
        String fileName2 = StringUtils.substringAfter((String)key2, (int)58);
        try {
            return new String(Files.readAllBytes(Paths.get(fileName2, new String[0])), charsetName);
        }
        catch (Exception e) {
            throw IllegalArgumentExceptions.format(e, "Error looking up file [%s] with charset [%s].", fileName2, charsetName);
        }
    }
}

