/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.text.StringUtilRt;
import java.io.File;
import org.jetbrains.idea.maven.server.MavenProcessCanceledRuntimeException;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorImpl;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.transfer.TransferResource;

public class Maven30TransferListenerAdapter
implements TransferListener {
    protected final MavenServerConsoleIndicatorImpl myIndicator;

    public Maven30TransferListenerAdapter(MavenServerConsoleIndicatorImpl indicator) {
        this.myIndicator = indicator;
    }

    private void checkCanceled() {
        if (this.myIndicator.isCanceled()) {
            throw new MavenProcessCanceledRuntimeException();
        }
    }

    private static String formatResourceName(TransferEvent event) {
        TransferResource resource = event.getResource();
        File file = resource.getFile();
        return (file == null ? resource.getResourceName() : file.getName()) + " [" + resource.getRepositoryUrl() + "]";
    }

    public void transferInitiated(TransferEvent event) {
        this.checkCanceled();
        String eventString = Maven30TransferListenerAdapter.formatResourceName(event);
        this.myIndicator.debug(eventString);
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        this.transferProgressed(event);
    }

    public void transferProgressed(TransferEvent event) {
        this.checkCanceled();
        TransferResource r = event.getResource();
        long totalLength = r.getContentLength();
        String sizeInfo = totalLength <= 0L ? StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + " / ?" : StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + " / " + StringUtilRt.formatFileSize((long)totalLength);
        this.myIndicator.debug(Maven30TransferListenerAdapter.formatResourceName(event) + "  (" + sizeInfo + ')');
        if (totalLength > 0L) {
            this.myIndicator.debug(String.valueOf(Math.floor(100.0 * (double)event.getTransferredBytes() / (double)totalLength)) + "%");
        }
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        this.myIndicator.warn("Checksum failed: " + Maven30TransferListenerAdapter.formatResourceName(event));
    }

    public void transferSucceeded(TransferEvent event) {
        this.myIndicator.debug("Finished (" + StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + ") " + Maven30TransferListenerAdapter.formatResourceName(event));
        MavenServerGlobals.getDownloadListener().artifactDownloaded(event.getResource().getFile(), event.getResource().getResourceName());
    }

    public void transferFailed(TransferEvent event) {
        if (this.myIndicator.isCanceled()) {
            this.myIndicator.info("Canceling...");
            return;
        }
        this.myIndicator.warn("Failed to download " + Maven30TransferListenerAdapter.formatResourceName(event));
    }
}

