/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.discovery;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ToStringBuilder;
import org.gradle.internal.impldep.org.junit.platform.engine.DiscoverySelector;
import org.gradle.internal.impldep.org.junit.platform.engine.discovery.FilePosition;

@API(status=API.Status.STABLE, since="1.0")
public class FileSelector
implements DiscoverySelector {
    private final String path;
    private final FilePosition position;

    FileSelector(String path, FilePosition position) {
        this.path = path;
        this.position = position;
    }

    public File getFile() {
        return new File(this.path);
    }

    public Path getPath() {
        return Paths.get(this.path, new String[0]);
    }

    public String getRawPath() {
        return this.path;
    }

    public Optional<FilePosition> getPosition() {
        return Optional.ofNullable(this.position);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSelector that = (FileSelector)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.position, that.position);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return Objects.hash(this.path, this.position);
    }

    public String toString() {
        return new ToStringBuilder(this).append("path", this.path).append("position", this.position).toString();
    }
}

