/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.commons.support;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.JUnitException;
import org.gradle.internal.impldep.org.junit.platform.commons.function.Try;
import org.gradle.internal.impldep.org.junit.platform.commons.support.HierarchyTraversalMode;
import org.gradle.internal.impldep.org.junit.platform.commons.util.Preconditions;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.MAINTAINED, since="1.0")
public final class ReflectionSupport {
    private ReflectionSupport() {
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static Optional<Class<?>> loadClass(String name) {
        return ReflectionUtils.loadClass(name);
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static Try<Class<?>> tryToLoadClass(String name) {
        return ReflectionUtils.tryToLoadClass(name);
    }

    public static List<Class<?>> findAllClassesInClasspathRoot(URI root, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInClasspathRoot(root, classFilter, classNameFilter);
    }

    public static List<Class<?>> findAllClassesInPackage(String basePackageName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInPackage(basePackageName, classFilter, classNameFilter);
    }

    public static List<Class<?>> findAllClassesInModule(String moduleName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInModule(moduleName, classFilter, classNameFilter);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        return ReflectionUtils.newInstance(clazz, args);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        return ReflectionUtils.invokeMethod(method, target, args);
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static List<Field> findFields(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return ReflectionUtils.findFields(clazz, predicate, ReflectionUtils.HierarchyTraversalMode.valueOf(traversalMode.name()));
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static Try<Object> tryToReadFieldValue(Field field, Object instance) {
        return ReflectionUtils.tryToReadFieldValue(field, instance);
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, String parameterTypeNames) {
        return ReflectionUtils.findMethod(clazz, methodName, parameterTypeNames);
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.findMethod(clazz, methodName, parameterTypes);
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return ReflectionUtils.findMethods(clazz, predicate, ReflectionUtils.HierarchyTraversalMode.valueOf(traversalMode.name()));
    }

    public static List<Class<?>> findNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) throws JUnitException {
        return ReflectionUtils.findNestedClasses(clazz, predicate);
    }
}

