/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.jcifs.smb;

import org.gradle.internal.impldep.jcifs.smb.ServerMessageBlock;
import org.gradle.internal.impldep.jcifs.util.Hexdump;

class SmbComRename
extends ServerMessageBlock {
    private int searchAttributes;
    private String oldFileName;
    private String newFileName;

    SmbComRename(String oldFileName, String newFileName) {
        this.command = (byte)7;
        this.oldFileName = oldFileName;
        this.newFileName = newFileName;
        this.searchAttributes = 22;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        SmbComRename.writeInt2(this.searchAttributes, dst, dstIndex);
        return 2;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex++] = 4;
        dstIndex += this.writeString(this.oldFileName, dst, dstIndex);
        dst[dstIndex++] = 4;
        if (this.useUnicode) {
            dst[dstIndex++] = 0;
        }
        dstIndex += this.writeString(this.newFileName, dst, dstIndex);
        return dstIndex - start;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    public String toString() {
        return new String("SmbComRename[" + super.toString() + ",searchAttributes=0x" + Hexdump.toHexString(this.searchAttributes, 4) + ",oldFileName=" + this.oldFileName + ",newFileName=" + this.newFileName + "]");
    }
}

