/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.IdeaDecompiler;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0015\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/java/decompiler/IdeaLogger;", "Lorg/jetbrains/java/decompiler/main/extern/IFernflowerLogger;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "myClass", "", "endClass", "", "endMethod", "endReadingClass", "endWriteClass", "extendMessage", "message", "startClass", "className", "startMethod", "methodName", "startReadingClass", "startWriteClass", "writeMessage", "severity", "Lorg/jetbrains/java/decompiler/main/extern/IFernflowerLogger$Severity;", "t", "", "InternalException", "intellij.java.decompiler"})
@SourceDebugExtension(value={"SMAP\nIdeaLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaLogger.kt\norg/jetbrains/java/decompiler/IdeaLogger\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n10#2:72\n*S KotlinDebug\n*F\n+ 1 IdeaLogger.kt\norg/jetbrains/java/decompiler/IdeaLogger\n*L\n11#1:72\n*E\n"})
public final class IdeaLogger
extends IFernflowerLogger {
    @NotNull
    private final Logger LOG;
    @Nullable
    private String myClass;

    public IdeaLogger() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IdeaDecompiler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        this.LOG = logger;
    }

    private static /* synthetic */ void getLOG$annotations() {
    }

    @Override
    public void writeMessage(@NotNull String message, @NotNull IFernflowerLogger.Severity severity) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        String text = this.extendMessage(message);
        switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: {
                this.LOG.warn(text);
                break;
            }
            case 2: {
                this.LOG.warn(text);
                break;
            }
            case 3: {
                this.LOG.info(text);
                break;
            }
            default: {
                this.LOG.debug(text);
            }
        }
    }

    @Override
    public void writeMessage(@NotNull String message, @NotNull IFernflowerLogger.Severity severity, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Throwable throwable = t;
        if (throwable instanceof InternalException) {
            throw t;
        }
        if (throwable instanceof ProcessCanceledException) {
            throw t;
        }
        if (throwable instanceof InterruptedException) {
            throw new ProcessCanceledException(t);
        }
        if (severity == IFernflowerLogger.Severity.ERROR) {
            throw new InternalException(this.extendMessage(message), t);
        }
        String text = this.extendMessage(message);
        switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 2: {
                this.LOG.warn(text, t);
                break;
            }
            case 3: {
                this.LOG.info(text, t);
                break;
            }
            default: {
                this.LOG.debug(text, t);
            }
        }
    }

    private final String extendMessage(String message) {
        return this.myClass != null ? message + " [" + this.myClass + "]" : message;
    }

    @Override
    public void startReadingClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.LOG.debug("decompiling class " + className);
        this.myClass = className;
    }

    @Override
    public void endReadingClass() {
        this.LOG.debug("... class decompiled");
        this.myClass = null;
    }

    @Override
    public void startClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.LOG.debug("processing class " + className);
    }

    @Override
    public void endClass() {
        this.LOG.debug("... class processed");
    }

    @Override
    public void startMethod(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        this.LOG.debug("processing method " + methodName);
    }

    @Override
    public void endMethod() {
        this.LOG.debug("... method processed");
    }

    @Override
    public void startWriteClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.LOG.debug("writing class " + className);
    }

    @Override
    public void endWriteClass() {
        this.LOG.debug("... class written");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/java/decompiler/IdeaLogger$InternalException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "intellij.java.decompiler"})
    public static final class InternalException
    extends RuntimeException {
        public InternalException(@NotNull String message, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(message, cause);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IFernflowerLogger.Severity.values().length];
            try {
                nArray[IFernflowerLogger.Severity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IFernflowerLogger.Severity.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IFernflowerLogger.Severity.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

