/*
 * Decompiled with CFR 0.152.
 */
package org.testng.util;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.collections.Maps;

public final class Strings {
    private static final Map<String, String> ESCAPE_HTML_MAP = Maps.newLinkedHashMap();

    private Strings() {
    }

    public static boolean isNullOrEmpty(String string) {
        return Optional.ofNullable(string).orElse("").trim().isEmpty();
    }

    public static boolean isNotNullAndNotEmpty(String string) {
        return !Strings.isNullOrEmpty(string);
    }

    public static String escapeHtml(String text) {
        String result = text;
        for (Map.Entry<String, String> entry : ESCAPE_HTML_MAP.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static String valueOf(Map<?, ?> m) {
        return m.values().stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    public static String join(String delimiter, String[] parts) {
        return String.join((CharSequence)delimiter, parts);
    }

    static {
        ESCAPE_HTML_MAP.put("&", "&amp;");
        ESCAPE_HTML_MAP.put("<", "&lt;");
        ESCAPE_HTML_MAP.put(">", "&gt;");
    }
}

